/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.internal.platform.AsymmetricAlgorithm;
import com.microsoft.identity.common.internal.platform.CryptoSuite;
import com.microsoft.identity.common.internal.platform.IDevicePopManager;
import java.security.KeyStore;

public enum AsymmetricCipher implements CryptoSuite
{
    RSA_NONE_OAEPWithSHA_1AndMGF1PaddingAndHmacSha256{

        @Override
        public AsymmetricAlgorithm cipher() {
            return AsymmetricAlgorithm.Builder.of("RSA/NONE/OAEPWithSHA_1AndMGF1Padding");
        }

        @Override
        public String macName() {
            return "HmacSHA256";
        }

        @Override
        public boolean isAsymmetric() {
            return true;
        }

        @Override
        public Class<? extends KeyStore.Entry> keyClass() {
            return KeyStore.PrivateKeyEntry.class;
        }

        @Override
        public int keySize() {
            return 2048;
        }

        @Override
        @RequiresApi(api=18)
        public IDevicePopManager.SigningAlgorithm signingAlgorithm() {
            return IDevicePopManager.SigningAlgorithm.SHA_256_WITH_RSA;
        }
    }
    ,
    RSA_ECB_PKCS1_PADDING_HMACSHA256{

        @Override
        public AsymmetricAlgorithm cipher() {
            return AsymmetricAlgorithm.Builder.of("RSA/ECB/PKCS1Padding");
        }

        @Override
        public String macName() {
            return "HmacSHA256";
        }

        @Override
        public boolean isAsymmetric() {
            return true;
        }

        @Override
        public Class<? extends KeyStore.Entry> keyClass() {
            return KeyStore.PrivateKeyEntry.class;
        }

        @Override
        public int keySize() {
            return 2048;
        }

        @Override
        @RequiresApi(api=18)
        public IDevicePopManager.SigningAlgorithm signingAlgorithm() {
            return IDevicePopManager.SigningAlgorithm.SHA_256_WITH_RSA;
        }
    };

}

