/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.net;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public final class ObjectMapper {
    public static final String ENCODING_SCHEME = "UTF-8";
    public static final String TAG = ObjectMapper.class.getSimpleName();

    private ObjectMapper() {
    }

    public static String serializeObjectToJsonString(Object object) {
        return new Gson().toJson(object);
    }

    public static String serializeExposedFieldsOfObjectToJsonString(Object object) {
        GsonBuilder builder = new GsonBuilder();
        builder.excludeFieldsWithoutExposeAnnotation();
        Gson gson = builder.create();
        return gson.toJson(object);
    }

    public static <T> T deserializeJsonStringToObject(String json, Class<T> objectClass) {
        return (T)new Gson().fromJson(json, objectClass);
    }

    public static String serializeObjectToFormUrlEncoded(Object object) throws UnsupportedEncodingException {
        String json = ObjectMapper.serializeObjectToJsonString(object);
        Type stringMap = new TypeToken<TreeMap<String, String>>(){}.getType();
        TreeMap fields = (TreeMap)new Gson().fromJson(json, stringMap);
        StringBuilder builder = new StringBuilder();
        Iterator iterator = fields.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            builder.append(URLEncoder.encode((String)entry.getKey(), ENCODING_SCHEME));
            builder.append('=');
            builder.append(URLEncoder.encode((String)entry.getValue(), ENCODING_SCHEME));
            if (!iterator.hasNext()) continue;
            builder.append('&');
        }
        return builder.toString();
    }

    public static Map<String, Object> serializeObjectHashMap(Object object) {
        String json = ObjectMapper.serializeObjectToJsonString(object);
        Map objectHashMap = (Map)new Gson().fromJson(json, Map.class);
        return objectHashMap;
    }

    public static Map<String, String> deserializeQueryStringToMap(String queryString) {
        HashMap<String, String> decodedUrlMap = new HashMap<String, String>();
        if (StringUtil.isEmpty(queryString)) {
            return decodedUrlMap;
        }
        StringTokenizer tokenizer = new StringTokenizer(queryString, "&");
        while (tokenizer.hasMoreTokens()) {
            String pair = tokenizer.nextToken();
            String[] elements = pair.split("=");
            if (elements.length != 2) continue;
            try {
                String key = URLDecoder.decode(elements[0], ENCODING_SCHEME);
                String value = URLDecoder.decode(elements[1], ENCODING_SCHEME);
                if (StringUtil.isEmpty(key) || StringUtil.isEmpty(value)) continue;
                decodedUrlMap.put(key, value);
            }
            catch (UnsupportedEncodingException e) {
                Logger.error(TAG, null, "Decode failed.", e);
            }
        }
        return decodedUrlMap;
    }
}

