/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.cache.ISharedPreferencesFileManager;
import com.microsoft.identity.common.internal.cache.ISharedPrefsFileManagerReencrypter;
import com.microsoft.identity.common.internal.controllers.TaskCompletedCallbackWithError;
import java.util.HashMap;
import java.util.Map;

public class DefaultSharedPrefsFileManagerReencrypter
implements ISharedPrefsFileManagerReencrypter {
    @Override
    public void reencrypt(@NonNull ISharedPreferencesFileManager fileManager, @NonNull ISharedPrefsFileManagerReencrypter.IStringEncrypter encrypter, @NonNull ISharedPrefsFileManagerReencrypter.IStringDecrypter decrypter, @NonNull ISharedPrefsFileManagerReencrypter.ReencryptionParams params) throws Exception {
        HashMap<String, String> cacheEntries = new HashMap<String, String>(fileManager.getAll());
        for (Map.Entry entry : cacheEntries.entrySet()) {
            String clearTextKey = (String)entry.getKey();
            String encryptedTextValye = (String)entry.getValue();
            try {
                String decryptedTextValue = decrypter.decrypt(encryptedTextValye);
                String reencryptedTextValue = encrypter.encrypt(decryptedTextValue);
                fileManager.putString(clearTextKey, reencryptedTextValue);
            }
            catch (Exception e) {
                if (params.eraseEntryOnError()) {
                    fileManager.remove(clearTextKey);
                }
                if (params.eraseAllOnError()) {
                    fileManager.clear();
                    if (!params.abortOnError()) break;
                    throw e;
                }
                if (!params.abortOnError()) continue;
                throw e;
            }
        }
    }

    @Override
    public void reencryptAsync(final @NonNull ISharedPreferencesFileManager fileManager, final @NonNull ISharedPrefsFileManagerReencrypter.IStringEncrypter encrypter, final @NonNull ISharedPrefsFileManagerReencrypter.IStringDecrypter decrypter, final @NonNull ISharedPrefsFileManagerReencrypter.ReencryptionParams params, final @NonNull TaskCompletedCallbackWithError<Void, Exception> callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultSharedPrefsFileManagerReencrypter.this.reencrypt(fileManager, encrypter, decrypter, params);
                    callback.onTaskCompleted(null);
                }
                catch (Exception e) {
                    callback.onError(e);
                }
            }
        }).start();
    }
}

