/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.authscheme;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.internal.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.internal.authscheme.BearerAuthenticationSchemeInternal;
import com.microsoft.identity.common.internal.authscheme.INameable;
import com.microsoft.identity.common.internal.authscheme.IPoPAuthenticationSchemeParams;
import com.microsoft.identity.common.internal.authscheme.PopAuthenticationSchemeInternal;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.util.ClockSkewManager;

public class AuthenticationSchemeFactory {
    private static final String TAG = AuthenticationSchemeFactory.class.getSimpleName();

    public static AbstractAuthenticationScheme createScheme(@NonNull Context context, @Nullable INameable nameable) {
        if (null == nameable) {
            return new BearerAuthenticationSchemeInternal();
        }
        switch (nameable.getName()) {
            case "Bearer": {
                Logger.verbose(TAG, "Constructing Bearer Authentication Scheme.");
                return new BearerAuthenticationSchemeInternal();
            }
            case "PoP": {
                if (nameable instanceof IPoPAuthenticationSchemeParams) {
                    Logger.verbose(TAG, "Constructing PoP Authentication Scheme.");
                    IPoPAuthenticationSchemeParams params = (IPoPAuthenticationSchemeParams)((Object)nameable);
                    ClockSkewManager clockSkewManager = new ClockSkewManager(context);
                    return new PopAuthenticationSchemeInternal(clockSkewManager, params.getHttpMethod(), params.getUrl(), params.getNonce(), params.getClientClaims());
                }
                throw new IllegalStateException("Unrecognized parameter type.");
            }
        }
        throw new UnsupportedOperationException("Unknown or unsupported scheme: " + nameable.getName());
    }
}

