/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.text.TextUtils;
import android.webkit.ClientCertRequest;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.broker.PackageHelper;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.ui.webview.OAuth2WebViewClient;
import com.microsoft.identity.common.internal.ui.webview.OnPageLoadedCallback;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.ClientCertAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.IAuthorizationCompletionCallback;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.PKeyAuthChallenge;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.PKeyAuthChallengeFactory;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.PKeyAuthChallengeHandler;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Locale;

public class AzureActiveDirectoryWebViewClient
extends OAuth2WebViewClient {
    private static final String TAG = AzureActiveDirectoryWebViewClient.class.getSimpleName();
    public static final String ERROR = "error";
    public static final String ERROR_SUBCODE = "error_subcode";
    public static final String ERROR_DESCRIPTION = "error_description";
    private final String mRedirectUrl;

    public AzureActiveDirectoryWebViewClient(@NonNull Activity activity, @NonNull IAuthorizationCompletionCallback completionCallback, @NonNull OnPageLoadedCallback pageLoadedCallback, @NonNull String redirectUrl) {
        super(activity, completionCallback, pageLoadedCallback);
        this.mRedirectUrl = redirectUrl;
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (StringUtil.isEmpty(url)) {
            throw new IllegalArgumentException("Redirect to empty url in web view.");
        }
        return this.handleUrl(view, url);
    }

    @TargetApi(value=24)
    @RequiresApi(value=24)
    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        Uri requestUrl = request.getUrl();
        return this.handleUrl(view, requestUrl.toString());
    }

    private boolean handleUrl(WebView view, String url) {
        String formattedURL = url.toLowerCase(Locale.US);
        if (this.isPkeyAuthUrl(formattedURL)) {
            Logger.info(TAG, "WebView detected request for pkeyauth challenge.");
            try {
                PKeyAuthChallengeFactory factory = new PKeyAuthChallengeFactory();
                PKeyAuthChallenge pKeyAuthChallenge = factory.getPKeyAuthChallenge(url);
                PKeyAuthChallengeHandler pKeyAuthChallengeHandler = new PKeyAuthChallengeHandler(view, this.getCompletionCallback());
                pKeyAuthChallengeHandler.processChallenge(pKeyAuthChallenge);
            }
            catch (ClientException exception) {
                Logger.error(TAG, exception.getErrorCode(), null);
                Logger.errorPII(TAG, exception.getMessage(), exception);
                this.returnError(exception.getErrorCode(), exception.getMessage());
                view.stopLoading();
            }
        } else if (this.isRedirectUrl(formattedURL)) {
            Logger.info(TAG, "Navigation starts with the redirect uri.");
            this.processRedirectUrl(view, url);
        } else if (this.isWebsiteRequestUrl(formattedURL)) {
            Logger.info(TAG, "It is an external website request");
            this.processWebsiteRequest(view, url);
        } else if (this.isInstallRequestUrl(formattedURL)) {
            Logger.info(TAG, "It is an install request");
            this.processInstallRequest(view, url);
        } else if (this.isWebCpUrl(formattedURL)) {
            Logger.info(TAG, "It is a request from WebCP");
            this.processWebCpRequest(view, url);
        } else {
            if (this.isPlayStoreUrl(formattedURL)) {
                Logger.info(TAG, "Request to open PlayStore.");
                return this.processPlayStoreURL(view, url);
            }
            if (this.isAuthAppMFAUrl(formattedURL)) {
                Logger.info(TAG, "Request to link account with Authenticator.");
                this.processAuthAppMFAUrl(url);
            } else if (this.isInvalidRedirectUri(url)) {
                Logger.info(TAG, "Check for Redirect Uri.");
                this.processInvalidRedirectUri(view, url);
            } else if (this.isBlankPageRequest(formattedURL)) {
                Logger.info(TAG, "It is an blank page request");
            } else if (this.isUriSSLProtected(formattedURL)) {
                Logger.info(TAG, "Check for SSL protection");
                this.processSSLProtectionCheck(view, url);
            } else {
                Logger.info(TAG, "This maybe a valid URI, but no special handling for this mentioned URI, hence deferring to WebView for loading.");
                this.processInvalidUrl(url);
                return false;
            }
        }
        return true;
    }

    private boolean isUriSSLProtected(@NonNull String url) {
        return !url.startsWith("https://");
    }

    private boolean isBlankPageRequest(@NonNull String url) {
        return "about:blank".equals(url);
    }

    private boolean isInvalidRedirectUri(@NonNull String url) {
        return this.isBrokerRequest(this.getActivity().getIntent()) && url.startsWith("msauth");
    }

    private boolean isAuthAppMFAUrl(@NonNull String url) {
        return url.startsWith("microsoft-authenticator://activatemfa");
    }

    private boolean isPlayStoreUrl(@NonNull String url) {
        return url.startsWith("market://details?id=");
    }

    private boolean isPkeyAuthUrl(@NonNull String url) {
        return url.startsWith("urn:http-auth:PKeyAuth".toLowerCase(Locale.ROOT));
    }

    private boolean isRedirectUrl(@NonNull String url) {
        return url.startsWith(this.mRedirectUrl.toLowerCase(Locale.US));
    }

    private boolean isWebsiteRequestUrl(@NonNull String url) {
        return url.startsWith("browser://");
    }

    private boolean isInstallRequestUrl(@NonNull String url) {
        return url.startsWith("msauth://");
    }

    private boolean isBrokerRequest(Intent callingIntent) {
        return callingIntent != null && !StringExtensions.isNullOrBlank(callingIntent.getStringExtra("com.microsoft.aadbroker.adal.broker.request"));
    }

    private boolean isWebCpUrl(@NonNull String url) {
        return url.startsWith("companyportal://");
    }

    protected void processRedirectUrl(@NonNull WebView view, @NonNull String url) {
        HashMap<String, String> parameters = StringExtensions.getUrlParameters(url);
        if (!StringExtensions.isNullOrBlank((String)parameters.get(ERROR))) {
            Logger.info(TAG, "Sending intent to cancel authentication activity");
            Intent resultIntent = new Intent();
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", (String)parameters.get(ERROR));
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorSubCode", (String)parameters.get(ERROR_SUBCODE));
            if (!StringUtil.isEmpty((String)parameters.get(ERROR_DESCRIPTION))) {
                resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", (String)parameters.get(ERROR_DESCRIPTION));
            } else {
                resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", (String)parameters.get(ERROR_SUBCODE));
            }
            if (StringUtil.equalsIgnoreCase((String)parameters.get(ERROR_SUBCODE), "cancel")) {
                this.getCompletionCallback().onChallengeResponseReceived(2001, resultIntent);
            } else {
                this.getCompletionCallback().onChallengeResponseReceived(2002, resultIntent);
            }
            view.stopLoading();
        } else {
            Logger.info(TAG, "It is pointing to redirect. Final url can be processed to get the code or error.");
            Intent resultIntent = new Intent();
            resultIntent.putExtra("com.microsoft.identity.client.final.url", url);
            this.getCompletionCallback().onChallengeResponseReceived(2003, resultIntent);
            view.stopLoading();
        }
    }

    private void processWebsiteRequest(@NonNull WebView view, @NonNull String url) {
        String methodName = "#processWebsiteRequest";
        view.stopLoading();
        if (url.contains("&ismdmurl=1")) {
            Logger.info(TAG + "#processWebsiteRequest", "This is a device CA request.");
            PackageHelper packageHelper = new PackageHelper(this.getActivity().getPackageManager());
            Context applicationContext = this.getActivity().getApplicationContext();
            if (packageHelper.isPackageInstalledAndEnabled(applicationContext, "com.microsoft.skype.teams.ipphone") && "fcg80qvoM1YMKJZibjBwQcDfOno=".equals(packageHelper.getCurrentSignatureForPackage("com.microsoft.skype.teams.ipphone")) && packageHelper.isPackageInstalledAndEnabled(applicationContext, "com.microsoft.windowsintune.companyportal")) {
                try {
                    this.launchCompanyPortal();
                    return;
                }
                catch (Exception ex) {
                    Logger.warn(TAG + "#processWebsiteRequest", "Failed to launch Company Portal, falling back to browser.");
                }
            }
            this.openLinkInBrowser(url);
            this.getCompletionCallback().onChallengeResponseReceived(2009, new Intent());
            return;
        }
        this.openLinkInBrowser(url);
        this.getCompletionCallback().onChallengeResponseReceived(2001, new Intent());
    }

    private boolean processPlayStoreURL(@NonNull WebView view, @NonNull String url) {
        String methodName = "#processPlayStoreURL";
        view.stopLoading();
        if (!url.startsWith("market://details?id=com.microsoft.windowsintune.companyportal") && !url.startsWith("market://details?id=com.azure.authenticator")) {
            Logger.info(TAG + "#processPlayStoreURL", "The URI is either trying to open an unknown application or contains unknown query parameters");
            return false;
        }
        String appPackageName = url.contains("com.microsoft.windowsintune.companyportal") ? "com.microsoft.windowsintune.companyportal" : "com.azure.authenticator";
        Logger.info(TAG + "#processPlayStoreURL", "Request to open PlayStore to install package : '" + appPackageName + "'");
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + appPackageName)));
            intent.addFlags(0x10008000);
            this.getActivity().startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Logger.error(TAG + "#processPlayStoreURL", "PlayStore is not present on the device", e);
        }
        return true;
    }

    private void processAuthAppMFAUrl(String url) {
        String methodName = "#processAuthAppMFAUrl";
        Logger.verbose(TAG + "#processAuthAppMFAUrl", "Linking Account in Broker for MFA.");
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            intent.addFlags(0x10000000);
            this.getActivity().startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Logger.error(TAG, "Failed to open the Authenticator application.", e);
        }
    }

    private void launchCompanyPortal() {
        String methodName = "#launchCompanyPortal";
        Logger.verbose(TAG + "#launchCompanyPortal", "Sending intent to launch the CompanyPortal.");
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.microsoft.windowsintune.companyportal", "com.microsoft.windowsintune.companyportal.views.SplashActivity"));
        intent.addFlags(0x10008000);
        this.getActivity().startActivity(intent);
        this.getCompletionCallback().onChallengeResponseReceived(2009, new Intent());
    }

    private void openLinkInBrowser(String url) {
        String methodName = "#openLinkInBrowser";
        Logger.info(TAG + "#openLinkInBrowser", "Try to open url link in browser");
        String link = url.replace("browser://", "https://");
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)link));
        if (intent.resolveActivity(this.getActivity().getPackageManager()) != null) {
            this.getActivity().startActivity(intent);
        } else {
            Logger.warn(TAG + "#openLinkInBrowser", "Unable to find an app to resolve the activity.");
        }
    }

    private void processWebCpRequest(@NonNull WebView view, @NonNull String url) {
        view.stopLoading();
        if (url.equalsIgnoreCase("companyportal://enrollment")) {
            this.launchCompanyPortal();
            return;
        }
        this.returnError("webcp_uri_invalid", "Unexpected URL from WebCP: " + url);
    }

    private void processInstallRequest(final @NonNull WebView view, @NonNull String url) {
        Intent resultIntent = new Intent();
        HashMap<String, String> parameters = StringExtensions.getUrlParameters(url);
        final String installLink = parameters.get("app_link");
        String userName = parameters.get("username");
        if (TextUtils.isEmpty((CharSequence)installLink)) {
            Logger.info(TAG, "Install link is null or empty, Return to caller with BROWSER_CODE_DEVICE_REGISTER");
            resultIntent.putExtra("username", userName);
            this.getCompletionCallback().onChallengeResponseReceived(2007, resultIntent);
            view.stopLoading();
            return;
        }
        Logger.info(TAG, "Return to caller with BROKER_REQUEST_RESUME, and waiting for result.");
        this.getCompletionCallback().onChallengeResponseReceived(2006, resultIntent);
        Handler handler = new Handler();
        int threadSleepForCallingActivity = 1000;
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                String link = installLink.replace("browser://", "https://");
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)link));
                AzureActiveDirectoryWebViewClient.this.getActivity().startActivity(intent);
                view.stopLoading();
            }
        }, 1000L);
    }

    private void processInvalidRedirectUri(@NonNull WebView view, @NonNull String url) {
        String methodName = "#processInvalidRedirectUri";
        Logger.error(TAG + "#processInvalidRedirectUri", "The RedirectUri is not as expected.", null);
        Logger.errorPII(TAG, String.format("Received %s and expected %s", url, this.mRedirectUrl), null);
        this.returnError("The redirectUri for broker is invalid", String.format("The RedirectUri is not as expected. Received %s and expected %s", url, this.mRedirectUrl));
        view.stopLoading();
    }

    private void processSSLProtectionCheck(@NonNull WebView view, @NonNull String url) {
        String redactedUrl = this.removeQueryParametersOrRedact(url);
        Logger.error(TAG, "The webView was redirected to an unsafe URL: " + redactedUrl, null);
        this.returnError("Redirect url scheme not SSL protected", "The webView was redirected to an unsafe URL.");
        view.stopLoading();
    }

    private void processInvalidUrl(@NonNull String url) {
        Logger.infoPII(TAG, "We are declining to override loading and redirect to invalid URL: '" + this.removeQueryParametersOrRedact(url) + "' the user's url pattern is '" + this.mRedirectUrl + "'");
    }

    private String removeQueryParametersOrRedact(@NonNull String url) {
        try {
            return StringExtensions.removeQueryParameterFromUrl(url);
        }
        catch (URISyntaxException e) {
            Logger.errorPII(TAG, "Redirect URI has invalid syntax, unable to parse", e);
            return "redacted";
        }
    }

    private void returnError(String errorCode, String errorMessage) {
        Intent resultIntent = new Intent();
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", errorCode);
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", errorMessage);
        this.getCompletionCallback().onChallengeResponseReceived(2002, resultIntent);
    }

    @TargetApi(value=21)
    public void onReceivedClientCertRequest(WebView view, ClientCertRequest clientCertRequest) {
        ClientCertAuthChallengeHandler clientCertAuthChallengeHandler = new ClientCertAuthChallengeHandler(this.getActivity());
        clientCertAuthChallengeHandler.processChallenge(clientCertRequest);
    }
}

