/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.adal.internal.cache;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.preference.PreferenceManager;
import android.security.KeyPairGeneratorSpec;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.microsoft.identity.common.adal.internal.AuthenticationSettings;
import com.microsoft.identity.common.adal.internal.cache.IStorageHelper;
import com.microsoft.identity.common.adal.internal.cache.IWpjTelemetryCallback;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.util.DateUtilities;
import com.microsoft.identity.common.internal.util.ProcessUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;

public class StorageHelper
implements IStorageHelper {
    private static final String TAG = "StorageHelper";
    @VisibleForTesting(otherwise=2)
    public static final AtomicReference<String> LAST_KNOWN_THUMBPRINT = new AtomicReference<String>("");
    private static final AtomicBoolean FIRST_TIME = new AtomicBoolean(false);
    public static final boolean sShouldEncryptWithKeyStoreKey = false;
    private static final String HMAC_KEY_HASH_ALGORITHM = "SHA256";
    private static final String KEY_STORE_CERT_ALIAS = "AdalKey";
    private static final String ADALKS = "adalks";
    private static final String KEYSPEC_ALGORITHM = "AES";
    private static final String WRAP_ALGORITHM = "RSA/ECB/PKCS1Padding";
    private static final String CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final String CIPHER_ALGORITHM_FOR_KEY_TRACKING = "AES/ECB/PKCS5Padding";
    private static final String HMAC_ALGORITHM = "HmacSHA256";
    private static final String CURRENT_ACTIVE_BROKER = "current_active_broker";
    private static final int KEY_SIZE = 256;
    public static final int DATA_KEY_LENGTH = 16;
    public static final int HMAC_LENGTH = 32;
    public static final String VERSION_ANDROID_KEY_STORE = "A001";
    public static final String VERSION_USER_DEFINED = "U001";
    private static final int KEY_VERSION_BLOB_LENGTH = 4;
    private static final String ENCODE_VERSION = "E1";
    private static final int KEY_FILE_SIZE = 1024;
    private static final String ANDROID_KEY_STORE = "AndroidKeyStore";
    private final Context mContext;
    private final SecureRandom mRandom;
    private IWpjTelemetryCallback mTelemetryCallback;
    private KeyPair mKeyPair;
    private String mBlobVersion;
    private SecretKey mEncryptionKey = null;
    private SecretKey mEncryptionHMACKey = null;
    private SecretKey mCachedKeyStoreEncryptedKey = null;

    public StorageHelper(@NonNull Context context) {
        this(context, null);
    }

    @SuppressLint(value={"TrulyRandom"})
    public StorageHelper(@NonNull Context context, @Nullable IWpjTelemetryCallback telemetryCallback) {
        this.mContext = context.getApplicationContext();
        this.mRandom = new SecureRandom();
        this.mTelemetryCallback = telemetryCallback;
    }

    protected String getPackageName() {
        return this.mContext.getPackageName();
    }

    protected boolean isBrokerProcess() {
        return ProcessUtil.isBrokerProcess(this.mContext);
    }

    @Override
    public String encrypt(String clearText) throws GeneralSecurityException, IOException {
        String methodName = ":encrypt";
        if (StringExtensions.isNullOrBlank(clearText)) {
            throw new IllegalArgumentException("Input is empty or null");
        }
        Logger.verbose("StorageHelper:encrypt", "Starting encryption");
        this.mEncryptionKey = this.loadSecretKeyForEncryption();
        this.mEncryptionHMACKey = this.getHMacKey(this.mEncryptionKey);
        this.logIfKeyHasChanged(this.mEncryptionKey, this.mEncryptionHMACKey);
        Logger.verbose("StorageHelper:encrypt", "Encrypt version:" + this.mBlobVersion);
        byte[] blobVersion = this.mBlobVersion.getBytes("UTF-8");
        byte[] bytes = clearText.getBytes("UTF-8");
        byte[] iv = new byte[16];
        this.mRandom.nextBytes(iv);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        Mac mac = Mac.getInstance(HMAC_ALGORITHM);
        cipher.init(1, (Key)this.mEncryptionKey, ivSpec);
        byte[] encrypted = cipher.doFinal(bytes);
        mac.init(this.mEncryptionHMACKey);
        mac.update(blobVersion);
        mac.update(encrypted);
        mac.update(iv);
        byte[] macDigest = mac.doFinal();
        byte[] blobVerAndEncryptedDataAndIVAndMacDigest = new byte[blobVersion.length + encrypted.length + iv.length + macDigest.length];
        System.arraycopy(blobVersion, 0, blobVerAndEncryptedDataAndIVAndMacDigest, 0, blobVersion.length);
        System.arraycopy(encrypted, 0, blobVerAndEncryptedDataAndIVAndMacDigest, blobVersion.length, encrypted.length);
        System.arraycopy(iv, 0, blobVerAndEncryptedDataAndIVAndMacDigest, blobVersion.length + encrypted.length, iv.length);
        System.arraycopy(macDigest, 0, blobVerAndEncryptedDataAndIVAndMacDigest, blobVersion.length + encrypted.length + iv.length, macDigest.length);
        String encryptedText = new String(Base64.encode((byte[])blobVerAndEncryptedDataAndIVAndMacDigest, (int)2), "UTF-8");
        Logger.verbose("StorageHelper:encrypt", "Finished encryption");
        return this.getEncodeVersionLengthPrefix() + ENCODE_VERSION + encryptedText;
    }

    @VisibleForTesting(otherwise=5)
    public String testThumbprint() throws IOException, GeneralSecurityException {
        SecretKey secretKey = this.loadSecretKeyForEncryption();
        return this.getKeyThumbPrint(secretKey, this.getHMacKey(secretKey));
    }

    @VisibleForTesting(otherwise=5)
    public boolean testKeyChange() throws IOException, GeneralSecurityException {
        SecretKey secretKey = this.loadSecretKeyForEncryption();
        return this.logIfKeyHasChanged(secretKey, this.getHMacKey(secretKey));
    }

    private String getKeyThumbPrint(@NonNull SecretKey secretKey, @NonNull SecretKey hmacKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Cipher thumbPrintCipher = Cipher.getInstance(CIPHER_ALGORITHM_FOR_KEY_TRACKING);
        byte[] thumbprintBytes = "012345678910111213141516".getBytes();
        thumbPrintCipher.init(1, secretKey);
        byte[] bytesOut = thumbPrintCipher.doFinal(thumbprintBytes);
        Mac thumbprintMac = Mac.getInstance(HMAC_ALGORITHM);
        thumbprintMac.init(hmacKey);
        byte[] thumprintFinal = thumbprintMac.doFinal(bytesOut);
        return Base64.encodeToString((byte[])thumprintFinal, (int)3);
    }

    @Override
    public String decrypt(String encryptedBlob) throws GeneralSecurityException, IOException {
        String methodName = ":decrypt";
        Logger.verbose("StorageHelper:decrypt", "Starting decryption");
        if (StringExtensions.isNullOrBlank(encryptedBlob)) {
            throw new IllegalArgumentException("Input is empty or null");
        }
        if (this.getEncryptionType(encryptedBlob) == EncryptionType.UNENCRYPTED) {
            Logger.warn("StorageHelper:decrypt", "This string is not encrypted. Finished decryption.");
            return encryptedBlob;
        }
        if (this.mTelemetryCallback != null) {
            try {
                SecretKey key = this.loadSecretKey(KeyType.KEYSTORE_ENCRYPTED_KEY);
                if (key == null) {
                    this.mTelemetryCallback.logEvent(this.mContext, ":decrypt", false, "KEY_DECRYPTION_KEYSTORE_KEY_NOT_INITIALIZED");
                }
            }
            catch (Exception e) {
                this.mTelemetryCallback.logEvent(this.mContext, ":decrypt", false, "KEY_DECRYPTION_KEYSTORE_KEY_FAILED_TO_LOAD");
            }
        }
        String packageName = this.getPackageName();
        List<KeyType> keysForDecryptionType = this.getKeysForDecryptionType(encryptedBlob, packageName);
        byte[] bytes = this.getByteArrayFromEncryptedBlob(encryptedBlob);
        for (KeyType keyType : keysForDecryptionType) {
            try {
                SecretKey secretKey = this.loadSecretKey(keyType);
                if (secretKey == null) continue;
                String result = this.decryptWithSecretKey(bytes, secretKey);
                Logger.verbose("StorageHelper:decrypt", "Finished decryption with keyType:" + keyType.name());
                return result;
            }
            catch (IOException | GeneralSecurityException e) {
                this.emitDecryptionFailureTelemetryIfNeeded(keyType, e);
            }
        }
        Logger.info("StorageHelper:decrypt", "Tried all decryption keys and decryption still fails. Throw an exception.");
        throw new GeneralSecurityException("decryption_failed");
    }

    private void emitDecryptionFailureTelemetryIfNeeded(@NonNull KeyType keyType, @NonNull Exception exception) {
        String activeBroker;
        String methodName = ":emitDecryptionFailureTelemetryIfNeeded";
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.mContext);
        String previousActiveBroker = sharedPreferences.getString(CURRENT_ACTIVE_BROKER, "");
        if (!previousActiveBroker.equalsIgnoreCase(activeBroker = this.mContext.getPackageName())) {
            String message = "Decryption failed with key: " + keyType.name() + " Active broker: " + activeBroker + " Exception: " + exception.toString();
            Logger.info("StorageHelper:emitDecryptionFailureTelemetryIfNeeded", message);
            if (this.mTelemetryCallback != null) {
                this.mTelemetryCallback.logEvent(this.mContext, "decryption_error_v2", true, message);
            }
            sharedPreferences.edit().putString(CURRENT_ACTIVE_BROKER, activeBroker).apply();
        }
    }

    public EncryptionType getEncryptionType(@NonNull String data) throws UnsupportedEncodingException {
        byte[] bytes;
        String methodName = ":getEncryptionType";
        try {
            bytes = this.getByteArrayFromEncryptedBlob(data);
        }
        catch (Exception e) {
            return EncryptionType.UNENCRYPTED;
        }
        try {
            String keyVersion = new String(bytes, 0, 4, "UTF-8");
            if (VERSION_USER_DEFINED.equalsIgnoreCase(keyVersion)) {
                return EncryptionType.USER_DEFINED;
            }
            if (VERSION_ANDROID_KEY_STORE.equalsIgnoreCase(keyVersion)) {
                return EncryptionType.ANDROID_KEY_STORE;
            }
        }
        catch (UnsupportedEncodingException e) {
            Logger.error("StorageHelper:getEncryptionType", "Failed to extract keyVersion.", e);
            throw e;
        }
        return EncryptionType.UNENCRYPTED;
    }

    private byte[] getByteArrayFromEncryptedBlob(@NonNull String encryptedBlob) {
        int encodeVersionLength = encryptedBlob.charAt(0) - 97;
        this.validateEncodeVersion(encryptedBlob, encodeVersionLength);
        return Base64.decode((String)encryptedBlob.substring(1 + encodeVersionLength), (int)0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public List<KeyType> getKeysForDecryptionType(@NonNull String encryptedBlob, @NonNull String packageName) throws IOException {
        ArrayList<KeyType> keyTypeList = new ArrayList<KeyType>();
        EncryptionType encryptionType = this.getEncryptionType(encryptedBlob);
        if (encryptionType == EncryptionType.USER_DEFINED) {
            if (this.isBrokerProcess()) {
                if ("com.microsoft.windowsintune.companyportal".equalsIgnoreCase(packageName)) {
                    keyTypeList.add(KeyType.LEGACY_COMPANY_PORTAL_KEY);
                    keyTypeList.add(KeyType.LEGACY_AUTHENTICATOR_APP_KEY);
                    return keyTypeList;
                } else {
                    if (!"com.azure.authenticator".equalsIgnoreCase(packageName)) throw new IllegalStateException("Unexpected Broker package name.");
                    keyTypeList.add(KeyType.LEGACY_AUTHENTICATOR_APP_KEY);
                    keyTypeList.add(KeyType.LEGACY_COMPANY_PORTAL_KEY);
                }
                return keyTypeList;
            } else {
                keyTypeList.add(KeyType.ADAL_USER_DEFINED_KEY);
            }
            return keyTypeList;
        } else {
            if (encryptionType != EncryptionType.ANDROID_KEY_STORE) return keyTypeList;
            keyTypeList.add(KeyType.KEYSTORE_ENCRYPTED_KEY);
        }
        return keyTypeList;
    }

    @NonNull
    private String decryptWithSecretKey(@NonNull byte[] bytes, @NonNull SecretKey secretKey) throws GeneralSecurityException, IOException {
        SecretKey hmacKey = this.getHMacKey(secretKey);
        int ivIndex = bytes.length - 16 - 32;
        int macIndex = bytes.length - 32;
        int encryptedLength = ivIndex - 4;
        if (ivIndex < 0 || macIndex < 0 || encryptedLength < 0) {
            throw new IOException("Invalid byte array input for decryption.");
        }
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        Mac mac = Mac.getInstance(HMAC_ALGORITHM);
        mac.init(hmacKey);
        mac.update(bytes, 0, macIndex);
        byte[] macDigest = mac.doFinal();
        this.logIfKeyHasChanged(secretKey, hmacKey);
        this.assertHMac(bytes, macIndex, bytes.length, macDigest);
        cipher.init(2, (Key)secretKey, new IvParameterSpec(bytes, ivIndex, 16));
        String decrypted = new String(cipher.doFinal(bytes, 4, encryptedLength), "UTF-8");
        return decrypted;
    }

    private boolean logIfKeyHasChanged(@NonNull SecretKey secretKey, SecretKey hmacKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        String keyThumbPrint = this.getKeyThumbPrint(secretKey, hmacKey);
        if (!LAST_KNOWN_THUMBPRINT.get().equals(keyThumbPrint)) {
            LAST_KNOWN_THUMBPRINT.set(keyThumbPrint);
            if (!FIRST_TIME.compareAndSet(false, true)) {
                Logger.info("StorageHelper:logIfKeyHasChanged", "Using key with thumbprint that has changed " + keyThumbPrint);
                return true;
            }
        }
        return false;
    }

    private void validateEncodeVersion(String encryptedBlob, int encodeVersionLength) {
        if (encodeVersionLength <= 0) {
            throw new IllegalArgumentException(String.format("Encode version length: '%s' is not valid, it must be greater of equal to 0", encodeVersionLength));
        }
        if (!encryptedBlob.substring(1, 1 + encodeVersionLength).equals(ENCODE_VERSION)) {
            throw new IllegalArgumentException(String.format("Unsupported encode version received. Encode version supported is: '%s'", ENCODE_VERSION));
        }
    }

    @Override
    public synchronized SecretKey loadSecretKeyForEncryption() throws IOException, GeneralSecurityException {
        String methodName = ":loadSecretKeyForEncryption";
        if (this.mEncryptionKey != null && this.mEncryptionHMACKey != null) {
            return this.mEncryptionKey;
        }
        if (this.isBrokerProcess()) {
            if (this.mTelemetryCallback != null) {
                try {
                    SecretKey key = this.loadSecretKey(KeyType.KEYSTORE_ENCRYPTED_KEY);
                    if (key == null) {
                        this.mTelemetryCallback.logEvent(this.mContext, ":loadSecretKeyForEncryption", false, "KEY_ENCRYPTION_KEYSTORE_KEY_NOT_INITIALIZED");
                    }
                }
                catch (Exception e) {
                    this.mTelemetryCallback.logEvent(this.mContext, ":loadSecretKeyForEncryption", false, "KEY_ENCRYPTION_KEYSTORE_KEY_FAILED_TO_LOAD");
                }
            }
            this.setBlobVersion(VERSION_USER_DEFINED);
            if ("com.azure.authenticator".equalsIgnoreCase(this.getPackageName())) {
                return this.loadSecretKey(KeyType.LEGACY_AUTHENTICATOR_APP_KEY);
            }
            return this.loadSecretKey(KeyType.LEGACY_COMPANY_PORTAL_KEY);
        }
        if (AuthenticationSettings.INSTANCE.getSecretKeyData() != null) {
            this.setBlobVersion(VERSION_USER_DEFINED);
            return this.loadSecretKey(KeyType.ADAL_USER_DEFINED_KEY);
        }
        this.setBlobVersion(VERSION_ANDROID_KEY_STORE);
        try {
            SecretKey key = this.loadSecretKey(KeyType.KEYSTORE_ENCRYPTED_KEY);
            if (key != null) {
                return key;
            }
        }
        catch (IOException | GeneralSecurityException exception) {
            // empty catch block
        }
        Logger.verbose("StorageHelper:loadSecretKeyForEncryption", "Keystore-encrypted key does not exist, try to generate new keys.");
        return this.generateKeyStoreEncryptedKey();
    }

    protected void setBlobVersion(@NonNull String blobVersion) {
        this.mBlobVersion = blobVersion;
    }

    @Nullable
    public SecretKey loadSecretKey(@NonNull KeyType keyType) throws IOException, GeneralSecurityException {
        String methodName = ":loadSecretKey";
        switch (keyType) {
            case LEGACY_AUTHENTICATOR_APP_KEY: {
                return StorageHelper.getSecretKey(AuthenticationSettings.INSTANCE.getBrokerSecretKeys().get("com.azure.authenticator"));
            }
            case LEGACY_COMPANY_PORTAL_KEY: {
                return StorageHelper.getSecretKey(AuthenticationSettings.INSTANCE.getBrokerSecretKeys().get("com.microsoft.windowsintune.companyportal"));
            }
            case ADAL_USER_DEFINED_KEY: {
                return StorageHelper.getSecretKey(AuthenticationSettings.INSTANCE.getSecretKeyData());
            }
            case KEYSTORE_ENCRYPTED_KEY: {
                return this.loadKeyStoreEncryptedKey();
            }
        }
        Logger.verbose("StorageHelper:loadSecretKey", "Unknown KeyType. This code should never be reached.");
        throw new GeneralSecurityException("unknown_error");
    }

    public void saveKeyStoreEncryptedKey(@NonNull SecretKey unencryptedKey) throws GeneralSecurityException, IOException {
        if (this.mKeyPair == null) {
            this.mKeyPair = this.generateKeyPairFromAndroidKeyStore();
        }
        byte[] keyWrapped = this.wrap(unencryptedKey);
        this.writeKeyData(keyWrapped);
    }

    public synchronized SecretKey generateKeyStoreEncryptedKey() throws GeneralSecurityException, IOException {
        String methodName = ":generateKeyStoreEncryptedKey";
        this.mCachedKeyStoreEncryptedKey = this.generateSecretKey();
        this.saveKeyStoreEncryptedKey(this.mCachedKeyStoreEncryptedKey);
        this.logEvent(":generateKeyStoreEncryptedKey", "key_created_v2", false, "New key is generated.");
        return this.mCachedKeyStoreEncryptedKey;
    }

    @Nullable
    private synchronized SecretKey loadKeyStoreEncryptedKey() throws GeneralSecurityException, IOException {
        String methodName = ":loadKeyStoreEncryptedKey";
        if (this.mCachedKeyStoreEncryptedKey != null) {
            return this.mCachedKeyStoreEncryptedKey;
        }
        try {
            this.mCachedKeyStoreEncryptedKey = this.getUnwrappedSecretKey();
        }
        catch (IOException | GeneralSecurityException e) {
            Logger.error("StorageHelper:loadKeyStoreEncryptedKey", "android_keystore_failed", e);
            this.mKeyPair = null;
            this.mCachedKeyStoreEncryptedKey = null;
            this.deleteKeyFile();
            this.resetKeyPairFromAndroidKeyStore();
            throw e;
        }
        return this.mCachedKeyStoreEncryptedKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=18)
    private synchronized KeyPair generateKeyPairFromAndroidKeyStore() throws GeneralSecurityException, IOException {
        String methodName = ":generateKeyPairFromAndroidKeyStore";
        Object object = DateUtilities.isLocaleCalendarNonGregorian(Locale.getDefault()) ? DateUtilities.LOCALE_CHANGE_LOCK : new Object();
        synchronized (object) {
            Locale currentLocale = Locale.getDefault();
            StorageHelper.applyKeyStoreLocaleWorkarounds(currentLocale);
            try {
                this.logFlowStart(":generateKeyPairFromAndroidKeyStore", "keychain_write_v2_start");
                KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE);
                keyStore.load(null);
                Logger.verbose("StorageHelper:generateKeyPairFromAndroidKeyStore", "Generate KeyPair from AndroidKeyStore");
                Calendar start = Calendar.getInstance();
                Calendar end = Calendar.getInstance();
                int certValidYears = 100;
                end.add(1, 100);
                KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", ANDROID_KEY_STORE);
                generator.initialize(this.getKeyPairGeneratorSpec(this.mContext, start.getTime(), end.getTime()));
                KeyPair keyPair = generator.generateKeyPair();
                this.logFlowSuccess(":generateKeyPairFromAndroidKeyStore", "keychain_write_v2_end", "");
                KeyPair keyPair2 = keyPair;
                return keyPair2;
            }
            catch (IOException | GeneralSecurityException e) {
                this.logFlowError(":generateKeyPairFromAndroidKeyStore", "keychain_write_v2_end", e.toString(), e);
                throw e;
            }
            catch (IllegalStateException e) {
                this.logFlowError(":generateKeyPairFromAndroidKeyStore", "keychain_write_v2_end", e.toString(), e);
                throw new KeyStoreException(e);
            }
            finally {
                Locale.setDefault(currentLocale);
            }
        }
    }

    public static synchronized void applyKeyStoreLocaleWorkarounds(@NonNull Locale currentLocale) {
        if (Build.VERSION.SDK_INT <= 23 && DateUtilities.isLocaleCalendarNonGregorian(currentLocale)) {
            Locale.setDefault(Locale.ENGLISH);
        }
    }

    @Nullable
    private synchronized KeyPair readKeyPair() throws GeneralSecurityException, IOException {
        String methodName = ":readKeyPair";
        Logger.verbose("StorageHelper:readKeyPair", "Reading Key entry");
        try {
            this.logFlowStart(":readKeyPair", "keychain_read_v2_start");
            KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE);
            keyStore.load(null);
            Certificate cert = keyStore.getCertificate(KEY_STORE_CERT_ALIAS);
            Key privateKey = keyStore.getKey(KEY_STORE_CERT_ALIAS, null);
            if (cert == null || privateKey == null) {
                this.logFlowSuccess(":readKeyPair", "keychain_read_v2_end", "KeyStore is empty.");
                Logger.verbose("StorageHelper:readKeyPair", "Key entry doesn't exist.");
                return null;
            }
            KeyPair keyPair = new KeyPair(cert.getPublicKey(), (PrivateKey)privateKey);
            this.logFlowSuccess(":readKeyPair", "keychain_read_v2_end", "KeyStore KeyPair is loaded.");
            return keyPair;
        }
        catch (IOException | GeneralSecurityException e) {
            this.logFlowError(":readKeyPair", "keychain_read_v2_end", e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            this.logFlowError(":readKeyPair", "keychain_read_v2_end", e.toString(), e);
            throw new KeyStoreException(e);
        }
    }

    @TargetApi(value=18)
    private AlgorithmParameterSpec getKeyPairGeneratorSpec(Context context, Date start, Date end) {
        String certInfo = String.format(Locale.ROOT, "CN=%s, OU=%s", KEY_STORE_CERT_ALIAS, this.getPackageName());
        return new KeyPairGeneratorSpec.Builder(context).setAlias(KEY_STORE_CERT_ALIAS).setSubject(new X500Principal(certInfo)).setSerialNumber(BigInteger.ONE).setStartDate(start).setEndDate(end).build();
    }

    private static SecretKey getSecretKey(byte[] rawBytes) {
        if (rawBytes == null) {
            throw new IllegalArgumentException("rawBytes");
        }
        return new SecretKeySpec(rawBytes, KEYSPEC_ALGORITHM);
    }

    private SecretKey getHMacKey(SecretKey key) throws NoSuchAlgorithmException {
        byte[] encodedKey = key.getEncoded();
        if (encodedKey != null) {
            MessageDigest digester = MessageDigest.getInstance(HMAC_KEY_HASH_ALGORITHM);
            return new SecretKeySpec(digester.digest(encodedKey), KEYSPEC_ALGORITHM);
        }
        return key;
    }

    private char getEncodeVersionLengthPrefix() {
        return (char)(97 + ENCODE_VERSION.length());
    }

    private void assertHMac(byte[] digest, int start, int end, byte[] calculated) throws DigestException {
        if (calculated.length != end - start) {
            throw new IllegalArgumentException("Unexpected HMAC length");
        }
        int result = 0;
        for (int i = start; i < end; ++i) {
            result = (byte)(result | calculated[i - start] ^ digest[i]);
        }
        if (result != 0) {
            throw new DigestException();
        }
    }

    protected SecretKey generateSecretKey() throws NoSuchAlgorithmException {
        KeyGenerator keygen = KeyGenerator.getInstance(KEYSPEC_ALGORITHM);
        keygen.init(256, this.mRandom);
        return keygen.generateKey();
    }

    @Nullable
    @TargetApi(value=18)
    private synchronized SecretKey getUnwrappedSecretKey() throws GeneralSecurityException, IOException {
        String methodName = ":getUnwrappedSecretKey";
        Logger.verbose("StorageHelper:getUnwrappedSecretKey", "Reading SecretKey");
        byte[] wrappedSecretKey = this.readKeyData();
        if (wrappedSecretKey == null) {
            Logger.verbose("StorageHelper:getUnwrappedSecretKey", "Key data is null");
            return null;
        }
        this.mKeyPair = this.readKeyPair();
        if (this.mKeyPair == null) {
            return null;
        }
        SecretKey unwrappedSecretKey = this.unwrap(wrappedSecretKey);
        Logger.verbose("StorageHelper:getUnwrappedSecretKey", "Finished reading SecretKey");
        return unwrappedSecretKey;
    }

    public void deleteKeyFile() {
        String methodName = ":deleteKeyFile";
        File keyFile = new File(this.mContext.getDir(this.getPackageName(), 0), ADALKS);
        if (keyFile.exists()) {
            Logger.verbose("StorageHelper:deleteKeyFile", "Delete KeyFile");
            if (!keyFile.delete()) {
                Logger.verbose("StorageHelper:deleteKeyFile", "Delete KeyFile failed");
            }
        }
    }

    @TargetApi(value=18)
    protected synchronized void resetKeyPairFromAndroidKeyStore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE);
        keyStore.load(null);
        keyStore.deleteEntry(KEY_STORE_CERT_ALIAS);
    }

    @TargetApi(value=18)
    @SuppressLint(value={"GetInstance"})
    private byte[] wrap(SecretKey key) throws GeneralSecurityException {
        String methodName = ":wrap";
        Logger.verbose("StorageHelper:wrap", "Wrap secret key.");
        Cipher wrapCipher = Cipher.getInstance(WRAP_ALGORITHM);
        wrapCipher.init(3, this.mKeyPair.getPublic());
        return wrapCipher.wrap(key);
    }

    @TargetApi(value=18)
    @SuppressLint(value={"GetInstance"})
    private SecretKey unwrap(byte[] keyBlob) throws GeneralSecurityException {
        Cipher wrapCipher = Cipher.getInstance(WRAP_ALGORITHM);
        wrapCipher.init(4, this.mKeyPair.getPrivate());
        try {
            return (SecretKey)wrapCipher.unwrap(keyBlob, KEYSPEC_ALGORITHM, 3);
        }
        catch (IllegalArgumentException exception) {
            throw new KeyStoreException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeKeyData(byte[] data) throws IOException {
        String methodName = ":writeKeyData";
        Logger.verbose("StorageHelper:writeKeyData", "Writing key data to a file");
        File keyFile = new File(this.mContext.getDir(this.getPackageName(), 0), ADALKS);
        try (FileOutputStream out = new FileOutputStream(keyFile);){
            ((OutputStream)out).write(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private byte[] readKeyData() throws IOException {
        String methodName = ":readKeyData";
        File keyFile = new File(this.mContext.getDir(this.getPackageName(), 0), ADALKS);
        if (!keyFile.exists()) {
            return null;
        }
        Logger.verbose("StorageHelper:readKeyData", "Reading key data from a file");
        try (FileInputStream in = new FileInputStream(keyFile);){
            int count;
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((count = ((InputStream)in).read(buffer)) != -1) {
                bytes.write(buffer, 0, count);
            }
            byte[] byArray = bytes.toByteArray();
            return byArray;
        }
    }

    public String serializeSecretKey(@NonNull SecretKey key) {
        return Base64.encodeToString((byte[])key.getEncoded(), (int)0);
    }

    public SecretKey deserializeSecretKey(@NonNull String serializedKey) {
        return StorageHelper.getSecretKey(Base64.decode((String)serializedKey, (int)0));
    }

    private void logEvent(@NonNull String methodName, @NonNull String operationName, @NonNull boolean isFailed, @NonNull String reason) {
        Logger.verbose(TAG + methodName, operationName + ": " + reason);
        if (this.mTelemetryCallback != null) {
            this.mTelemetryCallback.logEvent(this.mContext, operationName, isFailed, reason);
        }
    }

    private void logFlowStart(@NonNull String methodName, @NonNull String operationName) {
        Logger.verbose(TAG + methodName, operationName + " started.");
        if (this.mTelemetryCallback != null) {
            this.mTelemetryCallback.logEvent(this.mContext, operationName, false, "");
        }
    }

    private void logFlowSuccess(@NonNull String methodName, @NonNull String operationName, @NonNull String reason) {
        Logger.verbose(TAG + methodName, operationName + " successfully finished: " + reason);
        if (this.mTelemetryCallback != null) {
            this.mTelemetryCallback.logEvent(this.mContext, operationName, false, reason);
        }
    }

    private void logFlowError(@NonNull String methodName, @NonNull String operationName, @NonNull String reason, @Nullable Exception e) {
        Logger.error(TAG + methodName, operationName + " failed: " + reason, e);
        if (this.mTelemetryCallback != null) {
            this.mTelemetryCallback.logEvent(this.mContext, operationName, true, reason);
        }
    }

    public static enum EncryptionType {
        USER_DEFINED,
        ANDROID_KEY_STORE,
        UNENCRYPTED;

    }

    public static enum KeyType {
        LEGACY_AUTHENTICATOR_APP_KEY,
        LEGACY_COMPANY_PORTAL_KEY,
        ADAL_USER_DEFINED_KEY,
        KEYSTORE_ENCRYPTED_KEY;

    }
}

