/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import android.content.Context;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.controllers.TaskCompletedCallbackWithError;
import com.microsoft.identity.common.internal.platform.SecureHardwareState;
import java.net.URL;
import java.util.Date;

public interface IDevicePopManager {
    public boolean asymmetricKeyExists();

    public boolean asymmetricKeyExists(String var1);

    public String getAsymmetricKeyThumbprint() throws ClientException;

    public void generateAsymmetricKey(Context var1, TaskCompletedCallbackWithError<String, ClientException> var2);

    public String generateAsymmetricKey(Context var1) throws ClientException;

    public Date getAsymmetricKeyCreationDate() throws ClientException;

    public boolean clearAsymmetricKey();

    public String getRequestConfirmation() throws ClientException;

    public void getRequestConfirmation(TaskCompletedCallbackWithError<String, ClientException> var1);

    public String sign(SigningAlgorithm var1, String var2) throws ClientException;

    public boolean verify(SigningAlgorithm var1, String var2, String var3);

    public String encrypt(Cipher var1, String var2) throws ClientException;

    public String decrypt(Cipher var1, String var2) throws ClientException;

    public SecureHardwareState getSecureHardwareState() throws ClientException;

    public String getPublicKey(PublicKeyFormat var1) throws ClientException;

    public String mintSignedAccessToken(String var1, long var2, URL var4, String var5, String var6) throws ClientException;

    public String mintSignedAccessToken(String var1, long var2, URL var4, String var5, String var6, String var7) throws ClientException;

    public String mintSignedHttpRequest(String var1, long var2, URL var4, String var5, String var6) throws ClientException;

    public static enum Cipher {
        RSA_ECB_PKCS1_PADDING("RSA/ECB/PKCS1Padding"),
        RSA_ECB_OAEPWithSHA_256AndMGF1Padding("RSA/ECB/OAEPWithSHA-256AndMGF1Padding"),
        RSA_ECB_OAEPWithSHA_384AndMGF1Padding("RSA/ECB/OAEPWithSHA-384AndMGF1Padding"),
        RSA_ECB_OAEPWithSHA_512AndMGF1Padding("RSA/ECB/OAEPWithSHA-512AndMGF1Padding");

        private final String mValue;

        private Cipher(String value) {
            this.mValue = value;
        }

        @NonNull
        public String toString() {
            return this.mValue;
        }
    }

    public static enum SigningAlgorithm {
        MD5_WITH_RSA("MD5withRSA"),
        NONE_WITH_RSA("NONEwithRSA"),
        SHA_256_WITH_RSA("SHA256withRSA"),
        SHA_256_WITH_RSA_PSS("SHA256withRSA/PSS"),
        SHA_384_WITH_RSA("SHA384withRSA"),
        SHA_384_WITH_RSA_PSS("SHA384withRSA/PSS"),
        SHA_512_WITH_RSA("SHA512withRSA"),
        SHA_512_WITH_RSA_PSS("SHA512withRSA/PSS");

        private final String mValue;

        private SigningAlgorithm(String value) {
            this.mValue = value;
        }

        @NonNull
        public String toString() {
            return this.mValue;
        }
    }

    public static enum PublicKeyFormat {
        X_509_SubjectPublicKeyInfo_ASN_1,
        JWK;

    }
}

