/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.request;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.microsoft.identity.common.internal.authorities.Authority;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.common.internal.authorities.Environment;
import com.microsoft.identity.common.internal.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.internal.authscheme.BearerAuthenticationSchemeInternal;
import com.microsoft.identity.common.internal.authscheme.PopAuthenticationSchemeInternal;
import com.microsoft.identity.common.internal.broker.BrokerRequest;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import com.microsoft.identity.common.internal.commands.parameters.BrokerInteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.BrokerSilentTokenCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.CommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.RemoveAccountCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.TokenCommandParameters;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.internal.providers.oauth2.OpenIdConnectPromptParameter;
import com.microsoft.identity.common.internal.request.AdalBrokerRequestAdapter;
import com.microsoft.identity.common.internal.request.AuthenticationSchemeTypeAdapter;
import com.microsoft.identity.common.internal.request.IBrokerRequestAdapter;
import com.microsoft.identity.common.internal.request.SdkType;
import com.microsoft.identity.common.internal.ui.AuthorizationAgent;
import com.microsoft.identity.common.internal.ui.browser.BrowserDescriptor;
import com.microsoft.identity.common.internal.util.BrokerProtocolVersionUtil;
import com.microsoft.identity.common.internal.util.ClockSkewManager;
import com.microsoft.identity.common.internal.util.GzipUtil;
import com.microsoft.identity.common.internal.util.QueryParamsAdapter;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class MsalBrokerRequestAdapter
implements IBrokerRequestAdapter {
    private static final String TAG = MsalBrokerRequestAdapter.class.getName();
    public static Gson sRequestAdapterGsonInstance = new GsonBuilder().registerTypeAdapter(AbstractAuthenticationScheme.class, (Object)new AuthenticationSchemeTypeAdapter()).create();

    @Override
    public BrokerRequest brokerRequestFromAcquireTokenParameters(@NonNull InteractiveTokenCommandParameters parameters) {
        Logger.info(TAG, "Constructing result bundle from AcquireTokenOperationParameters.");
        BrokerRequest brokerRequest = new BrokerRequest.Builder().authority(parameters.getAuthority().getAuthorityURL().toString()).scope(TextUtils.join((CharSequence)" ", parameters.getScopes())).redirect(this.getRedirectUri(parameters)).clientId(parameters.getClientId()).username(parameters.getLoginHint()).extraQueryStringParameter(parameters.getExtraQueryStringParameters() != null ? QueryParamsAdapter._toJson(parameters.getExtraQueryStringParameters()) : null).prompt(OpenIdConnectPromptParameter.UNSET.name().equals(parameters.getPrompt().name()) ? null : parameters.getPrompt().name()).claims(parameters.getClaimsRequestJson()).forceRefresh(parameters.isForceRefresh()).correlationId(parameters.getCorrelationId()).applicationName(parameters.getApplicationName()).applicationVersion(parameters.getApplicationVersion()).msalVersion(parameters.getSdkVersion()).sdkType(parameters.getSdkType()).environment(AzureActiveDirectory.getEnvironment().name()).multipleCloudsSupported(this.getMultipleCloudsSupported(parameters)).authorizationAgent(parameters.isBrokerBrowserSupportEnabled() ? AuthorizationAgent.BROWSER.name() : AuthorizationAgent.WEBVIEW.name()).authenticationScheme(parameters.getAuthenticationScheme()).powerOptCheckEnabled(parameters.isPowerOptCheckEnabled()).build();
        return brokerRequest;
    }

    @Override
    public BrokerRequest brokerRequestFromSilentOperationParameters(@NonNull SilentTokenCommandParameters parameters) {
        Logger.info(TAG, "Constructing result bundle from AcquireTokenSilentOperationParameters.");
        BrokerRequest brokerRequest = new BrokerRequest.Builder().authority(parameters.getAuthority().getAuthorityURL().toString()).scope(TextUtils.join((CharSequence)" ", parameters.getScopes())).redirect(this.getRedirectUri(parameters)).clientId(parameters.getClientId()).homeAccountId(parameters.getAccount().getHomeAccountId()).localAccountId(parameters.getAccount().getLocalAccountId()).username(parameters.getAccount().getUsername()).claims(parameters.getClaimsRequestJson()).forceRefresh(parameters.isForceRefresh()).correlationId(parameters.getCorrelationId()).applicationName(parameters.getApplicationName()).applicationVersion(parameters.getApplicationVersion()).msalVersion(parameters.getSdkVersion()).sdkType(parameters.getSdkType()).environment(AzureActiveDirectory.getEnvironment().name()).multipleCloudsSupported(this.getMultipleCloudsSupported(parameters)).authenticationScheme(parameters.getAuthenticationScheme()).powerOptCheckEnabled(parameters.isPowerOptCheckEnabled()).build();
        return brokerRequest;
    }

    @NonNull
    private static AbstractAuthenticationScheme getAuthenticationScheme(@NonNull Context context, @NonNull BrokerRequest request) {
        AbstractAuthenticationScheme requestScheme = request.getAuthenticationScheme();
        if (null == requestScheme) {
            return new BearerAuthenticationSchemeInternal();
        }
        if (requestScheme instanceof PopAuthenticationSchemeInternal) {
            ClockSkewManager clockSkewManager = new ClockSkewManager(context);
            ((PopAuthenticationSchemeInternal)requestScheme).setClockSkewManager(clockSkewManager);
        }
        return requestScheme;
    }

    @Override
    public BrokerInteractiveTokenCommandParameters brokerInteractiveParametersFromActivity(@NonNull Activity callingActivity) {
        String correlationIdString;
        AzureActiveDirectoryAuthority authority;
        Logger.info(TAG, "Constructing BrokerAcquireTokenOperationParameters from calling activity");
        Intent intent = callingActivity.getIntent();
        BrokerRequest brokerRequest = this.brokerRequestFromBundle(intent.getExtras());
        if (brokerRequest == null) {
            Logger.error(TAG, "Broker Result is null, returning empty parameters, validation is expected to fail", null);
            return BrokerInteractiveTokenCommandParameters.builder().build();
        }
        int callingAppUid = intent.getIntExtra("caller.info.uid", 0);
        List<Pair<String, String>> extraQP = new ArrayList<Pair<String, String>>();
        if (!TextUtils.isEmpty((CharSequence)brokerRequest.getExtraQueryStringParameter())) {
            extraQP = QueryParamsAdapter._fromJson(brokerRequest.getExtraQueryStringParameter());
        }
        if ((authority = AdalBrokerRequestAdapter.getRequestAuthorityWithExtraQP(brokerRequest.getAuthority(), extraQP)) != null) {
            authority.setMultipleCloudsSupported(brokerRequest.getMultipleCloudsSupported());
        }
        if (TextUtils.isEmpty((CharSequence)(correlationIdString = brokerRequest.getCorrelationId()))) {
            UUID correlationId = UUID.randomUUID();
            correlationIdString = correlationId.toString();
        }
        String negotiatedBrokerProtocolVersion = intent.getStringExtra("common.broker.protocol.version.name");
        Logger.info(TAG, "Authorization agent passed in by MSAL: " + brokerRequest.getAuthorizationAgent());
        BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder commandParametersBuilder = (BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((CommandParameters.CommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((InteractiveTokenCommandParameters.InteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((CommandParameters.CommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)BrokerInteractiveTokenCommandParameters.builder().authenticationScheme(MsalBrokerRequestAdapter.getAuthenticationScheme((Context)callingActivity, brokerRequest))).activity(callingActivity)).androidApplicationContext(callingActivity.getApplicationContext())).sdkType(brokerRequest.getSdkType() == null ? SdkType.MSAL : brokerRequest.getSdkType())).sdkVersion(brokerRequest.getMsalVersion())).callerUid(callingAppUid)).applicationName(brokerRequest.getApplicationName())).applicationVersion(brokerRequest.getApplicationVersion())).callerPackageName(brokerRequest.getApplicationName())).callerAppVersion(brokerRequest.getApplicationVersion())).extraQueryStringParameters(extraQP)).authority(authority)).scopes(this.getScopesAsSet(brokerRequest.getScope()))).clientId(brokerRequest.getClientId())).redirectUri(brokerRequest.getRedirect())).loginHint(brokerRequest.getUserName())).correlationId(correlationIdString)).claimsRequestJson(brokerRequest.getClaims())).prompt(brokerRequest.getPrompt() != null ? OpenIdConnectPromptParameter.valueOf(brokerRequest.getPrompt()) : OpenIdConnectPromptParameter.UNSET)).negotiatedBrokerProtocolVersion(negotiatedBrokerProtocolVersion)).powerOptCheckEnabled(brokerRequest.isPowerOptCheckEnabled());
        if (AuthorizationAgent.BROWSER.name().equalsIgnoreCase(brokerRequest.getAuthorizationAgent()) && this.isCallingPackageIntune(brokerRequest.getApplicationName())) {
            Logger.info(TAG, "Setting Authorization Agent to Browser for Intune app");
            this.buildCommandParameterBuilder(commandParametersBuilder);
        } else {
            commandParametersBuilder.authorizationAgent(AuthorizationAgent.WEBVIEW);
        }
        if (!TextUtils.isEmpty((CharSequence)brokerRequest.getEnvironment())) {
            AzureActiveDirectory.setEnvironment(Environment.valueOf(brokerRequest.getEnvironment()));
        }
        return commandParametersBuilder.build();
    }

    private void buildCommandParameterBuilder(BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder commandParametersBuilder) {
        ((InteractiveTokenCommandParameters.InteractiveTokenCommandParametersBuilder)((InteractiveTokenCommandParameters.InteractiveTokenCommandParametersBuilder)commandParametersBuilder.authorizationAgent(AuthorizationAgent.BROWSER)).brokerBrowserSupportEnabled(true)).browserSafeList(MsalBrokerRequestAdapter.getBrowserSafeListForBroker());
    }

    @Override
    public BrokerSilentTokenCommandParameters brokerSilentParametersFromBundle(@NonNull Bundle bundle, @NonNull Context context, @NonNull Account account) {
        String correlationIdString;
        Logger.info(TAG, "Constructing BrokerAcquireTokenSilentOperationParameters from result bundle");
        BrokerRequest brokerRequest = this.brokerRequestFromBundle(bundle);
        if (brokerRequest == null) {
            Logger.error(TAG, "Broker Result is null, returning empty parameters, validation is expected to fail", null);
            return BrokerSilentTokenCommandParameters.builder().build();
        }
        int callingAppUid = bundle.getInt("caller.info.uid");
        Authority authority = Authority.getAuthorityFromAuthorityUrl(brokerRequest.getAuthority());
        if (authority instanceof AzureActiveDirectoryAuthority) {
            ((AzureActiveDirectoryAuthority)authority).setMultipleCloudsSupported(brokerRequest.getMultipleCloudsSupported());
        }
        if (TextUtils.isEmpty((CharSequence)(correlationIdString = bundle.getString(brokerRequest.getCorrelationId())))) {
            UUID correlationId = UUID.randomUUID();
            correlationIdString = correlationId.toString();
        }
        String negotiatedBrokerProtocolVersion = bundle.getString("common.broker.protocol.version.name");
        SilentTokenCommandParameters commandParameters = ((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((CommandParameters.CommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((TokenCommandParameters.TokenCommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((CommandParameters.CommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((CommandParameters.CommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)BrokerSilentTokenCommandParameters.builder().authenticationScheme(MsalBrokerRequestAdapter.getAuthenticationScheme(context, brokerRequest))).androidApplicationContext(context)).accountManagerAccount(account)).sdkType(brokerRequest.getSdkType() == null ? SdkType.MSAL : brokerRequest.getSdkType())).sdkVersion(brokerRequest.getMsalVersion())).callerUid(callingAppUid)).applicationName(brokerRequest.getApplicationName())).applicationVersion(brokerRequest.getApplicationVersion())).callerPackageName(brokerRequest.getApplicationName())).callerAppVersion(brokerRequest.getApplicationVersion())).authority(authority)).correlationId(correlationIdString)).scopes(this.getScopesAsSet(brokerRequest.getScope()))).redirectUri(brokerRequest.getRedirect())).clientId(brokerRequest.getClientId())).forceRefresh(brokerRequest.getForceRefresh())).claimsRequestJson(brokerRequest.getClaims())).loginHint(brokerRequest.getUserName())).homeAccountId(brokerRequest.getHomeAccountId())).localAccountId(brokerRequest.getLocalAccountId())).negotiatedBrokerProtocolVersion(negotiatedBrokerProtocolVersion)).powerOptCheckEnabled(brokerRequest.isPowerOptCheckEnabled())).build();
        if (!TextUtils.isEmpty((CharSequence)brokerRequest.getEnvironment())) {
            AzureActiveDirectory.setEnvironment(Environment.valueOf(brokerRequest.getEnvironment()));
        }
        return commandParameters;
    }

    @Nullable
    public BrokerRequest brokerRequestFromBundle(@NonNull Bundle requestBundle) {
        BrokerRequest brokerRequest = null;
        if (requestBundle.containsKey("broker_request_v2_compressed")) {
            try {
                String deCompressedString = GzipUtil.decompressBytesToString(requestBundle.getByteArray("broker_request_v2_compressed"));
                brokerRequest = (BrokerRequest)sRequestAdapterGsonInstance.fromJson(deCompressedString, BrokerRequest.class);
            }
            catch (IOException e) {
                Logger.error(TAG, "Decompression of Broker Request failed, unable to continue with Broker Request", e);
            }
        } else {
            brokerRequest = (BrokerRequest)sRequestAdapterGsonInstance.fromJson(requestBundle.getString("broker_request_v2"), BrokerRequest.class);
        }
        return brokerRequest;
    }

    private Set<String> getScopesAsSet(@Nullable String scopeString) {
        if (TextUtils.isEmpty((CharSequence)scopeString)) {
            return new HashSet<String>();
        }
        String[] scopes = scopeString.split(" ");
        return new HashSet<String>(Arrays.asList(scopes));
    }

    private String getRedirectUri(@NonNull TokenCommandParameters parameters) {
        if (TextUtils.isEmpty((CharSequence)parameters.getRedirectUri())) {
            return BrokerValidator.getBrokerRedirectUri(parameters.getAndroidApplicationContext(), parameters.getApplicationName());
        }
        return parameters.getRedirectUri();
    }

    public Bundle getRequestBundleForHello(@NonNull CommandParameters parameters) {
        Bundle requestBundle = new Bundle();
        requestBundle.putString("broker.protocol.version.name", "5.0");
        if (!StringUtil.isEmpty(parameters.getRequiredBrokerProtocolVersion())) {
            requestBundle.putString("required.broker.protocol.version.name", parameters.getRequiredBrokerProtocolVersion());
        }
        return requestBundle;
    }

    public Intent getRequestIntentForAcquireTokenInteractive(@NonNull Bundle resultBundle, @NonNull InteractiveTokenCommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) {
        Bundle requestBundle = this.getRequestBundleForAcquireTokenInteractive(parameters, negotiatedBrokerProtocolVersion);
        Intent interactiveRequestIntent = new Intent();
        interactiveRequestIntent.putExtras(requestBundle);
        interactiveRequestIntent.putExtras(resultBundle);
        interactiveRequestIntent.setPackage(resultBundle.getString("broker.package.name"));
        interactiveRequestIntent.setClassName(resultBundle.getString("broker.package.name", ""), resultBundle.getString("broker.activity.name", ""));
        interactiveRequestIntent.putExtra("common.broker.protocol.version.name", negotiatedBrokerProtocolVersion);
        return interactiveRequestIntent;
    }

    public Bundle getRequestBundleForAcquireTokenInteractive(@NonNull InteractiveTokenCommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) {
        BrokerRequest brokerRequest = this.brokerRequestFromAcquireTokenParameters(parameters);
        return this.getRequestBundleFromBrokerRequest(brokerRequest, negotiatedBrokerProtocolVersion);
    }

    public Bundle getRequestBundleForAcquireTokenSilent(@NonNull SilentTokenCommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) {
        MsalBrokerRequestAdapter msalBrokerRequestAdapter = new MsalBrokerRequestAdapter();
        BrokerRequest brokerRequest = msalBrokerRequestAdapter.brokerRequestFromSilentOperationParameters(parameters);
        Bundle requestBundle = this.getRequestBundleFromBrokerRequest(brokerRequest, negotiatedBrokerProtocolVersion);
        requestBundle.putInt("caller.info.uid", parameters.getAndroidApplicationContext().getApplicationInfo().uid);
        return requestBundle;
    }

    private Bundle getRequestBundleFromBrokerRequest(@NonNull BrokerRequest brokerRequest, @Nullable String negotiatedBrokerProtocolVersion) {
        Bundle requestBundle = new Bundle();
        if (BrokerProtocolVersionUtil.canCompressBrokerPayloads(negotiatedBrokerProtocolVersion)) {
            try {
                String jsonString = sRequestAdapterGsonInstance.toJson((Object)brokerRequest, BrokerRequest.class);
                byte[] compressedBytes = GzipUtil.compressString(jsonString);
                Logger.info(TAG, "Broker Result, raw payload size:" + jsonString.getBytes().length + " ,compressed bytes size: " + compressedBytes.length);
                requestBundle.putByteArray("broker_request_v2_compressed", compressedBytes);
            }
            catch (IOException e) {
                Logger.error(TAG, "Compression to bytes failed, sending broker request as json String", e);
                requestBundle.putString("broker_request_v2", sRequestAdapterGsonInstance.toJson((Object)brokerRequest, BrokerRequest.class));
            }
        } else {
            Logger.info(TAG, "Broker protocol version: " + negotiatedBrokerProtocolVersion + " lower than compression changes, sending as string");
            requestBundle.putString("broker_request_v2", sRequestAdapterGsonInstance.toJson((Object)brokerRequest, BrokerRequest.class));
        }
        requestBundle.putString("common.broker.protocol.version.name", negotiatedBrokerProtocolVersion);
        return requestBundle;
    }

    public Bundle getRequestBundleForGetAccounts(@NonNull CommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) {
        Bundle requestBundle = new Bundle();
        requestBundle.putString("account.clientid.key", parameters.getClientId());
        requestBundle.putString("account.redirect", parameters.getRedirectUri());
        requestBundle.putString("common.broker.protocol.version.name", negotiatedBrokerProtocolVersion);
        return requestBundle;
    }

    public Bundle getRequestBundleForRemoveAccount(@NonNull RemoveAccountCommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) {
        Bundle requestBundle = new Bundle();
        if (null != parameters.getAccount()) {
            requestBundle.putString("account.clientid.key", parameters.getClientId());
            requestBundle.putString("environment", parameters.getAccount().getEnvironment());
            requestBundle.putString("account.home.account.id", parameters.getAccount().getHomeAccountId());
        }
        requestBundle.putString("common.broker.protocol.version.name", negotiatedBrokerProtocolVersion);
        return requestBundle;
    }

    public Bundle getRequestBundleForRemoveAccountFromSharedDevice(@NonNull RemoveAccountCommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) {
        Bundle requestBundle = new Bundle();
        requestBundle.putString("common.broker.protocol.version.name", negotiatedBrokerProtocolVersion);
        return requestBundle;
    }

    private boolean getMultipleCloudsSupported(@NonNull TokenCommandParameters parameters) {
        if (parameters.getAuthority() instanceof AzureActiveDirectoryAuthority) {
            AzureActiveDirectoryAuthority authority = (AzureActiveDirectoryAuthority)parameters.getAuthority();
            return authority.getMultipleCloudsSupported();
        }
        return false;
    }

    public static List<BrowserDescriptor> getBrowserSafeListForBroker() {
        ArrayList<BrowserDescriptor> browserDescriptors = new ArrayList<BrowserDescriptor>();
        HashSet<String> signatureHashes = new HashSet<String>();
        signatureHashes.add("7fmduHKTdHHrlMvldlEqAIlSfii1tl35bxj1OXN5Ve8c4lU6URVu4xtSHc3BVZxS6WWJnxMDhIfQN0N0K2NDJg==");
        BrowserDescriptor chrome = new BrowserDescriptor("com.android.chrome", signatureHashes, null, null);
        browserDescriptors.add(chrome);
        return browserDescriptors;
    }

    private boolean isCallingPackageIntune(@NonNull String packageName) {
        String methodName = ":isCallingPackageIntune";
        String intunePackageName = "com.microsoft.intune";
        Logger.info(TAG + ":isCallingPackageIntune", "Calling package name : " + packageName);
        return "com.microsoft.intune".equalsIgnoreCase(packageName);
    }
}

