/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.text.TextUtils;
import android.webkit.ClientCertRequest;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.broker.PackageHelper;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.ui.webview.OAuth2WebViewClient;
import com.microsoft.identity.common.internal.ui.webview.OnPageLoadedCallback;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.ClientCertAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.IAuthorizationCompletionCallback;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.PKeyAuthChallenge;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.PKeyAuthChallengeFactory;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.PKeyAuthChallengeHandler;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Locale;

public class AzureActiveDirectoryWebViewClient
extends OAuth2WebViewClient {
    private static final String TAG = AzureActiveDirectoryWebViewClient.class.getSimpleName();
    public static final String ERROR = "error";
    public static final String ERROR_SUBCODE = "error_subcode";
    public static final String ERROR_DESCRIPTION = "error_description";
    private final String mRedirectUrl;

    public AzureActiveDirectoryWebViewClient(@NonNull Activity activity, @NonNull IAuthorizationCompletionCallback completionCallback, @NonNull OnPageLoadedCallback pageLoadedCallback, @NonNull String redirectUrl) {
        super(activity, completionCallback, pageLoadedCallback);
        this.mRedirectUrl = redirectUrl;
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (StringUtil.isEmpty(url)) {
            throw new IllegalArgumentException("Redirect to empty url in web view.");
        }
        return this.handleUrl(view, url);
    }

    @TargetApi(value=24)
    @RequiresApi(value=24)
    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        Uri requestUrl = request.getUrl();
        return this.handleUrl(view, requestUrl.toString());
    }

    private boolean handleUrl(WebView view, String url) {
        String formattedURL = url.toLowerCase(Locale.US);
        if (this.isPkeyAuthUrl(formattedURL)) {
            Logger.info(TAG, "WebView detected request for pkeyauth challenge.");
            try {
                PKeyAuthChallengeFactory factory = new PKeyAuthChallengeFactory();
                PKeyAuthChallenge pKeyAuthChallenge = factory.getPKeyAuthChallenge(url);
                PKeyAuthChallengeHandler pKeyAuthChallengeHandler = new PKeyAuthChallengeHandler(view, this.getCompletionCallback());
                pKeyAuthChallengeHandler.processChallenge(pKeyAuthChallenge);
            }
            catch (ClientException exception) {
                Logger.error(TAG, exception.getErrorCode(), null);
                Logger.errorPII(TAG, exception.getMessage(), exception);
                this.returnError(exception.getErrorCode(), exception.getMessage());
                view.stopLoading();
            }
            return true;
        }
        if (this.isRedirectUrl(formattedURL)) {
            Logger.info(TAG, "Navigation starts with the redirect uri.");
            return this.processRedirectUrl(view, url);
        }
        if (this.isWebsiteRequestUrl(formattedURL)) {
            Logger.info(TAG, "It is an external website request");
            return this.processWebsiteRequest(view, url);
        }
        if (this.isInstallRequestUrl(formattedURL)) {
            Logger.info(TAG, "It is an install request");
            return this.processInstallRequest(view, url);
        }
        Logger.info(TAG, "It is an invalid redirect uri.");
        return this.processInvalidUrl(view, url);
    }

    private boolean isPkeyAuthUrl(@NonNull String url) {
        return url.startsWith("urn:http-auth:PKeyAuth".toLowerCase(Locale.ROOT));
    }

    private boolean isRedirectUrl(@NonNull String url) {
        return url.startsWith(this.mRedirectUrl.toLowerCase(Locale.US));
    }

    private boolean isWebsiteRequestUrl(@NonNull String url) {
        return url.startsWith("browser://");
    }

    private boolean isInstallRequestUrl(@NonNull String url) {
        return url.startsWith("msauth://");
    }

    private boolean isBrokerRequest(Intent callingIntent) {
        return callingIntent != null && !StringExtensions.isNullOrBlank(callingIntent.getStringExtra("com.microsoft.aadbroker.adal.broker.request"));
    }

    protected boolean processRedirectUrl(@NonNull WebView view, @NonNull String url) {
        HashMap<String, String> parameters = StringExtensions.getUrlParameters(url);
        if (!StringExtensions.isNullOrBlank((String)parameters.get(ERROR))) {
            Logger.info(TAG, "Sending intent to cancel authentication activity");
            Intent resultIntent = new Intent();
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", (String)parameters.get(ERROR));
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorSubCode", (String)parameters.get(ERROR_SUBCODE));
            if (!StringUtil.isEmpty((String)parameters.get(ERROR_DESCRIPTION))) {
                resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", (String)parameters.get(ERROR_DESCRIPTION));
            } else {
                resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", (String)parameters.get(ERROR_SUBCODE));
            }
            if (StringUtil.equalsIgnoreCase((String)parameters.get(ERROR_SUBCODE), "cancel")) {
                this.getCompletionCallback().onChallengeResponseReceived(2001, resultIntent);
            } else {
                this.getCompletionCallback().onChallengeResponseReceived(2002, resultIntent);
            }
            view.stopLoading();
        } else {
            Logger.info(TAG, "It is pointing to redirect. Final url can be processed to get the code or error.");
            Intent resultIntent = new Intent();
            resultIntent.putExtra("com.microsoft.identity.client.final.url", url);
            this.getCompletionCallback().onChallengeResponseReceived(2003, resultIntent);
            view.stopLoading();
        }
        return true;
    }

    private boolean processWebsiteRequest(@NonNull WebView view, @NonNull String url) {
        String methodName = "#processWebsiteRequest";
        view.stopLoading();
        if (url.contains("&ismdmurl=1")) {
            Logger.info(TAG + "#processWebsiteRequest", "This is a device CA request.");
            PackageHelper packageHelper = new PackageHelper(this.getActivity().getPackageManager());
            Context applicationContext = this.getActivity().getApplicationContext();
            if (packageHelper.isPackageInstalledAndEnabled(applicationContext, "com.microsoft.skype.teams.ipphone") && "fcg80qvoM1YMKJZibjBwQcDfOno=".equals(packageHelper.getCurrentSignatureForPackage("com.microsoft.skype.teams.ipphone")) && packageHelper.isPackageInstalledAndEnabled(applicationContext, "com.microsoft.windowsintune.companyportal")) {
                try {
                    Logger.verbose(TAG + "#processWebsiteRequest", "Sending intent to launch the CompanyPortal.");
                    Intent intent = new Intent();
                    intent.setComponent(new ComponentName("com.microsoft.windowsintune.companyportal", "com.microsoft.windowsintune.companyportal.views.SplashActivity"));
                    intent.addFlags(0x10008000);
                    this.getActivity().startActivity(intent);
                    this.getCompletionCallback().onChallengeResponseReceived(2009, new Intent());
                    return true;
                }
                catch (Exception ex) {
                    Logger.warn(TAG + "#processWebsiteRequest", "Failed to launch Company Portal, falling back to browser.");
                }
            }
            this.openLinkInBrowser(url);
            this.getCompletionCallback().onChallengeResponseReceived(2009, new Intent());
            return true;
        }
        this.openLinkInBrowser(url);
        this.getCompletionCallback().onChallengeResponseReceived(2001, new Intent());
        return true;
    }

    private void openLinkInBrowser(String url) {
        String methodName = "#openLinkInBrowser";
        Logger.info(TAG + "#openLinkInBrowser", "Try to open url link in browser");
        String link = url.replace("browser://", "https://");
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)link));
        if (intent.resolveActivity(this.getActivity().getPackageManager()) != null) {
            this.getActivity().startActivity(intent);
        } else {
            Logger.warn(TAG + "#openLinkInBrowser", "Unable to find an app to resolve the activity.");
        }
    }

    private boolean processInstallRequest(final @NonNull WebView view, @NonNull String url) {
        Intent resultIntent = new Intent();
        HashMap<String, String> parameters = StringExtensions.getUrlParameters(url);
        final String installLink = parameters.get("app_link");
        String userName = parameters.get("username");
        if (TextUtils.isEmpty((CharSequence)installLink)) {
            Logger.info(TAG, "Install link is null or empty, Return to caller with BROWSER_CODE_DEVICE_REGISTER");
            resultIntent.putExtra("username", userName);
            this.getCompletionCallback().onChallengeResponseReceived(2007, resultIntent);
            view.stopLoading();
            return true;
        }
        Logger.info(TAG, "Return to caller with BROKER_REQUEST_RESUME, and waiting for result.");
        this.getCompletionCallback().onChallengeResponseReceived(2006, resultIntent);
        Handler handler = new Handler();
        int threadSleepForCallingActivity = 1000;
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                String link = installLink.replace("browser://", "https://");
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)link));
                AzureActiveDirectoryWebViewClient.this.getActivity().startActivity(intent);
                view.stopLoading();
            }
        }, 1000L);
        return true;
    }

    private boolean processInvalidUrl(@NonNull WebView view, @NonNull String url) {
        String lowerCaseUrl = url.toLowerCase(Locale.US);
        if (this.isBrokerRequest(this.getActivity().getIntent()) && url.startsWith("msauth")) {
            Logger.error(TAG, "The RedirectUri is not as expected.", null);
            Logger.errorPII(TAG, String.format("Received %s and expected %s", url, this.mRedirectUrl), null);
            this.returnError("The redirectUri for broker is invalid", String.format("The RedirectUri is not as expected. Received %s and expected %s", url, this.mRedirectUrl));
            view.stopLoading();
            return true;
        }
        if ("about:blank".equals(lowerCaseUrl)) {
            Logger.verbose(TAG, "It is an blank page request");
            return true;
        }
        if (!lowerCaseUrl.startsWith("https://")) {
            String redactedUrl = this.removeQueryParametersOrRedact(url);
            Logger.error(TAG, "The webView was redirected to an unsafe URL: " + redactedUrl, null);
            this.returnError("Redirect url scheme not SSL protected", "The webView was redirected to an unsafe URL.");
            view.stopLoading();
            return true;
        }
        Logger.infoPII(TAG, "We are declining to override loading and redirect to invalid URL: '" + this.removeQueryParametersOrRedact(url) + "' the user's url pattern is '" + this.mRedirectUrl + "'");
        return false;
    }

    private String removeQueryParametersOrRedact(@NonNull String url) {
        try {
            return StringExtensions.removeQueryParameterFromUrl(url);
        }
        catch (URISyntaxException e) {
            Logger.errorPII(TAG, "Redirect URI has invalid syntax, unable to parse", e);
            return "redacted";
        }
    }

    private void returnError(String errorCode, String errorMessage) {
        Intent resultIntent = new Intent();
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", errorCode);
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", errorMessage);
        this.getCompletionCallback().onChallengeResponseReceived(2002, resultIntent);
    }

    @TargetApi(value=21)
    public void onReceivedClientCertRequest(WebView view, ClientCertRequest clientCertRequest) {
        ClientCertAuthChallengeHandler clientCertAuthChallengeHandler = new ClientCertAuthChallengeHandler(this.getActivity());
        clientCertAuthChallengeHandler.processChallenge(clientCertRequest);
    }
}

