/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import android.security.keystore.KeyInfo;
import android.security.keystore.StrongBoxUnavailableException;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Base64InputStream;
import android.util.Base64OutputStream;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.adal.internal.cache.StorageHelper;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.controllers.TaskCompletedCallbackWithError;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.platform.IDevicePopManager;
import com.microsoft.identity.common.internal.platform.SecureHardwareState;
import com.microsoft.identity.common.internal.util.DateUtilities;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.impl.RSAKeyUtils;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.security.auth.x500.X500Principal;
import org.json.JSONException;
import org.json.JSONObject;

class DevicePopManager
implements IDevicePopManager {
    private static final String TAG = DevicePopManager.class.getSimpleName();
    private static final String DEFAULT_KEYSTORE_ENTRY_ALIAS = "microsoft-device-pop";
    private static final int RSA_KEY_SIZE = 2048;
    private static final String PRIVATE_KEY_NOT_FOUND = "Not an instance of a PrivateKeyEntry";
    private final KeyStore mKeyStore = KeyStore.getInstance("AndroidKeyStore");
    private final String mKeyAlias;
    private static final String ANDROID_KEYSTORE = "AndroidKeyStore";
    private static final ExecutorService sThreadExecutor = Executors.newCachedThreadPool();

    DevicePopManager() throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        this.mKeyStore.load(null);
        this.mKeyAlias = DEFAULT_KEYSTORE_ENTRY_ALIAS;
    }

    DevicePopManager(@NonNull String alias) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        this.mKeyStore.load(null);
        this.mKeyAlias = alias;
    }

    @Override
    public boolean asymmetricKeyExists() {
        boolean exists = false;
        try {
            exists = this.mKeyStore.containsAlias(this.mKeyAlias);
        }
        catch (KeyStoreException e) {
            Logger.error(TAG, "Error while querying KeyStore", e);
        }
        return exists;
    }

    @Override
    public boolean asymmetricKeyExists(@NonNull String thumbprint) {
        if (this.asymmetricKeyExists()) {
            try {
                return this.getAsymmetricKeyThumbprint().equals(thumbprint);
            }
            catch (ClientException e) {
                Logger.error(TAG, "Error while comparing thumbprints.", e);
            }
        }
        return false;
    }

    @Override
    public String getAsymmetricKeyThumbprint() throws ClientException {
        String errCode;
        Throwable exception;
        try {
            KeyStore.Entry keyEntry = this.mKeyStore.getEntry(this.mKeyAlias, null);
            KeyPair rsaKeyPair = DevicePopManager.getKeyPairForEntry(keyEntry);
            RSAKey rsaKey = DevicePopManager.getRsaKeyForKeyPair(rsaKeyPair);
            return DevicePopManager.getThumbprintForRsaKey(rsaKey);
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (UnrecoverableEntryException e) {
            exception = e;
            errCode = "protection_params_invalid";
        }
        catch (JOSEException e) {
            exception = e;
            errCode = "failed_to_compute_thumbprint_with_sha256";
        }
        throw new ClientException(errCode, exception.getMessage(), exception);
    }

    @Override
    public void generateAsymmetricKey(final @NonNull Context context, final @NonNull TaskCompletedCallbackWithError<String, ClientException> callback) {
        sThreadExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.onTaskCompleted(DevicePopManager.this.generateAsymmetricKey(context));
                }
                catch (ClientException e) {
                    callback.onError(e);
                }
            }
        });
    }

    @Override
    public String generateAsymmetricKey(@NonNull Context context) throws ClientException {
        String errCode;
        Throwable exception;
        try {
            KeyPair keyPair = this.generateNewRsaKeyPair(context, 2048);
            RSAKey rsaKey = DevicePopManager.getRsaKeyForKeyPair(keyPair);
            return DevicePopManager.getThumbprintForRsaKey(rsaKey);
        }
        catch (UnsupportedOperationException e) {
            exception = e;
            errCode = "keystore_produced_invalid_cert";
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (NoSuchProviderException e) {
            exception = e;
            errCode = "android_keystore_unavailable";
        }
        catch (InvalidAlgorithmParameterException e) {
            exception = e;
            errCode = "keystore_initialization_failed";
        }
        catch (JOSEException e) {
            exception = e;
            errCode = "failed_to_compute_thumbprint_with_sha256";
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(TAG, clientException.getMessage(), clientException);
        throw clientException;
    }

    @Override
    @Nullable
    public Date getAsymmetricKeyCreationDate() throws ClientException {
        try {
            return this.mKeyStore.getCreationDate(this.mKeyAlias);
        }
        catch (KeyStoreException e) {
            KeyStoreException exception = e;
            String errCode = "keystore_not_initialized";
            ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
            Logger.error(TAG, clientException.getMessage(), clientException);
            throw clientException;
        }
    }

    @Override
    public boolean clearAsymmetricKey() {
        boolean deleted = false;
        try {
            this.mKeyStore.deleteEntry(this.mKeyAlias);
            deleted = true;
        }
        catch (KeyStoreException e) {
            Logger.error(TAG, "Error while clearing KeyStore", e);
        }
        return deleted;
    }

    @Override
    public String getRequestConfirmation() throws ClientException {
        final CountDownLatch latch = new CountDownLatch(1);
        final String[] result = new String[1];
        final ClientException[] errorResult = new ClientException[1];
        this.getRequestConfirmation(new TaskCompletedCallbackWithError<String, ClientException>(){

            @Override
            public void onTaskCompleted(@NonNull String reqCnf) {
                result[0] = reqCnf;
                latch.countDown();
            }

            @Override
            public void onError(@NonNull ClientException error) {
                errorResult[0] = error;
                latch.countDown();
            }
        });
        try {
            latch.await();
            if (null != result[0]) {
                return result[0];
            }
            throw errorResult[0];
        }
        catch (InterruptedException e) {
            Logger.error(TAG, "Interrupted while waiting on callback.", e);
            throw new ClientException("operation_interrupted", e.getMessage(), e);
        }
    }

    @Override
    public void getRequestConfirmation(final @NonNull TaskCompletedCallbackWithError<String, ClientException> callback) {
        sThreadExecutor.submit(new Runnable(){

            @Override
            public void run() {
                String errCode;
                Throwable exception;
                try {
                    KeyStore.Entry keyEntry = DevicePopManager.this.mKeyStore.getEntry(DevicePopManager.this.mKeyAlias, null);
                    KeyPair rsaKeyPair = DevicePopManager.getKeyPairForEntry(keyEntry);
                    RSAKey rsaKey = DevicePopManager.getRsaKeyForKeyPair(rsaKeyPair);
                    String base64UrlEncodedJwkJsonStr = DevicePopManager.getReqCnfForRsaKey(rsaKey);
                    callback.onTaskCompleted(base64UrlEncodedJwkJsonStr);
                    return;
                }
                catch (KeyStoreException e) {
                    exception = e;
                    errCode = "keystore_not_initialized";
                }
                catch (NoSuchAlgorithmException e) {
                    exception = e;
                    errCode = "no_such_algorithm";
                }
                catch (UnrecoverableEntryException e) {
                    exception = e;
                    errCode = "protection_params_invalid";
                }
                catch (JOSEException e) {
                    exception = e;
                    errCode = "failed_to_compute_thumbprint_with_sha256";
                }
                catch (JSONException e) {
                    exception = e;
                    errCode = "json_construction_failed";
                }
                ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
                Logger.error(TAG, clientException.getMessage(), clientException);
                callback.onError(clientException);
            }
        });
    }

    @Override
    @NonNull
    public String sign(@NonNull IDevicePopManager.SigningAlgorithm alg, @NonNull String input) throws ClientException {
        String errCode;
        Exception exception;
        String methodName = ":sign";
        try {
            byte[] inputBytesToSign = input.getBytes("UTF-8");
            KeyStore.Entry keyEntry = this.mKeyStore.getEntry(this.mKeyAlias, null);
            if (!(keyEntry instanceof KeyStore.PrivateKeyEntry)) {
                Logger.warn(TAG + ":sign", PRIVATE_KEY_NOT_FOUND);
                throw new ClientException("invalid_key_private_key_missing");
            }
            Signature signature = Signature.getInstance(alg.toString());
            signature.initSign(((KeyStore.PrivateKeyEntry)keyEntry).getPrivateKey());
            signature.update(inputBytesToSign);
            byte[] signedBytes = signature.sign();
            return Base64.encodeToString((byte[])signedBytes, (int)2);
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (UnrecoverableEntryException e) {
            exception = e;
            errCode = "protection_params_invalid";
        }
        catch (InvalidKeyException e) {
            exception = e;
            errCode = "invalid_key";
        }
        catch (SignatureException e) {
            exception = e;
            errCode = "failed_to_sign";
        }
        catch (UnsupportedEncodingException e) {
            exception = e;
            errCode = "unsupported_encoding";
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(TAG, clientException.getMessage(), clientException);
        throw clientException;
    }

    @Override
    public boolean verify(@NonNull IDevicePopManager.SigningAlgorithm alg, @NonNull String plainText, @NonNull String signatureStr) {
        Exception exception;
        String errCode;
        String methodName = ":verify";
        try {
            byte[] inputBytesToVerify = plainText.getBytes("UTF-8");
            KeyStore.Entry keyEntry = this.mKeyStore.getEntry(this.mKeyAlias, null);
            if (!(keyEntry instanceof KeyStore.PrivateKeyEntry)) {
                Logger.warn(TAG + ":verify", PRIVATE_KEY_NOT_FOUND);
                return false;
            }
            Signature signature = Signature.getInstance(alg.toString());
            signature.initVerify(((KeyStore.PrivateKeyEntry)keyEntry).getCertificate());
            signature.update(inputBytesToVerify);
            byte[] signatureBytes = Base64.decode((String)signatureStr, (int)2);
            return signature.verify(signatureBytes);
        }
        catch (UnsupportedEncodingException e) {
            errCode = "unsupported_encoding";
            exception = e;
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (KeyStoreException e) {
            errCode = "keystore_not_initialized";
            exception = e;
        }
        catch (UnrecoverableEntryException e) {
            errCode = "protection_params_invalid";
            exception = e;
        }
        catch (InvalidKeyException e) {
            errCode = "invalid_key";
            exception = e;
        }
        catch (SignatureException e) {
            errCode = "failed_to_sign";
            exception = e;
        }
        Logger.error(TAG + ":verify", errCode, exception);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String encrypt(@NonNull IDevicePopManager.Cipher cipher, @NonNull String plaintext) throws ClientException {
        Exception exception;
        String errCode;
        String methodName = ":encrypt";
        try {
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)this.mKeyStore.getEntry(this.mKeyAlias, null);
            PublicKey publicKey = privateKeyEntry.getCertificate().getPublicKey();
            Cipher input = Cipher.getInstance(cipher.toString());
            input.init(1, publicKey);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Base64OutputStream base64OutputStream = new Base64OutputStream((OutputStream)byteArrayOutputStream, 0);
            CipherOutputStream cipherOutputStream = null;
            try {
                cipherOutputStream = new CipherOutputStream((OutputStream)base64OutputStream, input);
                ((OutputStream)cipherOutputStream).write(plaintext.getBytes("UTF-8"));
            }
            catch (Throwable throwable) {
                DevicePopManager.closeStream(cipherOutputStream);
                throw throwable;
            }
            DevicePopManager.closeStream(cipherOutputStream);
            byte[] encryptedBase64Data = byteArrayOutputStream.toByteArray();
            return new String(encryptedBase64Data, "UTF-8");
        }
        catch (InvalidKeyException e) {
            errCode = "invalid_key";
            exception = e;
        }
        catch (UnrecoverableEntryException e) {
            errCode = "protection_params_invalid";
            exception = e;
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (KeyStoreException e) {
            errCode = "keystore_not_initialized";
            exception = e;
        }
        catch (NoSuchPaddingException e) {
            errCode = "no_such_padding";
            exception = e;
        }
        catch (UnsupportedEncodingException e) {
            errCode = "unsupported_encoding";
            exception = e;
        }
        catch (IOException e) {
            errCode = "io_error";
            exception = e;
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(TAG + ":encrypt", errCode, exception);
        throw clientException;
    }

    private static void closeStream(@Nullable Closeable stream) {
        if (null != stream) {
            try {
                stream.close();
            }
            catch (IOException e) {
                Logger.error(TAG + ":closeStream", "Exception thrown while closing stream.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String decrypt(@NonNull IDevicePopManager.Cipher cipher, @NonNull String ciphertext) throws ClientException {
        Exception exception;
        String errCode;
        block12: {
            String string2;
            String methodName = ":decrypt";
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)this.mKeyStore.getEntry(this.mKeyAlias, null);
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            Cipher outputCipher = Cipher.getInstance(cipher.toString());
            outputCipher.init(2, privateKey);
            Base64InputStream b64InputStream = new Base64InputStream((InputStream)new ByteArrayInputStream(ciphertext.getBytes()), 0);
            CipherInputStream cipherInputStream = null;
            try {
                int chars;
                cipherInputStream = new CipherInputStream((InputStream)b64InputStream, outputCipher);
                int bufferSize = 1024;
                char[] buffer = new char[1024];
                StringBuilder outputBuilder = new StringBuilder();
                InputStreamReader in = new InputStreamReader((InputStream)cipherInputStream, "UTF-8");
                while ((chars = ((Reader)in).read(buffer, 0, buffer.length)) > 0) {
                    outputBuilder.append(buffer, 0, chars);
                }
                string2 = outputBuilder.toString();
            }
            catch (Throwable throwable) {
                try {
                    DevicePopManager.closeStream(cipherInputStream);
                    throw throwable;
                }
                catch (NoSuchAlgorithmException e) {
                    errCode = "no_such_algorithm";
                    exception = e;
                    break block12;
                }
                catch (InvalidKeyException e) {
                    errCode = "invalid_key";
                    exception = e;
                    break block12;
                }
                catch (UnrecoverableEntryException e) {
                    errCode = "protection_params_invalid";
                    exception = e;
                    break block12;
                }
                catch (NoSuchPaddingException e) {
                    errCode = "no_such_algorithm";
                    exception = e;
                    break block12;
                }
                catch (KeyStoreException e) {
                    errCode = "keystore_not_initialized";
                    exception = e;
                    break block12;
                }
                catch (UnsupportedEncodingException e) {
                    errCode = "unsupported_encoding";
                    exception = e;
                    break block12;
                }
                catch (IOException e) {
                    errCode = "io_error";
                    exception = e;
                }
            }
            DevicePopManager.closeStream(cipherInputStream);
            return string2;
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(TAG + ":decrypt", errCode, exception);
        throw clientException;
    }

    @Override
    public SecureHardwareState getSecureHardwareState() throws ClientException {
        GeneralSecurityException exception;
        String errCode;
        try {
            KeyStore.Entry keyEntry = this.mKeyStore.getEntry(this.mKeyAlias, null);
            KeyPair rsaKeyPair = DevicePopManager.getKeyPairForEntry(keyEntry);
            return this.getSecureHardwareState(rsaKeyPair);
        }
        catch (KeyStoreException e) {
            errCode = "keystore_not_initialized";
            exception = e;
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (UnrecoverableEntryException e) {
            errCode = "protection_params_invalid";
            exception = e;
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(TAG + ":getSecureHardwareState", errCode, exception);
        throw clientException;
    }

    @Override
    @NonNull
    public String getPublicKey(@NonNull IDevicePopManager.PublicKeyFormat format) throws ClientException {
        String methodName = ":getPublicKey";
        switch (format) {
            case X_509_SubjectPublicKeyInfo_ASN_1: {
                return this.getX509SubjectPublicKeyInfo();
            }
            case JWK: {
                return this.getJwkPublicKey();
            }
        }
        String errMsg = "Unrecognized or unsupported key format: " + (Object)((Object)format);
        ClientException clientException = new ClientException("unknown_public_key_export_format", errMsg);
        Logger.error(TAG + ":getPublicKey", errMsg, clientException);
        throw clientException;
    }

    @NonNull
    private String getJwkPublicKey() throws ClientException {
        String errCode;
        GeneralSecurityException exception;
        try {
            net.minidev.json.JSONObject jwkJson = this.getDevicePopJwkMinifiedJson();
            return jwkJson.getAsString("jwk");
        }
        catch (UnrecoverableEntryException e) {
            exception = e;
            errCode = "protection_params_invalid";
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(TAG, clientException.getMessage(), clientException);
        throw clientException;
    }

    private String getX509SubjectPublicKeyInfo() throws ClientException {
        String errCode;
        GeneralSecurityException exception;
        try {
            KeyStore.Entry keyEntry = this.mKeyStore.getEntry(this.mKeyAlias, null);
            KeyPair rsaKeyPair = DevicePopManager.getKeyPairForEntry(keyEntry);
            PublicKey publicKey = rsaKeyPair.getPublic();
            byte[] publicKeybytes = publicKey.getEncoded();
            byte[] bytesBase64Encoded = Base64.encode((byte[])publicKeybytes, (int)0);
            return new String(bytesBase64Encoded);
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (UnrecoverableEntryException e) {
            exception = e;
            errCode = "protection_params_invalid";
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(TAG, clientException.getMessage(), clientException);
        throw clientException;
    }

    @Override
    public String mintSignedAccessToken(@Nullable String httpMethod, long timestamp, @NonNull URL requestUrl, @NonNull String accessToken, @Nullable String nonce) throws ClientException {
        String errCode;
        Throwable exception;
        try {
            JWTClaimsSet.Builder claimsBuilder = new JWTClaimsSet.Builder();
            claimsBuilder.claim("at", (Object)accessToken);
            claimsBuilder.claim("ts", (Object)timestamp);
            claimsBuilder.claim("u", (Object)requestUrl.getAuthority());
            claimsBuilder.claim("cnf", (Object)this.getDevicePopJwkMinifiedJson());
            if (!TextUtils.isEmpty((CharSequence)requestUrl.getPath())) {
                claimsBuilder.claim("p", (Object)requestUrl.getPath());
            }
            if (!TextUtils.isEmpty((CharSequence)httpMethod)) {
                claimsBuilder.claim("m", (Object)httpMethod);
            }
            if (!TextUtils.isEmpty((CharSequence)nonce)) {
                claimsBuilder.claim("nonce", (Object)nonce);
            }
            JWTClaimsSet claimsSet = claimsBuilder.build();
            KeyStore.Entry entry = this.mKeyStore.getEntry(this.mKeyAlias, null);
            PrivateKey privateKey = ((KeyStore.PrivateKeyEntry)entry).getPrivateKey();
            RSASSASigner signer = new RSASSASigner(privateKey);
            SignedJWT signedJWT = new SignedJWT(new JWSHeader.Builder(JWSAlgorithm.RS256).keyID(this.getAsymmetricKeyThumbprint()).build(), claimsSet);
            signedJWT.sign((JWSSigner)signer);
            return signedJWT.serialize();
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        catch (JOSEException e) {
            exception = e;
            errCode = "failed_to_sign_jwt";
        }
        catch (UnrecoverableEntryException e) {
            exception = e;
            errCode = "protection_params_invalid";
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(TAG, clientException.getMessage(), clientException);
        throw clientException;
    }

    @SuppressLint(value={"NewApi"})
    private KeyPair generateNewRsaKeyPair(@NonNull Context context, int minKeySize) throws UnsupportedOperationException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        int MAX_RETRIES = 4;
        for (int ii = 0; ii < 4; ++ii) {
            KeyPair kp;
            try {
                kp = this.generateNewKeyPair(context, true);
            }
            catch (StrongBoxUnavailableException e) {
                Logger.error(TAG, "StrongBox unsupported - skipping hardware flags.", e);
                kp = this.generateNewKeyPair(context, false);
            }
            int length = RSAKeyUtils.keyBitLength((PrivateKey)kp.getPrivate());
            if (length < minKeySize && length >= 0) continue;
            this.getSecureHardwareState(kp);
            return kp;
        }
        this.clearAsymmetricKey();
        throw new UnsupportedOperationException("Failed to generate valid KeyPair. Attempted 4 times.");
    }

    private SecureHardwareState getSecureHardwareState(@NonNull KeyPair kp) {
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                PrivateKey privateKey = kp.getPrivate();
                KeyFactory factory = KeyFactory.getInstance(privateKey.getAlgorithm(), ANDROID_KEYSTORE);
                KeyInfo info = factory.getKeySpec(privateKey, KeyInfo.class);
                boolean isInsideSecureHardware = info.isInsideSecureHardware();
                Logger.info(TAG, "SecretKey is secure hardware backed? " + isInsideSecureHardware);
                return isInsideSecureHardware ? SecureHardwareState.TRUE_UNATTESTED : SecureHardwareState.FALSE;
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
                Logger.error(TAG, "Failed to query secure hardware state.", e);
                return SecureHardwareState.UNKNOWN_QUERY_ERROR;
            }
        }
        Logger.info(TAG, "Cannot query secure hardware state (API unavailable <23)");
        return SecureHardwareState.UNKNOWN_DOWNLEVEL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(api=18)
    private KeyPair generateNewKeyPair(@NonNull Context context, boolean useStrongbox) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, StrongBoxUnavailableException {
        Object object = DateUtilities.isLocaleCalendarNonGregorian(Locale.getDefault()) ? DateUtilities.LOCALE_CHANGE_LOCK : new Object();
        synchronized (object) {
            KeyPair keyPair;
            Locale currentLocale = Locale.getDefault();
            StorageHelper.applyKeyStoreLocaleWorkarounds(currentLocale);
            try {
                KeyPair keyPair2;
                KeyPairGenerator kpg = this.getInitializedRsaKeyPairGenerator(context, 2048, useStrongbox);
                keyPair = keyPair2 = kpg.generateKeyPair();
            }
            catch (Throwable throwable) {
                Locale.setDefault(currentLocale);
                throw throwable;
            }
            Locale.setDefault(currentLocale);
            return keyPair;
        }
    }

    @RequiresApi(api=18)
    private KeyPairGenerator getInitializedRsaKeyPairGenerator(@NonNull Context context, int keySize, boolean useStrongbox) throws InvalidAlgorithmParameterException, NoSuchProviderException, NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", ANDROID_KEYSTORE);
        this.initialize(context, keyPairGenerator, keySize, useStrongbox);
        return keyPairGenerator;
    }

    @RequiresApi(api=18)
    private void initialize(@NonNull Context context, @NonNull KeyPairGenerator keyPairGenerator, int keySize, boolean useStrongbox) throws InvalidAlgorithmParameterException {
        if (Build.VERSION.SDK_INT < 23) {
            this.initializePre23(context, keyPairGenerator, keySize);
        } else {
            this.initialize23(keyPairGenerator, keySize, useStrongbox);
        }
    }

    @SuppressLint(value={"InlinedApi"})
    @RequiresApi(api=23)
    private void initialize23(@NonNull KeyPairGenerator keyPairGenerator, int keySize, boolean useStrongbox) throws InvalidAlgorithmParameterException {
        KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(this.mKeyAlias, 15).setKeySize(keySize).setSignaturePaddings(new String[]{"PKCS1", "PSS"}).setDigests(new String[]{"MD5", "NONE", "SHA-256", "SHA-384", "SHA-512"}).setEncryptionPaddings(new String[]{"OAEPPadding", "PKCS1Padding"});
        if (Build.VERSION.SDK_INT >= 28 && useStrongbox) {
            Logger.verbose(TAG, "Attempting to apply StrongBox isolation.");
            builder = DevicePopManager.applyHardwareIsolation(builder);
        }
        KeyGenParameterSpec spec = builder.build();
        keyPairGenerator.initialize((AlgorithmParameterSpec)spec);
    }

    @SuppressLint(value={"NewApi"})
    @RequiresApi(value=28)
    @NonNull
    private static KeyGenParameterSpec.Builder applyHardwareIsolation(@NonNull KeyGenParameterSpec.Builder builder) {
        return builder.setIsStrongBoxBacked(true);
    }

    @SuppressLint(value={"NewApi"})
    @RequiresApi(api=18)
    private void initializePre23(@NonNull Context context, @NonNull KeyPairGenerator keyPairGenerator, int keySize) throws InvalidAlgorithmParameterException {
        Calendar calendar = Calendar.getInstance();
        Date start = DevicePopManager.getNow(calendar);
        calendar.add(1, 99);
        Date end = calendar.getTime();
        KeyPairGeneratorSpec.Builder specBuilder = new KeyPairGeneratorSpec.Builder(context).setAlias(this.mKeyAlias).setStartDate(start).setEndDate(end).setSerialNumber(CertificateProperties.SERIAL_NUMBER).setSubject(new X500Principal("CN=device-pop"));
        if (Build.VERSION.SDK_INT >= 19) {
            specBuilder.setAlgorithmParameterSpec((AlgorithmParameterSpec)new RSAKeyGenParameterSpec(keySize, RSAKeyGenParameterSpec.F4));
        }
        KeyPairGeneratorSpec spec = specBuilder.build();
        keyPairGenerator.initialize((AlgorithmParameterSpec)spec);
    }

    private static Date getNow(@NonNull Calendar calendar) {
        return calendar.getTime();
    }

    private static KeyPair getKeyPairForEntry(@NonNull KeyStore.Entry entry) {
        PrivateKey privateKey = ((KeyStore.PrivateKeyEntry)entry).getPrivateKey();
        PublicKey publicKey = ((KeyStore.PrivateKeyEntry)entry).getCertificate().getPublicKey();
        return new KeyPair(publicKey, privateKey);
    }

    private static RSAKey getRsaKeyForKeyPair(@NonNull KeyPair keyPair) {
        return new RSAKey.Builder((RSAPublicKey)keyPair.getPublic()).keyUse(null).build();
    }

    private static String getReqCnfForRsaKey(@NonNull RSAKey rsaKey) throws JOSEException, JSONException {
        String thumbprintStr = DevicePopManager.getThumbprintForRsaKey(rsaKey);
        String thumbprintMinifiedJson = new JSONObject().put("kid", (Object)thumbprintStr).toString();
        return DevicePopManager.base64UrlEncode(thumbprintMinifiedJson);
    }

    private static String getThumbprintForRsaKey(@NonNull RSAKey rsaKey) throws JOSEException {
        Base64URL thumbprint = rsaKey.computeThumbprint();
        return thumbprint.toString();
    }

    private static String base64UrlEncode(@NonNull String input) {
        String result = null;
        try {
            byte[] encodeBytes = input.getBytes("UTF-8");
            result = Base64.encodeToString((byte[])encodeBytes, (int)11);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    private net.minidev.json.JSONObject getDevicePopJwkMinifiedJson() throws UnrecoverableEntryException, NoSuchAlgorithmException, KeyStoreException {
        KeyStore.Entry keyEntry = this.mKeyStore.getEntry(this.mKeyAlias, null);
        KeyPair rsaKeyPair = DevicePopManager.getKeyPairForEntry(keyEntry);
        RSAKey rsaKey = DevicePopManager.getRsaKeyForKeyPair(rsaKeyPair);
        RSAKey publicRsaKey = rsaKey.toPublicJWK();
        net.minidev.json.JSONObject jwkContents = publicRsaKey.toJSONObject();
        net.minidev.json.JSONObject wrappedJwk = new net.minidev.json.JSONObject();
        wrappedJwk.appendField("jwk", (Object)jwkContents);
        return wrappedJwk;
    }

    static final class KeyPairGeneratorAlgorithms {
        static final String RSA = "RSA";

        KeyPairGeneratorAlgorithms() {
        }
    }

    private static final class SignedHttpRequestJwtClaims {
        private static final String ACCESS_TOKEN = "at";
        private static final String TIMESTAMP = "ts";
        private static final String HTTP_METHOD = "m";
        private static final String HTTP_HOST = "u";
        private static final String HTTP_PATH = "p";
        private static final String CNF = "cnf";
        private static final String NONCE = "nonce";
        public static final String JWK = "jwk";

        private SignedHttpRequestJwtClaims() {
        }
    }

    private static final class CertificateProperties {
        static final int CERTIFICATE_VALIDITY_YEARS = 99;
        static final BigInteger SERIAL_NUMBER = BigInteger.ONE;
        static final String COMMON_NAME = "CN=device-pop";

        private CertificateProperties() {
        }
    }
}

