/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.dto;

import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.internal.dto.Credential;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class AccessTokenRecord
extends Credential {
    @SerializedName(value="kid")
    private String mKid;
    @SerializedName(value="token_type", alternate={"access_token_type"})
    private String mAccessTokenType;
    @SerializedName(value="authority")
    private String mAuthority;
    @SerializedName(value="extended_expires_on")
    private String mExtendedExpiresOn;
    @SerializedName(value="realm")
    private String mRealm;
    @SerializedName(value="target")
    private String mTarget;
    @SerializedName(value="expires_on")
    private String mExpiresOn;

    @Nullable
    public String getKid() {
        return this.mKid;
    }

    public void setKid(@Nullable String kid) {
        this.mKid = kid;
    }

    public String getRealm() {
        return this.mRealm;
    }

    public void setRealm(String realm) {
        this.mRealm = realm;
    }

    public String getTarget() {
        return this.mTarget;
    }

    public void setTarget(String target) {
        this.mTarget = target;
    }

    public String getAccessTokenType() {
        return this.mAccessTokenType;
    }

    public void setAccessTokenType(String accessTokenType) {
        this.mAccessTokenType = accessTokenType;
    }

    public String getAuthority() {
        return this.mAuthority;
    }

    public void setAuthority(String authority) {
        this.mAuthority = authority;
    }

    public String getExtendedExpiresOn() {
        return this.mExtendedExpiresOn;
    }

    public void setExtendedExpiresOn(String extendedExpiresOn) {
        this.mExtendedExpiresOn = extendedExpiresOn;
    }

    public String getExpiresOn() {
        return this.mExpiresOn;
    }

    public void setExpiresOn(String expiresOn) {
        this.mExpiresOn = expiresOn;
    }

    private boolean isExpired(String expires) {
        Calendar calendar = Calendar.getInstance();
        Date validity = calendar.getTime();
        long epoch = Long.valueOf(expires);
        Date expiresOn = new Date(TimeUnit.SECONDS.toMillis(epoch));
        return expiresOn.before(validity);
    }

    @Override
    public boolean isExpired() {
        return this.isExpired(this.getExpiresOn());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccessTokenRecord)) {
            return false;
        }
        AccessTokenRecord other = (AccessTokenRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$mKid = this.mKid;
        String other$mKid = other.mKid;
        if (this$mKid == null ? other$mKid != null : !this$mKid.equals(other$mKid)) {
            return false;
        }
        String this$mAccessTokenType = this.mAccessTokenType;
        String other$mAccessTokenType = other.mAccessTokenType;
        if (this$mAccessTokenType == null ? other$mAccessTokenType != null : !this$mAccessTokenType.equals(other$mAccessTokenType)) {
            return false;
        }
        String this$mAuthority = this.mAuthority;
        String other$mAuthority = other.mAuthority;
        if (this$mAuthority == null ? other$mAuthority != null : !this$mAuthority.equals(other$mAuthority)) {
            return false;
        }
        String this$mExtendedExpiresOn = this.mExtendedExpiresOn;
        String other$mExtendedExpiresOn = other.mExtendedExpiresOn;
        if (this$mExtendedExpiresOn == null ? other$mExtendedExpiresOn != null : !this$mExtendedExpiresOn.equals(other$mExtendedExpiresOn)) {
            return false;
        }
        String this$mRealm = this.mRealm;
        String other$mRealm = other.mRealm;
        if (this$mRealm == null ? other$mRealm != null : !this$mRealm.equals(other$mRealm)) {
            return false;
        }
        String this$mTarget = this.mTarget;
        String other$mTarget = other.mTarget;
        if (this$mTarget == null ? other$mTarget != null : !this$mTarget.equals(other$mTarget)) {
            return false;
        }
        String this$mExpiresOn = this.mExpiresOn;
        String other$mExpiresOn = other.mExpiresOn;
        return !(this$mExpiresOn == null ? other$mExpiresOn != null : !this$mExpiresOn.equals(other$mExpiresOn));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccessTokenRecord;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $mKid = this.mKid;
        result = result * 59 + ($mKid == null ? 43 : $mKid.hashCode());
        String $mAccessTokenType = this.mAccessTokenType;
        result = result * 59 + ($mAccessTokenType == null ? 43 : $mAccessTokenType.hashCode());
        String $mAuthority = this.mAuthority;
        result = result * 59 + ($mAuthority == null ? 43 : $mAuthority.hashCode());
        String $mExtendedExpiresOn = this.mExtendedExpiresOn;
        result = result * 59 + ($mExtendedExpiresOn == null ? 43 : $mExtendedExpiresOn.hashCode());
        String $mRealm = this.mRealm;
        result = result * 59 + ($mRealm == null ? 43 : $mRealm.hashCode());
        String $mTarget = this.mTarget;
        result = result * 59 + ($mTarget == null ? 43 : $mTarget.hashCode());
        String $mExpiresOn = this.mExpiresOn;
        result = result * 59 + ($mExpiresOn == null ? 43 : $mExpiresOn.hashCode());
        return result;
    }

    public static class SerializedNames
    extends Credential.SerializedNames {
        @Deprecated
        public static final String ACCESS_TOKEN_TYPE = "access_token_type";
        public static final String TOKEN_TYPE = "token_type";
        public static final String AUTHORITY = "authority";
        public static final String EXTENDED_EXPIRES_ON = "extended_expires_on";
        public static final String REALM = "realm";
        public static final String TARGET = "target";
        public static final String KID = "kid";
    }
}

