/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.controllers;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.microsoft.identity.client.IMicrosoftAuthService;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.internal.broker.BrokerActivity;
import com.microsoft.identity.common.internal.broker.BrokerResult;
import com.microsoft.identity.common.internal.broker.BrokerResultFuture;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import com.microsoft.identity.common.internal.broker.MicrosoftAuthClient;
import com.microsoft.identity.common.internal.broker.ipc.AccountManagerAddAccountStrategy;
import com.microsoft.identity.common.internal.broker.ipc.BoundServiceStrategy;
import com.microsoft.identity.common.internal.broker.ipc.BrokerOperationBundle;
import com.microsoft.identity.common.internal.broker.ipc.ContentProviderStrategy;
import com.microsoft.identity.common.internal.broker.ipc.IIpcStrategy;
import com.microsoft.identity.common.internal.cache.HelloCache;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.internal.commands.parameters.CommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.DeviceCodeFlowCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.RemoveAccountCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.internal.controllers.BaseController;
import com.microsoft.identity.common.internal.controllers.BrokerOperationExecutor;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAccount;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.internal.providers.oauth2.IDToken;
import com.microsoft.identity.common.internal.request.MsalBrokerRequestAdapter;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.result.MsalBrokerResultAdapter;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.ApiEndEvent;
import com.microsoft.identity.common.internal.telemetry.events.ApiStartEvent;
import com.microsoft.identity.common.internal.ui.browser.Browser;
import com.microsoft.identity.common.internal.ui.browser.BrowserSelector;
import com.microsoft.identity.common.internal.util.AccountManagerUtil;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class BrokerMsalController
extends BaseController {
    private static final String TAG = BrokerMsalController.class.getSimpleName();
    protected final MsalBrokerRequestAdapter mRequestAdapter = new MsalBrokerRequestAdapter();
    protected final MsalBrokerResultAdapter mResultAdapter = new MsalBrokerResultAdapter();
    private BrokerResultFuture mBrokerResultFuture;
    private final Context mApplicationContext;
    private final String mActiveBrokerPackageName;
    private final BrokerOperationExecutor mBrokerOperationExecutor;
    private final HelloCache mHelloCache;

    public BrokerMsalController(Context applicationContext) {
        this.mApplicationContext = applicationContext;
        this.mActiveBrokerPackageName = this.getActiveBrokerPackageName();
        if (TextUtils.isEmpty((CharSequence)this.mActiveBrokerPackageName)) {
            throw new IllegalStateException("Active Broker not found. This class should not be initialized.");
        }
        this.mBrokerOperationExecutor = new BrokerOperationExecutor(BrokerMsalController.getIpcStrategies(this.mApplicationContext, this.mActiveBrokerPackageName));
        this.mHelloCache = this.getHelloCache();
    }

    @VisibleForTesting
    public HelloCache getHelloCache() {
        return new HelloCache(this.mApplicationContext, "msal.to.broker", this.mActiveBrokerPackageName);
    }

    @VisibleForTesting
    public String getActiveBrokerPackageName() {
        return new BrokerValidator(this.mApplicationContext).getCurrentActiveBrokerPackageName();
    }

    @NonNull
    private static List<IIpcStrategy> getIpcStrategies(Context applicationContext, String activeBrokerPackageName) {
        MicrosoftAuthClient client;
        ArrayList<IIpcStrategy> strategies = new ArrayList<IIpcStrategy>();
        StringBuilder sb = new StringBuilder(100);
        sb.append("Broker Strategies added : ");
        ContentProviderStrategy contentProviderStrategy = new ContentProviderStrategy(applicationContext);
        if (contentProviderStrategy.isBrokerContentProviderAvailable(activeBrokerPackageName)) {
            sb.append("ContentProviderStrategy, ");
            strategies.add(contentProviderStrategy);
        }
        if ((client = new MicrosoftAuthClient(applicationContext)).isBoundServiceSupported(activeBrokerPackageName)) {
            sb.append("BoundServiceStrategy, ");
            strategies.add(new BoundServiceStrategy<IMicrosoftAuthService>(client));
        }
        if (AccountManagerUtil.canUseAccountManagerOperation(applicationContext)) {
            sb.append("AccountManagerStrategy.");
            strategies.add(new AccountManagerAddAccountStrategy(applicationContext));
        }
        Logger.info(TAG, sb.toString());
        return strategies;
    }

    @VisibleForTesting
    @NonNull
    public String hello(@NonNull IIpcStrategy strategy, @NonNull CommandParameters parameters) throws BaseException {
        Bundle bundle = this.mRequestAdapter.getRequestBundleForHello(parameters);
        String minimumProtocolVersion = bundle.getString("required.broker.protocol.version.name");
        String maximumProtocolVersion = bundle.getString("broker.protocol.version.name");
        if (StringUtil.isEmpty(maximumProtocolVersion)) {
            throw new ClientException("missing_parameter", "maximum protocol version should never be null or empty");
        }
        String cachedProtocolVersion = this.mHelloCache.tryGetNegotiatedProtocolVersion(minimumProtocolVersion, maximumProtocolVersion);
        if (!StringUtil.isEmpty(cachedProtocolVersion)) {
            return cachedProtocolVersion;
        }
        BrokerOperationBundle helloBundle = new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_HELLO, this.mActiveBrokerPackageName, this.mRequestAdapter.getRequestBundleForHello(parameters));
        String negotiatedProtocolVersion = this.mResultAdapter.verifyHelloFromResultBundle(strategy.communicateToBroker(helloBundle));
        this.mHelloCache.saveNegotiatedProtocolVersion(minimumProtocolVersion, maximumProtocolVersion, negotiatedProtocolVersion);
        return negotiatedProtocolVersion;
    }

    @Override
    public AcquireTokenResult acquireToken(@NonNull InteractiveTokenCommandParameters parameters) throws BaseException, InterruptedException {
        AcquireTokenResult result;
        Telemetry.emit(new ApiStartEvent().putProperties(parameters).putApiId("201"));
        this.mBrokerResultFuture = new BrokerResultFuture();
        Intent interactiveRequestIntent = this.getBrokerAuthorizationIntent(parameters);
        Intent brokerActivityIntent = new Intent(parameters.getAndroidApplicationContext(), BrokerActivity.class);
        brokerActivityIntent.putExtra("broker_intent", (Parcelable)interactiveRequestIntent);
        this.mBrokerResultFuture = new BrokerResultFuture();
        parameters.getActivity().startActivity(brokerActivityIntent);
        Bundle resultBundle = this.mBrokerResultFuture.get();
        if (parameters.getOAuth2TokenCache() != null) {
            this.saveMsaAccountToCache(resultBundle, (MsalOAuth2TokenCache)parameters.getOAuth2TokenCache());
        }
        try {
            result = new MsalBrokerResultAdapter().getAcquireTokenResultFromResultBundle(resultBundle);
        }
        catch (BaseException e) {
            Telemetry.emit(new ApiEndEvent().putException(e).putApiId("201"));
            throw e;
        }
        Telemetry.emit(new ApiEndEvent().putResult(result).putApiId("201"));
        return result;
    }

    @Override
    public void completeAcquireToken(int requestCode, int resultCode, Intent data) {
        Telemetry.emit(new ApiStartEvent().putApiId("202").put("Microsoft.MSAL.result_code", String.valueOf(resultCode)).put("Microsoft.MSAL.request_code", String.valueOf(requestCode)));
        this.mBrokerResultFuture.setResultBundle(data.getExtras());
        Telemetry.emit(new ApiEndEvent().putApiId("202"));
    }

    @NonNull
    private Intent getBrokerAuthorizationIntent(final @NonNull InteractiveTokenCommandParameters parameters) throws BaseException {
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<Intent>(){
            private String negotiatedBrokerProtocolVersion;

            @Override
            public void performPrerequisites(@NonNull IIpcStrategy strategy) throws BaseException {
                this.negotiatedBrokerProtocolVersion = BrokerMsalController.this.hello(strategy, parameters);
            }

            @Override
            @NonNull
            public BrokerOperationBundle getBundle() {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_GET_INTENT_FOR_INTERACTIVE_REQUEST, BrokerMsalController.this.mActiveBrokerPackageName, null);
            }

            @Override
            @NonNull
            public Intent extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                if (resultBundle == null) {
                    throw BrokerMsalController.this.mResultAdapter.getExceptionForEmptyResultBundle();
                }
                Intent intent = BrokerMsalController.this.mResultAdapter.getIntentForInteractiveRequestFromResultBundle(resultBundle);
                intent.putExtras(BrokerMsalController.this.mRequestAdapter.getRequestBundleForAcquireTokenInteractive(parameters, this.negotiatedBrokerProtocolVersion));
                return intent;
            }

            @Override
            @NonNull
            public String getMethodName() {
                return ":getBrokerAuthorizationIntent";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return null;
            }

            @Override
            public void putValueInSuccessEvent(@NonNull ApiEndEvent event, @NonNull Intent result) {
            }
        });
    }

    @Override
    @NonNull
    public AcquireTokenResult acquireTokenSilent(final @NonNull SilentTokenCommandParameters parameters) throws BaseException {
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<AcquireTokenResult>(){
            private String negotiatedBrokerProtocolVersion;

            @Override
            public void performPrerequisites(@NonNull IIpcStrategy strategy) throws BaseException {
                this.negotiatedBrokerProtocolVersion = BrokerMsalController.this.hello(strategy, parameters);
            }

            @Override
            @NonNull
            public BrokerOperationBundle getBundle() {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_ACQUIRE_TOKEN_SILENT, BrokerMsalController.this.mActiveBrokerPackageName, BrokerMsalController.this.mRequestAdapter.getRequestBundleForAcquireTokenSilent(parameters, this.negotiatedBrokerProtocolVersion));
            }

            @Override
            @NonNull
            public AcquireTokenResult extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                if (resultBundle == null) {
                    throw BrokerMsalController.this.mResultAdapter.getExceptionForEmptyResultBundle();
                }
                return BrokerMsalController.this.mResultAdapter.getAcquireTokenResultFromResultBundle(resultBundle);
            }

            @Override
            @NonNull
            public String getMethodName() {
                return ":acquireTokenSilent";
            }

            @Override
            @NonNull
            public String getTelemetryApiId() {
                return "203";
            }

            @Override
            public void putValueInSuccessEvent(@NonNull ApiEndEvent event, @NonNull AcquireTokenResult result) {
                event.putResult(result);
            }
        });
    }

    @Override
    @NonNull
    public List<ICacheRecord> getAccounts(final @NonNull CommandParameters parameters) throws BaseException {
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<List<ICacheRecord>>(){
            private String negotiatedBrokerProtocolVersion;

            @Override
            public void performPrerequisites(@NonNull IIpcStrategy strategy) throws BaseException {
                this.negotiatedBrokerProtocolVersion = BrokerMsalController.this.hello(strategy, parameters);
            }

            @Override
            @NonNull
            public BrokerOperationBundle getBundle() {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_GET_ACCOUNTS, BrokerMsalController.this.mActiveBrokerPackageName, BrokerMsalController.this.mRequestAdapter.getRequestBundleForGetAccounts(parameters, this.negotiatedBrokerProtocolVersion));
            }

            @Override
            @NonNull
            public List<ICacheRecord> extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                if (resultBundle == null) {
                    throw BrokerMsalController.this.mResultAdapter.getExceptionForEmptyResultBundle();
                }
                return BrokerMsalController.this.mResultAdapter.getAccountsFromResultBundle(resultBundle);
            }

            @Override
            @NonNull
            public String getMethodName() {
                return ":getAccounts";
            }

            @Override
            @NonNull
            public String getTelemetryApiId() {
                return "206";
            }

            @Override
            public void putValueInSuccessEvent(@NonNull ApiEndEvent event, @NonNull List<ICacheRecord> result) {
                event.put("Microsoft.MSAL.accounts_number", Integer.toString(result.size()));
            }
        });
    }

    @Override
    public boolean removeAccount(final @NonNull RemoveAccountCommandParameters parameters) throws BaseException {
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<Boolean>(){
            private String negotiatedBrokerProtocolVersion;

            @Override
            public void performPrerequisites(@NonNull IIpcStrategy strategy) throws BaseException {
                this.negotiatedBrokerProtocolVersion = BrokerMsalController.this.hello(strategy, parameters);
            }

            @Override
            @NonNull
            public BrokerOperationBundle getBundle() {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_REMOVE_ACCOUNT, BrokerMsalController.this.mActiveBrokerPackageName, BrokerMsalController.this.mRequestAdapter.getRequestBundleForRemoveAccount(parameters, this.negotiatedBrokerProtocolVersion));
            }

            @Override
            @NonNull
            public Boolean extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                BrokerMsalController.this.mResultAdapter.verifyRemoveAccountResultFromBundle(resultBundle);
                return true;
            }

            @Override
            @NonNull
            public String getMethodName() {
                return ":removeAccount";
            }

            @Override
            @NonNull
            public String getTelemetryApiId() {
                return "207";
            }

            @Override
            public void putValueInSuccessEvent(@NonNull ApiEndEvent event, @NonNull Boolean result) {
            }
        });
    }

    @Override
    public boolean getDeviceMode(@NonNull CommandParameters parameters) throws BaseException {
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<Boolean>(){

            @Override
            public void performPrerequisites(@NonNull IIpcStrategy strategy) {
            }

            @Override
            @NonNull
            public BrokerOperationBundle getBundle() {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_GET_DEVICE_MODE, BrokerMsalController.this.mActiveBrokerPackageName, null);
            }

            @Override
            @NonNull
            public Boolean extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                if (resultBundle == null) {
                    throw BrokerMsalController.this.mResultAdapter.getExceptionForEmptyResultBundle();
                }
                return BrokerMsalController.this.mResultAdapter.getDeviceModeFromResultBundle(resultBundle);
            }

            @Override
            @NonNull
            public String getMethodName() {
                return ":getDeviceMode";
            }

            @Override
            @NonNull
            public String getTelemetryApiId() {
                return "204";
            }

            @Override
            public void putValueInSuccessEvent(@NonNull ApiEndEvent event, @NonNull Boolean result) {
                event.put("Microsoft.MSAL.is_device_shared", Boolean.toString(result));
            }
        });
    }

    @Override
    @NonNull
    public List<ICacheRecord> getCurrentAccount(final @NonNull CommandParameters parameters) throws BaseException {
        String methodName = ":getCurrentAccount";
        if (!parameters.isSharedDevice()) {
            Logger.verbose(TAG + ":getCurrentAccount", "Not a shared device, invoke getAccounts() instead of getCurrentAccount()");
            return this.getAccounts(parameters);
        }
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<List<ICacheRecord>>(){
            private String negotiatedBrokerProtocolVersion;

            @Override
            public void performPrerequisites(@NonNull IIpcStrategy strategy) throws BaseException {
                this.negotiatedBrokerProtocolVersion = BrokerMsalController.this.hello(strategy, parameters);
            }

            @Override
            @NonNull
            public BrokerOperationBundle getBundle() {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_GET_CURRENT_ACCOUNT_IN_SHARED_DEVICE, BrokerMsalController.this.mActiveBrokerPackageName, BrokerMsalController.this.mRequestAdapter.getRequestBundleForGetAccounts(parameters, this.negotiatedBrokerProtocolVersion));
            }

            @Override
            @NonNull
            public List<ICacheRecord> extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                if (resultBundle == null) {
                    throw BrokerMsalController.this.mResultAdapter.getExceptionForEmptyResultBundle();
                }
                return BrokerMsalController.this.mResultAdapter.getAccountsFromResultBundle(resultBundle);
            }

            @Override
            @NonNull
            public String getMethodName() {
                return ":getCurrentAccount";
            }

            @Override
            @NonNull
            public String getTelemetryApiId() {
                return "205";
            }

            @Override
            public void putValueInSuccessEvent(@NonNull ApiEndEvent event, @NonNull List<ICacheRecord> result) {
                event.put("Microsoft.MSAL.accounts_number", Integer.toString(result.size()));
            }
        });
    }

    @Override
    public boolean removeCurrentAccount(final @NonNull RemoveAccountCommandParameters parameters) throws BaseException {
        String methodName = ":removeCurrentAccount";
        if (!parameters.isSharedDevice()) {
            Logger.verbose(TAG + ":removeCurrentAccount", "Not a shared device, invoke removeAccount() instead of removeCurrentAccount()");
            return this.removeAccount(parameters);
        }
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<Boolean>(){
            private String negotiatedBrokerProtocolVersion;

            @Override
            public void performPrerequisites(@NonNull IIpcStrategy strategy) throws BaseException {
                this.negotiatedBrokerProtocolVersion = BrokerMsalController.this.hello(strategy, parameters);
            }

            @Override
            @NonNull
            public BrokerOperationBundle getBundle() {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_SIGN_OUT_FROM_SHARED_DEVICE, BrokerMsalController.this.mActiveBrokerPackageName, BrokerMsalController.this.mRequestAdapter.getRequestBundleForRemoveAccountFromSharedDevice(parameters, this.negotiatedBrokerProtocolVersion));
            }

            @Override
            @NonNull
            public Boolean extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                BrokerMsalController.this.mResultAdapter.verifyRemoveAccountResultFromBundle(resultBundle);
                BrokerMsalController.this.logOutFromBrowser(BrokerMsalController.this.mApplicationContext, parameters);
                return true;
            }

            @Override
            @NonNull
            public String getMethodName() {
                return ":removeCurrentAccount";
            }

            @Override
            @NonNull
            public String getTelemetryApiId() {
                return "208";
            }

            @Override
            public void putValueInSuccessEvent(@NonNull ApiEndEvent event, @NonNull Boolean result) {
            }
        });
    }

    private void logOutFromBrowser(@NonNull Context context, @NonNull RemoveAccountCommandParameters parameters) {
        String methodName = ":logOutFromBrowser";
        String browserPackageName = null;
        try {
            Browser browser = BrowserSelector.select(context, parameters.getBrowserSafeList());
            browserPackageName = browser.getPackageName();
        }
        catch (ClientException e) {
            Logger.error(TAG, e.getErrorCode(), e);
        }
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setFlags(0x10000000);
            intent.setData(Uri.parse((String)"https://login.microsoftonline.com/common/oauth2/v2.0/logout"));
            if (browserPackageName != null) {
                intent.setPackage(browserPackageName);
            }
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Logger.error(TAG + ":logOutFromBrowser", "Failed to launch browser sign out with browser=[" + browserPackageName + "]. Skipping.", e);
        }
    }

    @Override
    public AuthorizationResult deviceCodeFlowAuthRequest(DeviceCodeFlowCommandParameters parameters) throws ClientException {
        throw new ClientException("deviceCodeFlowAuthRequest() not supported in BrokerMsalController");
    }

    @Override
    public AcquireTokenResult acquireDeviceCodeFlowToken(AuthorizationResult authorizationResult, DeviceCodeFlowCommandParameters commandParameters) throws ClientException {
        throw new ClientException("acquireDeviceCodeFlowToken() not supported in BrokerMsalController");
    }

    private void saveMsaAccountToCache(@NonNull Bundle resultBundle, @NonNull MsalOAuth2TokenCache msalOAuth2TokenCache) throws BaseException {
        String methodName = ":saveMsaAccountToCache";
        BrokerResult brokerResult = new MsalBrokerResultAdapter().brokerResultFromBundle(resultBundle);
        if (resultBundle.getBoolean("broker_request_v2_success") && "9188040d-6c67-4c5b-b112-36a304b66dad".equalsIgnoreCase(brokerResult.getTenantId())) {
            Logger.info(TAG + ":saveMsaAccountToCache", "Result returned for MSA Account, saving to cache");
            if (StringUtil.isEmpty(brokerResult.getClientInfo())) {
                Logger.error(TAG + ":saveMsaAccountToCache", "ClientInfo is empty.", null);
                throw new ClientException("unknown_error", "ClientInfo is empty.");
            }
            try {
                ClientInfo clientInfo = new ClientInfo(brokerResult.getClientInfo());
                MicrosoftStsAccount microsoftStsAccount = new MicrosoftStsAccount(new IDToken(brokerResult.getIdToken()), clientInfo);
                microsoftStsAccount.setEnvironment(brokerResult.getEnvironment());
                MicrosoftRefreshToken microsoftRefreshToken = new MicrosoftRefreshToken(brokerResult.getRefreshToken(), clientInfo, brokerResult.getScope(), brokerResult.getClientId(), brokerResult.getEnvironment(), brokerResult.getFamilyId());
                this.msalOAuth2TokenCacheSetSingleSignOnState(msalOAuth2TokenCache, microsoftStsAccount, microsoftRefreshToken);
            }
            catch (ServiceException e) {
                Logger.errorPII(TAG + ":saveMsaAccountToCache", "Exception while creating Idtoken or ClientInfo, cannot save MSA account tokens", e);
                throw new ClientException("invalid_jwt", e.getMessage(), e);
            }
        }
    }

    private void msalOAuth2TokenCacheSetSingleSignOnState(@NonNull MsalOAuth2TokenCache msalOAuth2TokenCache, MicrosoftStsAccount microsoftStsAccount, MicrosoftRefreshToken microsoftRefreshToken) throws ClientException {
        msalOAuth2TokenCache.setSingleSignOnState(microsoftStsAccount, microsoftRefreshToken);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrokerMsalController)) {
            return false;
        }
        BrokerMsalController other = (BrokerMsalController)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BrokerMsalController;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

