/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.microsoft.identity.common.BaseAccount;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.cache.AccountDeletionRecord;
import com.microsoft.identity.common.internal.cache.IAccountCredentialAdapter;
import com.microsoft.identity.common.internal.cache.IAccountCredentialCache;
import com.microsoft.identity.common.internal.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.dto.Credential;
import com.microsoft.identity.common.internal.dto.CredentialType;
import com.microsoft.identity.common.internal.dto.RefreshTokenRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsTokenResponse;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.internal.providers.oauth2.RefreshToken;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MsalCppOAuth2TokenCache<GenericOAuth2Strategy extends OAuth2Strategy, GenericAuthorizationRequest extends AuthorizationRequest, GenericTokenResponse extends TokenResponse, GenericAccount extends BaseAccount, GenericRefreshToken extends RefreshToken>
extends MsalOAuth2TokenCache<GenericOAuth2Strategy, GenericAuthorizationRequest, GenericTokenResponse, GenericAccount, GenericRefreshToken> {
    private static final String TAG = MsalCppOAuth2TokenCache.class.getName();

    private MsalCppOAuth2TokenCache(Context context, IAccountCredentialCache accountCredentialCache, IAccountCredentialAdapter accountCredentialAdapter) {
        super(context, accountCredentialCache, accountCredentialAdapter);
    }

    public static MsalCppOAuth2TokenCache create(@NonNull Context context) {
        MsalOAuth2TokenCache<MicrosoftStsOAuth2Strategy, MicrosoftStsAuthorizationRequest, MicrosoftStsTokenResponse, MicrosoftAccount, MicrosoftRefreshToken> msalOAuth2TokenCache = MsalOAuth2TokenCache.create(context);
        MsalCppOAuth2TokenCache msalCppOAuth2TokenCache = new MsalCppOAuth2TokenCache(context, msalOAuth2TokenCache.getAccountCredentialCache(), msalOAuth2TokenCache.getAccountCredentialAdapter());
        return msalCppOAuth2TokenCache;
    }

    public synchronized void saveCredentials(@Nullable AccountRecord accountRecord, Credential ... credentials) throws ClientException {
        if (credentials == null || credentials.length == 0) {
            throw new ClientException("Credential array passed in is null or empty");
        }
        RefreshTokenRecord refreshTokenRecord = null;
        for (Credential credential : credentials) {
            if (!(credential instanceof RefreshTokenRecord)) continue;
            refreshTokenRecord = (RefreshTokenRecord)credential;
        }
        if (accountRecord != null && refreshTokenRecord != null) {
            this.removeRefreshTokenIfNeeded(accountRecord, refreshTokenRecord);
        }
        this.saveCredentialsInternal(credentials);
    }

    public synchronized void saveAccountRecord(@NonNull AccountRecord accountRecord) {
        this.getAccountCredentialCache().saveAccount(accountRecord);
    }

    @VisibleForTesting(otherwise=5)
    public synchronized void clearCache() {
        this.getAccountCredentialCache().clearAll();
    }

    @VisibleForTesting(otherwise=5)
    public synchronized List<Credential> getCredentials() {
        return Collections.unmodifiableList(this.getAccountCredentialCache().getCredentials());
    }

    @VisibleForTesting
    public synchronized AccountDeletionRecord forceRemoveAccount(@NonNull String homeAccountId, @Nullable String environment, @NonNull String realm) throws ClientException {
        this.validateNonNull(homeAccountId, "homeAccountId");
        this.validateNonNull(realm, "realm");
        boolean mustMatchOnEnvironment = !StringExtensions.isNullOrBlank(environment);
        ArrayList<AccountRecord> removedAccounts = new ArrayList<AccountRecord>();
        for (AccountRecord accountRecord : this.getAllAccounts()) {
            boolean accountRemoved;
            boolean matches;
            boolean bl = matches = accountRecord.getHomeAccountId().equals(homeAccountId) && accountRecord.getRealm().equals(realm);
            if (mustMatchOnEnvironment) {
                boolean bl2 = matches = matches && accountRecord.getEnvironment().equals(environment);
            }
            if (!matches || !(accountRemoved = this.getAccountCredentialCache().removeAccount(accountRecord))) continue;
            removedAccounts.add(accountRecord);
        }
        return new AccountDeletionRecord(removedAccounts);
    }

    public synchronized AccountDeletionRecord removeAccount(@NonNull String homeAccountId, @Nullable String environment, @NonNull String realm) throws ClientException {
        this.validateNonNull(homeAccountId, "homeAccountId");
        this.validateNonNull(realm, "realm");
        List<Credential> credentials = this.getAccountCredentialCache().getCredentialsFilteredBy(homeAccountId, environment, CredentialType.RefreshToken, null, realm, null, "Bearer");
        if (credentials != null && !credentials.isEmpty()) {
            String clientId = credentials.get(0).getClientId();
            return this.removeAccount(environment, clientId, homeAccountId, realm, CredentialType.AccessToken, CredentialType.AccessToken_With_AuthScheme, CredentialType.IdToken, CredentialType.V1IdToken);
        }
        return this.forceRemoveAccount(homeAccountId, environment, realm);
    }

    public List<AccountRecord> getAllAccounts() {
        return Collections.unmodifiableList(this.getAccountCredentialCache().getAccounts());
    }

    @Nullable
    public AccountRecord getAccount(@NonNull String homeAccountId, @NonNull String environment, @NonNull String realm) throws ClientException {
        String methodName = ":getAccount";
        this.validateNonNull(homeAccountId, "homeAccountId");
        this.validateNonNull(environment, "environment");
        this.validateNonNull(realm, "realm");
        List<AccountRecord> accountRecords = this.getAccountCredentialCache().getAccountsFilteredBy(homeAccountId, environment, realm);
        if (accountRecords == null || accountRecords.isEmpty()) {
            Logger.info(TAG + ":getAccount", "No account found for the passing in homeAccountId: " + homeAccountId + " environment: " + environment + " realm: " + realm);
            return null;
        }
        return accountRecords.get(0);
    }
}

