/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.internal.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.internal.request.SdkType;
import java.io.Serializable;

public class BrokerRequest
implements Serializable {
    private static final long serialVersionUID = 542024304389420837L;
    @SerializedName(value="authority")
    @NonNull
    private String mAuthority;
    @SerializedName(value="scopes")
    @NonNull
    private String mScope;
    @SerializedName(value="redirect_uri")
    @NonNull
    private String mRedirect;
    @SerializedName(value="client_id")
    @NonNull
    private String mClientId;
    @SerializedName(value="username")
    @NonNull
    private String mUserName;
    @SerializedName(value="home_account_id")
    @Nullable
    private String mHomeAccountId;
    @SerializedName(value="local_account_id")
    private String mLocalAccountId;
    @SerializedName(value="extra_query_param")
    @Nullable
    private String mExtraQueryStringParameter;
    @SerializedName(value="correlation_id")
    @NonNull
    private String mCorrelationId;
    @SerializedName(value="prompt")
    @Nullable
    private String mPrompt;
    @SerializedName(value="claims")
    @Nullable
    private String mClaims;
    @SerializedName(value="force_refresh")
    @Nullable
    private boolean mForceRefresh;
    @SerializedName(value="client_app_name")
    @NonNull
    private String mApplicationName;
    @SerializedName(value="client_app_version")
    @NonNull
    private String mApplicationVersion;
    @SerializedName(value="client_version")
    @NonNull
    private String mMsalVersion;
    @SerializedName(value="client_sdk_type")
    @NonNull
    private SdkType mSdkType;
    @SerializedName(value="environment")
    @NonNull
    private String mEnvironment;
    @SerializedName(value="multiple_clouds_supported")
    @NonNull
    private boolean mMultipleCloudsSupported;
    @SerializedName(value="authorization_agent")
    @NonNull
    private String mAuthorizationAgent;
    @SerializedName(value="authentication_scheme")
    @Nullable
    private AbstractAuthenticationScheme mAuthenticationScheme;
    @SerializedName(value="power_opt_check_enabled")
    @Nullable
    private boolean mPowerOptCheckEnabled;

    private BrokerRequest(Builder builder) {
        this.mAuthority = builder.mAuthority;
        this.mScope = builder.mScope;
        this.mRedirect = builder.mRedirect;
        this.mClientId = builder.mClientId;
        this.mHomeAccountId = builder.mHomeAccountId;
        this.mLocalAccountId = builder.mLocalAccountId;
        this.mUserName = builder.mUserName;
        this.mExtraQueryStringParameter = builder.mExtraQueryStringParameter;
        this.mCorrelationId = builder.mCorrelationId;
        this.mPrompt = builder.mPrompt;
        this.mClaims = builder.mClaims;
        this.mForceRefresh = builder.mForceRefresh;
        this.mApplicationName = builder.mApplicationName;
        this.mApplicationVersion = builder.mApplicationVersion;
        this.mMsalVersion = builder.mMsalVersion;
        this.mSdkType = builder.mSdkType;
        this.mEnvironment = builder.mEnvironment;
        this.mMultipleCloudsSupported = builder.mMultipleCloudsSupported;
        this.mAuthorizationAgent = builder.mAuthorizationAgent;
        this.mAuthenticationScheme = builder.mAuthenticationScheme;
        this.mPowerOptCheckEnabled = builder.mPowerOptCheckEnabled;
    }

    public String getAuthority() {
        return this.mAuthority;
    }

    public String getScope() {
        return this.mScope;
    }

    public String getRedirect() {
        return this.mRedirect;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public String getHomeAccountId() {
        return this.mHomeAccountId;
    }

    public String getLocalAccountId() {
        return this.mLocalAccountId;
    }

    public String getUserName() {
        return this.mUserName;
    }

    public String getExtraQueryStringParameter() {
        return this.mExtraQueryStringParameter;
    }

    public String getCorrelationId() {
        return this.mCorrelationId;
    }

    public String getPrompt() {
        return this.mPrompt;
    }

    public String getClaims() {
        return this.mClaims;
    }

    public boolean getForceRefresh() {
        return this.mForceRefresh;
    }

    public String getApplicationName() {
        return this.mApplicationName;
    }

    public String getApplicationVersion() {
        return this.mApplicationVersion;
    }

    public String getMsalVersion() {
        return this.mMsalVersion;
    }

    public SdkType getSdkType() {
        return this.mSdkType;
    }

    public String getEnvironment() {
        return this.mEnvironment;
    }

    public boolean getMultipleCloudsSupported() {
        return this.mMultipleCloudsSupported;
    }

    public String getAuthorizationAgent() {
        return this.mAuthorizationAgent;
    }

    public AbstractAuthenticationScheme getAuthenticationScheme() {
        return this.mAuthenticationScheme;
    }

    public boolean isPowerOptCheckEnabled() {
        return this.mPowerOptCheckEnabled;
    }

    public static class Builder {
        private String mAuthority;
        private String mScope;
        private String mRedirect;
        private String mClientId;
        private String mUserName;
        private String mHomeAccountId;
        private String mLocalAccountId;
        private String mExtraQueryStringParameter;
        private String mCorrelationId;
        private String mPrompt;
        private String mClaims;
        private boolean mForceRefresh;
        private String mApplicationName;
        private String mApplicationVersion;
        private String mMsalVersion;
        private SdkType mSdkType;
        private String mEnvironment;
        private boolean mMultipleCloudsSupported;
        private String mAuthorizationAgent;
        private AbstractAuthenticationScheme mAuthenticationScheme;
        private boolean mPowerOptCheckEnabled;

        public Builder authority(@NonNull String authority) {
            this.mAuthority = authority;
            return this;
        }

        public Builder scope(@NonNull String scope) {
            this.mScope = scope;
            return this;
        }

        public Builder redirect(@NonNull String redirect) {
            this.mRedirect = redirect;
            return this;
        }

        public Builder clientId(@NonNull String clientId) {
            this.mClientId = clientId;
            return this;
        }

        public Builder username(@Nullable String userName) {
            this.mUserName = userName;
            return this;
        }

        public Builder homeAccountId(@Nullable String userId) {
            this.mHomeAccountId = userId;
            return this;
        }

        public Builder localAccountId(@Nullable String localAccountId) {
            this.mLocalAccountId = localAccountId;
            return this;
        }

        public Builder extraQueryStringParameter(@Nullable String extraQueryStringParameter) {
            this.mExtraQueryStringParameter = extraQueryStringParameter;
            return this;
        }

        public Builder correlationId(@Nullable String correlationId) {
            this.mCorrelationId = correlationId;
            return this;
        }

        public Builder prompt(@Nullable String prompt) {
            this.mPrompt = prompt;
            return this;
        }

        public Builder claims(@Nullable String claims) {
            this.mClaims = claims;
            return this;
        }

        public Builder forceRefresh(boolean forceRefresh) {
            this.mForceRefresh = forceRefresh;
            return this;
        }

        public Builder applicationName(@NonNull String applicationName) {
            this.mApplicationName = applicationName;
            return this;
        }

        public Builder applicationVersion(@NonNull String applicationVersion) {
            this.mApplicationVersion = applicationVersion;
            return this;
        }

        @NonNull
        public Builder msalVersion(@NonNull String version) {
            this.mMsalVersion = version;
            return this;
        }

        @NonNull
        public Builder sdkType(@NonNull SdkType sdkType) {
            this.mSdkType = sdkType;
            return this;
        }

        public Builder environment(@NonNull String environment) {
            this.mEnvironment = environment;
            return this;
        }

        public Builder multipleCloudsSupported(@NonNull boolean multipleCloudsSupported) {
            this.mMultipleCloudsSupported = multipleCloudsSupported;
            return this;
        }

        public Builder authorizationAgent(@NonNull String authorizationAgent) {
            this.mAuthorizationAgent = authorizationAgent;
            return this;
        }

        public Builder authenticationScheme(@NonNull AbstractAuthenticationScheme authenticationScheme) {
            this.mAuthenticationScheme = authenticationScheme;
            return this;
        }

        public Builder powerOptCheckEnabled(boolean powerOptCheckEnabled) {
            this.mPowerOptCheckEnabled = powerOptCheckEnabled;
            return this;
        }

        public BrokerRequest build() {
            return new BrokerRequest(this);
        }
    }

    private class SerializedNames {
        static final String AUTHORITY = "authority";
        static final String SCOPE = "scopes";
        static final String REDIRECT = "redirect_uri";
        static final String CLIENT_ID = "client_id";
        static final String HOME_ACCOUNT_ID = "home_account_id";
        static final String LOCAL_ACCOUNT_ID = "local_account_id";
        static final String USERNAME = "username";
        static final String EXTRA_QUERY_STRING_PARAMETER = "extra_query_param";
        static final String CORRELATION_ID = "correlation_id";
        static final String PROMPT = "prompt";
        static final String CLAIMS = "claims";
        static final String FORCE_REFRESH = "force_refresh";
        static final String CLIENT_APP_NAME = "client_app_name";
        static final String CLIENT_APP_VERSION = "client_app_version";
        static final String CLIENT_VERSION = "client_version";
        static final String CLIENT_SDK_TYPE = "client_sdk_type";
        static final String ENVIRONMENT = "environment";
        static final String MULTIPLE_CLOUDS_SUPPORTED = "multiple_clouds_supported";
        static final String AUTHORIZATION_AGENT = "authorization_agent";
        static final String AUTHENTICATION_SCHEME = "authentication_scheme";
        static final String POWER_OPT_CHECK_ENABLED = "power_opt_check_enabled";

        private SerializedNames() {
        }
    }
}

