/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker.ipc;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.exception.BrokerCommunicationException;
import com.microsoft.identity.common.internal.broker.ipc.IIpcStrategy;
import com.microsoft.identity.common.internal.logging.Logger;

public class BrokerOperationBundle {
    private static final String TAG = BrokerOperationBundle.class.getName();
    @NonNull
    private final Operation operation;
    @NonNull
    private final String targetBrokerAppPackageName;
    @Nullable
    private final Bundle bundle;

    public Bundle getAccountManagerBundle() throws BrokerCommunicationException {
        Bundle requestBundle = this.bundle;
        if (requestBundle == null) {
            requestBundle = new Bundle();
        }
        requestBundle.putString("com.microsoft.broker_accountmanager_operation_key", this.getAccountManagerAddAccountOperationKey());
        return requestBundle;
    }

    private String getAccountManagerAddAccountOperationKey() throws BrokerCommunicationException {
        String methodName = ":getAccountManagerAddAccountOperationKey";
        switch (this.operation) {
            case MSAL_HELLO: {
                return "HELLO";
            }
            case MSAL_GET_INTENT_FOR_INTERACTIVE_REQUEST: {
                return "GET_INTENT_FOR_INTERACTIVE_REQUEST";
            }
            case MSAL_ACQUIRE_TOKEN_SILENT: {
                return "ACQUIRE_TOKEN_SILENT";
            }
            case MSAL_GET_ACCOUNTS: {
                return "GET_ACCOUNTS";
            }
            case MSAL_REMOVE_ACCOUNT: {
                return "REMOVE_ACCOUNT";
            }
            case MSAL_GET_DEVICE_MODE: {
                return "GET_DEVICE_MODE";
            }
            case MSAL_GET_CURRENT_ACCOUNT_IN_SHARED_DEVICE: {
                return "GET_CURRENT_ACCOUNT";
            }
            case MSAL_SIGN_OUT_FROM_SHARED_DEVICE: {
                return "REMOVE_ACCOUNT_FROM_SHARED_DEVICE";
            }
        }
        String errorMessage = "Operation " + this.operation.name() + " is not supported by AccountManager addAccount().";
        Logger.warn(TAG + ":getAccountManagerAddAccountOperationKey", errorMessage);
        throw new BrokerCommunicationException(BrokerCommunicationException.Category.OPERATION_NOT_SUPPORTED_ON_CLIENT_SIDE, IIpcStrategy.Type.ACCOUNT_MANAGER_ADD_ACCOUNT, errorMessage, null);
    }

    public String getContentProviderPath() throws BrokerCommunicationException {
        String methodName = ":getContentProviderUriPath";
        switch (this.operation) {
            case MSAL_HELLO: {
                return "/hello";
            }
            case MSAL_GET_INTENT_FOR_INTERACTIVE_REQUEST: {
                return "/acquireTokenInteractive";
            }
            case MSAL_ACQUIRE_TOKEN_SILENT: {
                return "/acquireTokenSilent";
            }
            case MSAL_GET_ACCOUNTS: {
                return "/getAccounts";
            }
            case MSAL_REMOVE_ACCOUNT: {
                return "/removeAccounts";
            }
            case MSAL_GET_DEVICE_MODE: {
                return "/getDeviceMode";
            }
            case MSAL_GET_CURRENT_ACCOUNT_IN_SHARED_DEVICE: {
                return "/getCurrentAccountSharedDevice";
            }
            case MSAL_SIGN_OUT_FROM_SHARED_DEVICE: {
                return "/signOutFromSharedDevice";
            }
            case BROKER_API_HELLO: {
                return "/brokerApi/hello";
            }
            case BROKER_API_GET_BROKER_ACCOUNTS: {
                return "/brokerApi/getBrokerAccounts";
            }
            case BROKER_API_REMOVE_BROKER_ACCOUNT: {
                return "/brokerApi/removeBrokerAccount";
            }
            case BROKER_API_UPDATE_BRT: {
                return "/brokerApi/updateBrt";
            }
        }
        String errorMessage = "Operation " + this.operation.name() + " is not supported by ContentProvider.";
        Logger.warn(TAG + ":getContentProviderUriPath", errorMessage);
        throw new BrokerCommunicationException(BrokerCommunicationException.Category.OPERATION_NOT_SUPPORTED_ON_CLIENT_SIDE, IIpcStrategy.Type.CONTENT_PROVIDER, errorMessage, null);
    }

    public BrokerOperationBundle(@NonNull Operation operation, @NonNull String targetBrokerAppPackageName, @Nullable Bundle bundle) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        if (targetBrokerAppPackageName == null) {
            throw new NullPointerException("targetBrokerAppPackageName is marked non-null but is null");
        }
        this.operation = operation;
        this.targetBrokerAppPackageName = targetBrokerAppPackageName;
        this.bundle = bundle;
    }

    @NonNull
    public Operation getOperation() {
        return this.operation;
    }

    @NonNull
    public String getTargetBrokerAppPackageName() {
        return this.targetBrokerAppPackageName;
    }

    @Nullable
    public Bundle getBundle() {
        return this.bundle;
    }

    public static enum Operation {
        MSAL_HELLO,
        MSAL_GET_INTENT_FOR_INTERACTIVE_REQUEST,
        MSAL_ACQUIRE_TOKEN_SILENT,
        MSAL_GET_ACCOUNTS,
        MSAL_REMOVE_ACCOUNT,
        MSAL_GET_DEVICE_MODE,
        MSAL_GET_CURRENT_ACCOUNT_IN_SHARED_DEVICE,
        MSAL_SIGN_OUT_FROM_SHARED_DEVICE,
        BROKER_GET_KEY_FROM_INACTIVE_BROKER,
        BROKER_API_HELLO,
        BROKER_API_GET_BROKER_ACCOUNTS,
        BROKER_API_REMOVE_BROKER_ACCOUNT,
        BROKER_API_UPDATE_BRT;

    }
}

