/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.gson.Gson;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.internal.controllers.TaskCompletedCallbackWithError;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.net.HttpRequest;
import com.microsoft.identity.common.internal.net.HttpResponse;
import com.microsoft.identity.common.internal.providers.oauth2.OpenIdProviderConfiguration;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class OpenIdProviderConfigurationClient {
    private static final String TAG = OpenIdProviderConfigurationClient.class.getSimpleName();
    private static final String sWellKnownConfig = "/.well-known/openid-configuration";
    private static final ExecutorService sBackgroundExecutor = Executors.newCachedThreadPool();
    private static final Map<URL, OpenIdProviderConfiguration> sConfigCache = new HashMap<URL, OpenIdProviderConfiguration>();
    private final String mIssuer;
    private final Gson mGson = new Gson();

    public OpenIdProviderConfigurationClient(@NonNull String issuer) {
        this.mIssuer = Uri.parse((String)this.sanitize(issuer)).toString();
    }

    public OpenIdProviderConfigurationClient(@NonNull String authority, @NonNull String path) {
        this(authority, path, "");
    }

    public OpenIdProviderConfigurationClient(@NonNull String authority, @NonNull String path, @NonNull String endpointVersion) {
        this.mIssuer = new Uri.Builder().scheme("https").authority(authority).appendPath(path).appendPath(endpointVersion).build().toString();
    }

    private String sanitize(@NonNull String issuer) {
        String sanitizedIssuer = issuer.trim();
        if (issuer.endsWith("/")) {
            sanitizedIssuer = issuer.substring(0, sanitizedIssuer.length() - 1);
        }
        return sanitizedIssuer;
    }

    public void loadOpenIdProviderConfiguration(final @NonNull OpenIdProviderConfigurationCallback callback) {
        sBackgroundExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.onTaskCompleted(OpenIdProviderConfigurationClient.this.loadOpenIdProviderConfiguration());
                }
                catch (ServiceException e) {
                    callback.onError(e);
                }
            }
        });
    }

    public synchronized OpenIdProviderConfiguration loadOpenIdProviderConfiguration() throws ServiceException {
        String methodName = ":loadOpenIdProviderConfiguration";
        try {
            URL configUrl = new URL(this.mIssuer + sWellKnownConfig);
            OpenIdProviderConfiguration cacheResult = sConfigCache.get(configUrl);
            if (null != cacheResult) {
                Logger.info(TAG + ":loadOpenIdProviderConfiguration", "Using cached metadata result.");
                return cacheResult;
            }
            Logger.verbose(TAG + ":loadOpenIdProviderConfiguration", "Config URL is valid.");
            Logger.verbosePII(TAG + ":loadOpenIdProviderConfiguration", "Using request URL: " + configUrl);
            HttpResponse providerConfigResponse = HttpRequest.sendGet(configUrl, new HashMap<String, String>());
            int statusCode = providerConfigResponse.getStatusCode();
            if (200 != statusCode || TextUtils.isEmpty((CharSequence)providerConfigResponse.getBody())) {
                throw new ServiceException("failed_to_load_openid_configuration", "OpenId Provider Configuration metadata failed to load with status: " + statusCode, null);
            }
            OpenIdProviderConfiguration parsedConfig = this.parseMetadata(providerConfigResponse.getBody());
            this.cacheConfiguration(configUrl, parsedConfig);
            return parsedConfig;
        }
        catch (IOException e) {
            throw new ServiceException("failed_to_load_openid_configuration", "IOException while requesting metadata", e);
        }
    }

    private void cacheConfiguration(@NonNull URL configUrl, @NonNull OpenIdProviderConfiguration parsedConfig) {
        sConfigCache.put(configUrl, parsedConfig);
    }

    private OpenIdProviderConfiguration parseMetadata(@NonNull String body) {
        return (OpenIdProviderConfiguration)this.mGson.fromJson(body, OpenIdProviderConfiguration.class);
    }

    public static interface OpenIdProviderConfigurationCallback
    extends TaskCompletedCallbackWithError<OpenIdProviderConfiguration, Exception> {
    }
}

