/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.controllers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.IntuneAppProtectionPolicyRequiredException;
import com.microsoft.identity.common.exception.UserCancelException;
import com.microsoft.identity.common.internal.commands.BaseCommand;
import com.microsoft.identity.common.internal.commands.InteractiveTokenCommand;
import com.microsoft.identity.common.internal.commands.parameters.BrokerInteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.internal.controllers.CommandResult;
import com.microsoft.identity.common.internal.controllers.CommandResultCache;
import com.microsoft.identity.common.internal.controllers.ExceptionAdapter;
import com.microsoft.identity.common.internal.eststelemetry.EstsTelemetry;
import com.microsoft.identity.common.internal.logging.DiagnosticContext;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.logging.RequestContext;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.result.FinalizableResultFuture;
import com.microsoft.identity.common.internal.result.LocalAuthenticationResult;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.util.BiConsumer;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class CommandDispatcher {
    private static final String TAG = CommandDispatcher.class.getSimpleName();
    private static final int SILENT_REQUEST_THREAD_POOL_SIZE = 5;
    private static final ExecutorService sInteractiveExecutor = Executors.newSingleThreadExecutor();
    private static final ExecutorService sSilentExecutor = Executors.newFixedThreadPool(5);
    private static final Object sLock = new Object();
    private static InteractiveTokenCommand sCommand = null;
    private static final CommandResultCache sCommandResultCache = new CommandResultCache();
    private static final Object mapAccessLock = new Object();
    @GuardedBy(value="mapAccessLock")
    private static ConcurrentMap<BaseCommand, FinalizableResultFuture<CommandResult>> sExecutingCommandMap = new ConcurrentHashMap<BaseCommand, FinalizableResultFuture<CommandResult>>();

    private static void cleanMap(BaseCommand command) {
        ConcurrentHashMap<BaseCommand, FinalizableResultFuture<CommandResult>> newMap = new ConcurrentHashMap<BaseCommand, FinalizableResultFuture<CommandResult>>();
        for (Map.Entry e : sExecutingCommandMap.entrySet()) {
            if (command == e.getKey()) continue;
            newMap.put((BaseCommand)e.getKey(), (FinalizableResultFuture<CommandResult>)e.getValue());
        }
        sExecutingCommandMap = newMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(otherwise=5)
    public static int outstandingCommands() {
        Object object = mapAccessLock;
        synchronized (object) {
            return sExecutingCommandMap.size();
        }
    }

    public static void submitSilent(@NonNull BaseCommand command) {
        CommandDispatcher.submitSilentReturningFuture(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(otherwise=2)
    public static FinalizableResultFuture<CommandResult> submitSilentReturningFuture(final @NonNull BaseCommand command) {
        String methodName = ":submitSilent";
        Logger.verbose(TAG + ":submitSilent", "Beginning execution of silent command.");
        Handler handler = new Handler(Looper.getMainLooper());
        Object object = mapAccessLock;
        synchronized (object) {
            FinalizableResultFuture<CommandResult> future = (FinalizableResultFuture<CommandResult>)sExecutingCommandMap.get(command);
            if (null == future) {
                future = new FinalizableResultFuture<CommandResult>();
                FinalizableResultFuture<CommandResult> putValue = sExecutingCommandMap.putIfAbsent(command, future);
                if (null != putValue) {
                    putValue.whenComplete(CommandDispatcher.getCommandResultConsumer(command, handler));
                    return putValue;
                }
            } else {
                future.whenComplete(CommandDispatcher.getCommandResultConsumer(command, handler));
                return future;
            }
            future.whenComplete(CommandDispatcher.getCommandResultConsumer(command, handler));
            final FinalizableResultFuture<CommandResult> finalFuture = future;
            sSilentExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object correlationId;
                    try {
                        correlationId = CommandDispatcher.initializeDiagnosticContext(command.getParameters().getCorrelationId());
                        command.getParameters().setCorrelationId((String)correlationId);
                        EstsTelemetry.getInstance().initTelemetryForCommand(command);
                        EstsTelemetry.getInstance().emitApiId(command.getPublicApiId());
                        CommandResult commandResult = null;
                        if (command.getParameters() instanceof SilentTokenCommandParameters) {
                            CommandDispatcher.logSilentRequestParams(":submitSilent", (SilentTokenCommandParameters)command.getParameters());
                            EstsTelemetry.getInstance().emitForceRefresh(((SilentTokenCommandParameters)command.getParameters()).isForceRefresh());
                        }
                        if ((commandResult = sCommandResultCache.get(command)) == null) {
                            commandResult = CommandDispatcher.executeCommand(command);
                            CommandDispatcher.cacheCommandResult(command, commandResult);
                        } else {
                            Logger.info(TAG + ":submitSilent", "Silent command result returned from cache.");
                        }
                        CommandDispatcher.setCorrelationIdOnResult(commandResult, (String)correlationId);
                        Telemetry.getInstance().flush((String)correlationId);
                        EstsTelemetry.getInstance().flush(command, commandResult);
                        finalFuture.setResult(commandResult);
                    }
                    catch (Throwable t) {
                        finalFuture.setException(new ExecutionException(t));
                    }
                    finally {
                        correlationId = mapAccessLock;
                        synchronized (correlationId) {
                            FinalizableResultFuture mapFuture = (FinalizableResultFuture)sExecutingCommandMap.remove(command);
                            if (mapFuture == null) {
                                Logger.error(TAG, "The command in the map has mutated " + command.getClass().getCanonicalName() + " the calling application was " + command.getParameters().getApplicationName(), null);
                                CommandDispatcher.cleanMap(command);
                            }
                            finalFuture.setCleanedUp();
                        }
                    }
                }
            });
            return finalFuture;
        }
    }

    private static BiConsumer<CommandResult, Throwable> getCommandResultConsumer(final @NonNull BaseCommand command, final @NonNull Handler handler) {
        return new BiConsumer<CommandResult, Throwable>(){

            @Override
            public void accept(CommandResult result, final Throwable throwable) {
                if (null != throwable) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            command.getCallback().onError(throwable);
                        }
                    });
                    return;
                }
                CommandDispatcher.returnCommandResult(command, result, handler);
            }
        };
    }

    static void clearCommandCache() {
        sCommandResultCache.clear();
    }

    private static CommandResult executeCommand(BaseCommand command) {
        Object result = null;
        BaseException baseException = null;
        try {
            result = command.execute();
        }
        catch (Exception e) {
            baseException = e instanceof BaseException ? (BaseException)e : ExceptionAdapter.baseExceptionFromException(e);
        }
        CommandResult commandResult = baseException != null ? (baseException instanceof UserCancelException ? new CommandResult(CommandResult.ResultStatus.CANCEL, null) : new CommandResult(CommandResult.ResultStatus.ERROR, baseException)) : (result != null && result instanceof AcquireTokenResult ? CommandDispatcher.getCommandResultFromTokenResult(baseException, result) : new CommandResult(CommandResult.ResultStatus.COMPLETED, result));
        return commandResult;
    }

    private static void returnCommandResult(final BaseCommand command, final CommandResult result, Handler handler) {
        handler.post(new Runnable(){

            @Override
            public void run() {
                switch (result.getStatus()) {
                    case ERROR: {
                        command.getCallback().onError(result.getResult());
                        break;
                    }
                    case COMPLETED: {
                        command.getCallback().onTaskCompleted(result.getResult());
                        break;
                    }
                    case CANCEL: {
                        command.getCallback().onCancel();
                    }
                }
            }
        });
    }

    private static void cacheCommandResult(BaseCommand command, CommandResult commandResult) {
        if (command.isEligibleForCaching() && CommandDispatcher.eligibleToCache(commandResult)) {
            sCommandResultCache.put(command, commandResult);
        }
    }

    private static boolean eligibleToCache(CommandResult commandResult) {
        switch (commandResult.getStatus()) {
            case ERROR: {
                return CommandDispatcher.eligibleToCacheException((BaseException)commandResult.getResult());
            }
            case COMPLETED: {
                return true;
            }
        }
        return false;
    }

    private static boolean eligibleToCacheException(BaseException exception) {
        return !(exception instanceof IntuneAppProtectionPolicyRequiredException);
    }

    private static CommandResult getCommandResultFromTokenResult(BaseException baseException, AcquireTokenResult result) {
        if (result.getSucceeded().booleanValue()) {
            return new CommandResult(CommandResult.ResultStatus.COMPLETED, result.getLocalAuthenticationResult());
        }
        baseException = ExceptionAdapter.exceptionFromAcquireTokenResult(result);
        if (baseException instanceof UserCancelException) {
            return new CommandResult(CommandResult.ResultStatus.CANCEL, null);
        }
        return new CommandResult(CommandResult.ResultStatus.ERROR, baseException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void beginInteractive(final InteractiveTokenCommand command) {
        String methodName = ":beginInteractive";
        Logger.info(TAG + ":beginInteractive", "Beginning interactive request");
        Object object = sLock;
        synchronized (object) {
            final LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)command.getParameters().getAndroidApplicationContext());
            if (command.getParameters() instanceof BrokerInteractiveTokenCommandParameters) {
                localBroadcastManager.sendBroadcast(new Intent("cancel_interactive_request"));
            }
            sInteractiveExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    String correlationId = CommandDispatcher.initializeDiagnosticContext(command.getParameters().getCorrelationId());
                    command.getParameters().setCorrelationId(correlationId);
                    EstsTelemetry.getInstance().initTelemetryForCommand(command);
                    EstsTelemetry.getInstance().emitApiId(command.getPublicApiId());
                    if (command.getParameters() instanceof InteractiveTokenCommandParameters) {
                        CommandDispatcher.logInteractiveRequestParameters(":beginInteractive", (InteractiveTokenCommandParameters)command.getParameters());
                    }
                    BroadcastReceiver resultReceiver = new BroadcastReceiver(){

                        public void onReceive(Context context, Intent intent) {
                            CommandDispatcher.completeInteractive(intent);
                        }
                    };
                    Handler handler = new Handler(Looper.getMainLooper());
                    localBroadcastManager.registerReceiver(resultReceiver, new IntentFilter("return_interactive_request_result"));
                    sCommand = command;
                    CommandResult commandResult = CommandDispatcher.executeCommand(command);
                    sCommand = null;
                    localBroadcastManager.unregisterReceiver(resultReceiver);
                    CommandDispatcher.setCorrelationIdOnResult(commandResult, correlationId);
                    EstsTelemetry.getInstance().flush(command, commandResult);
                    Telemetry.getInstance().flush(correlationId);
                    CommandDispatcher.returnCommandResult(command, commandResult, handler);
                }
            });
        }
    }

    private static void logInteractiveRequestParameters(String methodName, InteractiveTokenCommandParameters params) {
        Logger.info(TAG + methodName, "Requested " + params.getScopes().size() + " scopes");
        Logger.infoPII(TAG + methodName, "----\nRequested scopes:");
        for (String string : params.getScopes()) {
            Logger.infoPII(TAG + methodName, "\t" + string);
        }
        Logger.infoPII(TAG + methodName, "----");
        Logger.infoPII(TAG + methodName, "ClientId: [" + params.getClientId() + "]");
        Logger.infoPII(TAG + methodName, "RedirectUri: [" + params.getRedirectUri() + "]");
        Logger.infoPII(TAG + methodName, "Login hint: [" + params.getLoginHint() + "]");
        if (null != params.getExtraQueryStringParameters()) {
            Logger.infoPII(TAG + methodName, "Extra query params:");
            for (Pair pair : params.getExtraQueryStringParameters()) {
                Logger.infoPII(TAG + methodName, "\t\"" + (String)pair.first + "\":\"" + (String)pair.second + "\"");
            }
        }
        if (null != params.getExtraScopesToConsent()) {
            Logger.infoPII(TAG + methodName, "Extra scopes to consent:");
            for (String string : params.getExtraScopesToConsent()) {
                Logger.infoPII(TAG + methodName, "\t" + string);
            }
        }
        Logger.info(TAG + methodName, "Using authorization agent: " + params.getAuthorizationAgent().toString());
        if (null != params.getAccount()) {
            Logger.infoPII(TAG + methodName, "Using account: " + params.getAccount().getHomeAccountId());
        }
    }

    private static void logSilentRequestParams(String methodName, SilentTokenCommandParameters parameters) {
        Logger.infoPII(TAG + methodName, "ClientId: [" + parameters.getClientId() + "]");
        Logger.infoPII(TAG + methodName, "----\nRequested scopes:");
        for (String scope : parameters.getScopes()) {
            Logger.infoPII(TAG + methodName, "\t" + scope);
        }
        Logger.infoPII(TAG + methodName, "----");
        if (null != parameters.getAccount()) {
            Logger.infoPII(TAG + methodName, "Using account: " + parameters.getAccount().getHomeAccountId());
        }
        Logger.info(TAG + methodName, "Force refresh? [" + parameters.isForceRefresh() + "]");
    }

    private static void completeInteractive(Intent resultIntent) {
        String methodName = ":completeInteractive";
        int requestCode = resultIntent.getIntExtra("com.microsoft.identity.client.request.code", 0);
        int resultCode = resultIntent.getIntExtra("com.microsoft.identity.client.result.code", 0);
        if (sCommand != null) {
            sCommand.notify(requestCode, resultCode, resultIntent);
        } else {
            Logger.warn(TAG + ":completeInteractive", "sCommand is null, No interactive call in progress to complete.");
        }
    }

    public static String initializeDiagnosticContext(@Nullable String requestCorrelationId) {
        String methodName = ":initializeDiagnosticContext";
        String correlationId = TextUtils.isEmpty((CharSequence)requestCorrelationId) ? UUID.randomUUID().toString() : requestCorrelationId;
        RequestContext rc = new RequestContext();
        rc.put("correlation_id", correlationId);
        DiagnosticContext.setRequestContext(rc);
        Logger.verbose(TAG + ":initializeDiagnosticContext", "Initialized new DiagnosticContext");
        return correlationId;
    }

    public static int getCachedResultCount() {
        return sCommandResultCache.getSize();
    }

    private static void setCorrelationIdOnResult(@NonNull CommandResult commandResult, @NonNull String correlationId) {
        if (commandResult.getResult() != null && commandResult.getResult() instanceof LocalAuthenticationResult) {
            LocalAuthenticationResult localAuthenticationResult = (LocalAuthenticationResult)commandResult.getResult();
            localAuthenticationResult.setCorrelationId(correlationId);
        }
    }
}

