/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.commands;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.commands.BaseCommand;
import com.microsoft.identity.common.internal.commands.CommandCallback;
import com.microsoft.identity.common.internal.commands.parameters.CommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.RemoveAccountCommandParameters;
import com.microsoft.identity.common.internal.controllers.BaseController;
import com.microsoft.identity.common.internal.logging.Logger;
import java.util.List;

public class RemoveCurrentAccountCommand
extends BaseCommand<Boolean> {
    private static final String TAG = RemoveCurrentAccountCommand.class.getSimpleName();

    public RemoveCurrentAccountCommand(@NonNull RemoveAccountCommandParameters parameters, @NonNull BaseController controller, @NonNull CommandCallback callback, @NonNull String publicApiId) {
        super((CommandParameters)parameters, controller, callback, publicApiId);
    }

    public RemoveCurrentAccountCommand(@NonNull RemoveAccountCommandParameters parameters, @NonNull List<BaseController> controllers, @NonNull CommandCallback callback, @NonNull String publicApiId) {
        super((CommandParameters)parameters, controllers, callback, publicApiId);
    }

    @Override
    public Boolean execute() throws Exception {
        String methodName = ":execute";
        for (BaseController controller : this.getControllers()) {
            Logger.verbose(TAG + ":execute", "Executing with controller: " + controller.getClass().getSimpleName());
            boolean removed = controller.removeCurrentAccount((RemoveAccountCommandParameters)this.getParameters());
            if (!removed) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEligibleForEstsTelemetry() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveCurrentAccountCommand)) {
            return false;
        }
        RemoveCurrentAccountCommand other = (RemoveCurrentAccountCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RemoveCurrentAccountCommand;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

