/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.commands;

import android.content.Intent;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.commands.CommandCallback;
import com.microsoft.identity.common.internal.commands.TokenCommand;
import com.microsoft.identity.common.internal.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.TokenCommandParameters;
import com.microsoft.identity.common.internal.controllers.BaseController;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import java.util.List;

public class InteractiveTokenCommand
extends TokenCommand {
    private static final String TAG = InteractiveTokenCommand.class.getSimpleName();

    public InteractiveTokenCommand(@NonNull InteractiveTokenCommandParameters parameters, @NonNull BaseController controller, @NonNull CommandCallback callback, @NonNull String publicApiId) {
        super((TokenCommandParameters)parameters, controller, callback, publicApiId);
    }

    public InteractiveTokenCommand(@NonNull InteractiveTokenCommandParameters parameters, @NonNull List<BaseController> controllers, @NonNull CommandCallback callback, @NonNull String publicApiId) {
        super((TokenCommandParameters)parameters, controllers, callback, publicApiId);
    }

    @Override
    public AcquireTokenResult execute() throws Exception {
        String methodName = ":execute";
        if (this.getParameters() instanceof InteractiveTokenCommandParameters) {
            Logger.info(TAG + ":execute", "Executing interactive token command...");
            return this.getDefaultController().acquireToken((InteractiveTokenCommandParameters)this.getParameters());
        }
        throw new IllegalArgumentException("Invalid operation parameters");
    }

    @Override
    public void notify(int requestCode, int resultCode, Intent data) {
        this.getDefaultController().completeAcquireToken(requestCode, resultCode, data);
    }

    @Override
    public boolean isEligibleForEstsTelemetry() {
        return true;
    }

    @Override
    public boolean isEligibleForCaching() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InteractiveTokenCommand)) {
            return false;
        }
        InteractiveTokenCommand other = (InteractiveTokenCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InteractiveTokenCommand;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

