/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.commands;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.commands.Command;
import com.microsoft.identity.common.internal.commands.CommandCallback;
import com.microsoft.identity.common.internal.commands.parameters.CommandParameters;
import com.microsoft.identity.common.internal.controllers.BaseController;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseCommand<T>
implements Command<T> {
    private CommandParameters parameters;
    private CommandCallback callback;
    private List<BaseController> controllers;
    private String publicApiId;

    public BaseCommand(@NonNull CommandParameters parameters, @NonNull BaseController controller, @NonNull CommandCallback callback, @NonNull String publicApiId) {
        this.parameters = parameters;
        this.controllers = new ArrayList<BaseController>();
        this.callback = callback;
        this.controllers.add(controller);
        this.publicApiId = publicApiId;
    }

    public BaseCommand(@NonNull CommandParameters parameters, @NonNull List<BaseController> controllers, @NonNull CommandCallback callback, @NonNull String publicApiId) {
        this.parameters = parameters;
        this.controllers = controllers;
        this.callback = callback;
        this.publicApiId = publicApiId;
    }

    @Override
    public abstract T execute() throws Exception;

    @Override
    public BaseController getDefaultController() {
        return this.controllers.get(0);
    }

    @Override
    public boolean isEligibleForCaching() {
        return false;
    }

    public CommandParameters getParameters() {
        return this.parameters;
    }

    public CommandCallback getCallback() {
        return this.callback;
    }

    public List<BaseController> getControllers() {
        return this.controllers;
    }

    public String getPublicApiId() {
        return this.publicApiId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseCommand)) {
            return false;
        }
        BaseCommand other = (BaseCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CommandParameters this$parameters = this.getParameters();
        CommandParameters other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        List<BaseController> this$controllers = this.getControllers();
        List<BaseController> other$controllers = other.getControllers();
        return !(this$controllers == null ? other$controllers != null : !((Object)this$controllers).equals(other$controllers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseCommand;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CommandParameters $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        List<BaseController> $controllers = this.getControllers();
        result = result * 59 + ($controllers == null ? 43 : ((Object)$controllers).hashCode());
        return result;
    }
}

