/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import android.accounts.AccountManager;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.BrokerCommunicationException;
import com.microsoft.identity.common.internal.broker.BrokerBaseStrategy;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.commands.parameters.CommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.RemoveAccountCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.BrokerEndEvent;
import com.microsoft.identity.common.internal.telemetry.events.BrokerStartEvent;
import java.io.IOException;
import java.util.List;

public class BrokerAccountManagerStrategy
extends BrokerBaseStrategy {
    private static final String TAG = BrokerAccountManagerStrategy.class.getSimpleName();

    @SuppressLint(value={"MissingPermission"})
    public <T extends CommandParameters, U> U invokeBrokerAccountManagerOperation(T parameters, OperationInfo<T, U> operationInfo) throws BaseException {
        U result;
        String methodName = operationInfo.getMethodName();
        Telemetry.emit(new BrokerStartEvent().putAction(methodName).putStrategy("account_manager"));
        try {
            AccountManager accountManager = AccountManager.get((Context)parameters.getAndroidApplicationContext());
            AccountManagerFuture resultBundle = accountManager.addAccount("com.microsoft.workaccount", "adal.authtoken.type", null, operationInfo.getRequestBundle(parameters), null, null, this.getPreferredHandler());
            Logger.verbose(TAG + methodName, "Received result from broker");
            result = operationInfo.getResultFromBundle((Bundle)resultBundle.getResult());
        }
        catch (AuthenticatorException | OperationCanceledException | IOException e) {
            Logger.error(TAG + methodName, e.getMessage(), e);
            Telemetry.emit(new BrokerEndEvent().putAction(methodName).isSuccessful(false).putErrorCode("io_error").putErrorDescription(e.getMessage()));
            throw new BrokerCommunicationException("Failed to connect to AccountManager", e);
        }
        catch (BaseException e) {
            Logger.error(TAG + methodName, e.getMessage(), e);
            Telemetry.emit(new BrokerEndEvent().putAction(methodName).isSuccessful(false).putErrorCode(e.getErrorCode()).putErrorDescription(e.getMessage()));
            throw e;
        }
        Telemetry.emit(new BrokerEndEvent().putAction(methodName).isSuccessful(true));
        return result;
    }

    @Override
    @WorkerThread
    @SuppressLint(value={"MissingPermission"})
    public String hello(@NonNull CommandParameters parameters) throws BaseException {
        return this.invokeBrokerAccountManagerOperation(parameters, new OperationInfo<CommandParameters, String>(){

            @Override
            public Bundle getRequestBundle(CommandParameters parameters) {
                Bundle requestBundle = BrokerAccountManagerStrategy.this.mRequestAdapter.getRequestBundleForHello(parameters);
                requestBundle.putString("com.microsoft.broker_accountmanager_operation_key", "HELLO");
                return requestBundle;
            }

            @Override
            public String getMethodName() {
                return ":helloWithAccountManager";
            }

            @Override
            public String getResultFromBundle(Bundle bundle) throws BaseException {
                return BrokerAccountManagerStrategy.this.mResultAdapter.verifyHelloFromResultBundle(bundle);
            }
        });
    }

    @Override
    @WorkerThread
    public Intent getBrokerAuthorizationIntent(final @NonNull InteractiveTokenCommandParameters parameters, final @Nullable String negotiatedBrokerProtocolVersion) throws BaseException {
        String methodName = ":getBrokerAuthorizationIntent";
        Logger.verbose(TAG + ":getBrokerAuthorizationIntent", "Get the broker authorization intent from AccountManager.");
        return this.invokeBrokerAccountManagerOperation(parameters, new OperationInfo<InteractiveTokenCommandParameters, Intent>(){

            @Override
            public Bundle getRequestBundle(InteractiveTokenCommandParameters parameters2) {
                Bundle requestBundle = new Bundle();
                requestBundle.putString("com.microsoft.broker_accountmanager_operation_key", "GET_INTENT_FOR_INTERACTIVE_REQUEST");
                requestBundle.putString("common.broker.protocol.version.name", negotiatedBrokerProtocolVersion);
                return requestBundle;
            }

            @Override
            public String getMethodName() {
                return ":getBrokerAuthorizationIntent";
            }

            @Override
            public Intent getResultFromBundle(Bundle bundle) {
                Intent interactiveRequestIntent = (Intent)bundle.getParcelable("intent");
                return BrokerAccountManagerStrategy.this.completeInteractiveRequestIntent(interactiveRequestIntent, parameters, negotiatedBrokerProtocolVersion);
            }
        });
    }

    @Override
    @WorkerThread
    public AcquireTokenResult acquireTokenSilent(@NonNull SilentTokenCommandParameters parameters, final @Nullable String negotiatedBrokerProtocolVersion) throws BaseException {
        return this.invokeBrokerAccountManagerOperation(parameters, new OperationInfo<SilentTokenCommandParameters, AcquireTokenResult>(){

            @Override
            public Bundle getRequestBundle(SilentTokenCommandParameters parameters) {
                Bundle requestBundle = BrokerAccountManagerStrategy.this.mRequestAdapter.getRequestBundleForAcquireTokenSilent(parameters, negotiatedBrokerProtocolVersion);
                requestBundle.putString("com.microsoft.broker_accountmanager_operation_key", "ACQUIRE_TOKEN_SILENT");
                return requestBundle;
            }

            @Override
            public String getMethodName() {
                return ":acquireTokenSilentWithAccountManager";
            }

            @Override
            public AcquireTokenResult getResultFromBundle(Bundle bundle) throws BaseException {
                return BrokerAccountManagerStrategy.this.mResultAdapter.getAcquireTokenResultFromResultBundle(bundle);
            }
        });
    }

    @Override
    @WorkerThread
    public List<ICacheRecord> getBrokerAccounts(@NonNull CommandParameters parameters, final @Nullable String negotiatedBrokerProtocolVersion) throws BaseException {
        return this.invokeBrokerAccountManagerOperation(parameters, new OperationInfo<CommandParameters, List<ICacheRecord>>(){

            @Override
            public Bundle getRequestBundle(CommandParameters parameters) {
                Bundle requestBundle = BrokerAccountManagerStrategy.this.mRequestAdapter.getRequestBundleForGetAccounts(parameters, negotiatedBrokerProtocolVersion);
                requestBundle.putString("com.microsoft.broker_accountmanager_operation_key", "GET_ACCOUNTS");
                return requestBundle;
            }

            @Override
            public String getMethodName() {
                return ":getBrokerAccountsWithAccountManager";
            }

            @Override
            public List<ICacheRecord> getResultFromBundle(Bundle bundle) throws BaseException {
                return BrokerAccountManagerStrategy.this.mResultAdapter.getAccountsFromResultBundle(bundle);
            }
        });
    }

    @Override
    @WorkerThread
    public void removeBrokerAccount(@NonNull RemoveAccountCommandParameters parameters, final @Nullable String negotiatedBrokerProtocolVersion) throws BaseException {
        this.invokeBrokerAccountManagerOperation(parameters, new OperationInfo<RemoveAccountCommandParameters, Void>(){

            @Override
            public Bundle getRequestBundle(RemoveAccountCommandParameters parameters) {
                Bundle requestBundle = BrokerAccountManagerStrategy.this.mRequestAdapter.getRequestBundleForRemoveAccount(parameters, negotiatedBrokerProtocolVersion);
                requestBundle.putString("com.microsoft.broker_accountmanager_operation_key", "REMOVE_ACCOUNT");
                return requestBundle;
            }

            @Override
            public String getMethodName() {
                return ":removeBrokerAccountWithAccountManager";
            }

            @Override
            public Void getResultFromBundle(Bundle bundle) throws BaseException {
                BrokerAccountManagerStrategy.this.mResultAdapter.verifyRemoveAccountResultFromBundle(bundle);
                return null;
            }
        });
    }

    @Override
    public boolean getDeviceMode(@NonNull CommandParameters parameters, final @Nullable String negotiatedBrokerProtocolVersion) throws BaseException {
        return this.invokeBrokerAccountManagerOperation(parameters, new OperationInfo<CommandParameters, Boolean>(){

            @Override
            public Bundle getRequestBundle(CommandParameters parameters) {
                Bundle requestBundle = new Bundle();
                requestBundle.putString("com.microsoft.broker_accountmanager_operation_key", "GET_DEVICE_MODE");
                requestBundle.putString("common.broker.protocol.version.name", negotiatedBrokerProtocolVersion);
                return requestBundle;
            }

            @Override
            public String getMethodName() {
                return ":getDeviceModeWithAccountManager";
            }

            @Override
            public Boolean getResultFromBundle(Bundle bundle) throws BaseException {
                return BrokerAccountManagerStrategy.this.mResultAdapter.getDeviceModeFromResultBundle(bundle);
            }
        });
    }

    @Override
    public List<ICacheRecord> getCurrentAccountInSharedDevice(@NonNull CommandParameters parameters, final @Nullable String negotiatedBrokerProtocolVersion) throws BaseException {
        return this.invokeBrokerAccountManagerOperation(parameters, new OperationInfo<CommandParameters, List<ICacheRecord>>(){

            @Override
            public Bundle getRequestBundle(CommandParameters parameters) {
                Bundle requestBundle = BrokerAccountManagerStrategy.this.mRequestAdapter.getRequestBundleForGetAccounts(parameters, negotiatedBrokerProtocolVersion);
                requestBundle.putString("com.microsoft.broker_accountmanager_operation_key", "GET_CURRENT_ACCOUNT");
                return requestBundle;
            }

            @Override
            public String getMethodName() {
                return ":getCurrentAccountInSharedDeviceWithAccountManager";
            }

            @Override
            public List<ICacheRecord> getResultFromBundle(Bundle bundle) throws BaseException {
                return BrokerAccountManagerStrategy.this.mResultAdapter.getAccountsFromResultBundle(bundle);
            }
        });
    }

    @Override
    public void signOutFromSharedDevice(@NonNull RemoveAccountCommandParameters parameters, final @Nullable String negotiatedBrokerProtocolVersion) throws BaseException {
        this.invokeBrokerAccountManagerOperation(parameters, new OperationInfo<RemoveAccountCommandParameters, Void>(){

            @Override
            public Bundle getRequestBundle(RemoveAccountCommandParameters parameters) {
                Bundle requestBundle = BrokerAccountManagerStrategy.this.mRequestAdapter.getRequestBundleForRemoveAccountFromSharedDevice(parameters, negotiatedBrokerProtocolVersion);
                requestBundle.putString("com.microsoft.broker_accountmanager_operation_key", "REMOVE_ACCOUNT_FROM_SHARED_DEVICE");
                return requestBundle;
            }

            @Override
            public String getMethodName() {
                return ":signOutFromSharedDeviceWithAccountManager";
            }

            @Override
            public Void getResultFromBundle(Bundle bundle) throws BaseException {
                BrokerAccountManagerStrategy.this.mResultAdapter.verifyRemoveAccountResultFromBundle(bundle);
                return null;
            }
        });
    }

    public static interface OperationInfo<T extends CommandParameters, U> {
        public Bundle getRequestBundle(T var1);

        public String getMethodName();

        public U getResultFromBundle(Bundle var1) throws BaseException;
    }
}

