/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.webkit.CookieManager;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.ui.webview.ProcessUtil;

public class WebViewUtil {
    @SuppressLint(value={"NewApi"})
    public static void setDataDirectorySuffix(@NonNull Context context) {
        if (Build.VERSION.SDK_INT >= 28) {
            try {
                if (ProcessUtil.isRunningOnAuthService(context)) {
                    WebView.setDataDirectorySuffix((String)"auth");
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public static void setAcceptCookie(boolean acceptCookie, Context context) {
        CookieManager cookieManager = WebViewUtil.getCookieManager(context);
        cookieManager.setAcceptCookie(acceptCookie);
    }

    public static void removeCookiesFromWebView(Context context) {
        CookieManager cookieManager = WebViewUtil.getCookieManager(context);
        cookieManager.removeAllCookies(null);
        cookieManager.flush();
    }

    public static void removeSessionCookiesFromWebView(Context context) {
        CookieManager cookieManager = WebViewUtil.getCookieManager(context);
        cookieManager.removeAllCookies(null);
        cookieManager.flush();
    }

    private static CookieManager getCookieManager(Context context) {
        WebViewUtil.setDataDirectorySuffix(context);
        return CookieManager.getInstance();
    }
}

