/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import com.microsoft.identity.common.java.providers.oauth2.DefaultStateGenerator;
import com.microsoft.identity.common.logging.Logger;
import java.util.Locale;
import lombok.NonNull;

public class AndroidTaskStateGenerator
extends DefaultStateGenerator {
    private static final String SPLITTER = ":";
    private static final String TAG = "AndroidTaskStateGenerator";
    private int taskId;

    public AndroidTaskStateGenerator(int taskId) {
        this.taskId = taskId;
    }

    @NonNull
    public String generate() {
        String state = super.generate();
        state = String.format(Locale.US, "%d%s%s", this.taskId, SPLITTER, state);
        return state;
    }

    public static int getTaskFromState(String state) {
        String methodTag = "AndroidTaskStateGenerator:getTaskFromState";
        String[] parts = state.split(SPLITTER);
        int returnValue = 0;
        if (parts.length >= 2) {
            try {
                returnValue = Integer.parseInt(parts[0]);
            }
            catch (NumberFormatException ex) {
                Logger.error("AndroidTaskStateGenerator:getTaskFromState", "Unable to parse state", ex);
            }
        }
        return returnValue;
    }

    public int getTaskId() {
        return this.taskId;
    }
}

