/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.net.cache;

import android.content.Context;
import android.net.http.HttpResponseCache;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.java.cache.HttpCache;
import com.microsoft.identity.common.logging.Logger;
import java.io.File;
import java.io.IOException;

public class HttpCache {
    private static final String TAG = HttpCache.class.getSimpleName();
    public static final String DEFAULT_HTTP_CACHE_NAME = "com.microsoft.identity.http-cache";
    public static final long DEFAULT_HTTP_CACHE_CAPACITY_BYTES = 0xA00000L;

    public static synchronized boolean initialize(@NonNull File cacheDirectory, @NonNull String cacheFileName, long maxSizeBytes) {
        String methodTag = TAG + ":initialize";
        boolean success = false;
        if (HttpResponseCache.getInstalled() != null) {
            return true;
        }
        try {
            File httpCacheDir = new File(cacheDirectory, cacheFileName);
            HttpResponseCache.install((File)httpCacheDir, (long)maxSizeBytes);
            success = true;
        }
        catch (IOException e) {
            Logger.error(methodTag, "HTTP Response cache installation failed.", e);
        }
        com.microsoft.identity.common.java.cache.HttpCache.setHttpCache((HttpCache.IHttpCacheCallback)new HttpCache.IHttpCacheCallback(){

            public void flush() {
                HttpCache.flush();
            }
        });
        return success;
    }

    public static synchronized boolean initialize(@NonNull Context context) {
        String methodTag = TAG + ":initialize";
        File cacheDir = context.getCacheDir();
        if (cacheDir != null) {
            return HttpCache.initialize(cacheDir);
        }
        Logger.warn(methodTag, "Http caching is not enabled because the cache dir is null");
        return false;
    }

    public static synchronized boolean initialize(@NonNull File cacheDirectory) {
        return HttpCache.initialize(cacheDirectory, DEFAULT_HTTP_CACHE_NAME, 0xA00000L);
    }

    @Nullable
    public static HttpResponseCache getInstalled() {
        return HttpResponseCache.getInstalled();
    }

    public static void flush() {
        String methodTag = TAG + ":flush";
        HttpResponseCache responseCache = HttpCache.getInstalled();
        if (null != responseCache) {
            responseCache.flush();
        } else {
            Logger.warn(methodTag, "Unable to flush cache because none is installed.");
        }
    }
}

