/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import com.microsoft.identity.common.internal.ui.CurrentTaskBrowserAuthorizationStrategy;
import com.microsoft.identity.common.internal.ui.browser.DefaultBrowserAuthorizationStrategy;
import com.microsoft.identity.common.internal.ui.webview.EmbeddedWebViewAuthorizationStrategy;
import com.microsoft.identity.common.java.browser.Browser;
import com.microsoft.identity.common.java.browser.IBrowserSelector;
import com.microsoft.identity.common.java.configuration.LibraryConfiguration;
import com.microsoft.identity.common.java.providers.oauth2.IAuthorizationStrategy;
import com.microsoft.identity.common.java.strategies.IAuthorizationStrategyFactory;
import com.microsoft.identity.common.java.ui.AuthorizationAgent;
import com.microsoft.identity.common.java.ui.BrowserDescriptor;
import com.microsoft.identity.common.logging.Logger;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;

public class AndroidAuthorizationStrategyFactory
implements IAuthorizationStrategyFactory<IAuthorizationStrategy> {
    private static final String TAG = AndroidAuthorizationStrategyFactory.class.getSimpleName();
    private final Context mContext;
    private final Activity mActivity;
    private final Fragment mFragment;
    private final IBrowserSelector mBrowserSelector;

    @NonNull
    public IAuthorizationStrategy getAuthorizationStrategy(@NonNull AuthorizationAgent authorizationAgent, @NonNull List<BrowserDescriptor> browserSafeList, @Nullable BrowserDescriptor preferredBrowserDescriptor, boolean isBrokerRequest) {
        String methodTag = TAG + ":getAuthorizationStrategy";
        Browser browser = this.mBrowserSelector.selectBrowser(browserSafeList, preferredBrowserDescriptor);
        if (authorizationAgent == AuthorizationAgent.WEBVIEW || browser == null) {
            Logger.info(methodTag, "WebView authorization, browser: " + browser);
            return this.getGenericAuthorizationStrategy();
        }
        Logger.info(methodTag, "Browser authorization, browser: " + browser);
        return this.getBrowserAuthorizationStrategy(browser, isBrokerRequest);
    }

    private IAuthorizationStrategy getBrowserAuthorizationStrategy(@NonNull Browser browser, boolean isBrokerRequest) {
        if (LibraryConfiguration.getInstance().isAuthorizationInCurrentTask()) {
            return new CurrentTaskBrowserAuthorizationStrategy(this.mContext, this.mActivity, this.mFragment, browser);
        }
        return new DefaultBrowserAuthorizationStrategy(this.mContext, this.mActivity, this.mFragment, isBrokerRequest, browser);
    }

    private IAuthorizationStrategy getGenericAuthorizationStrategy() {
        return new EmbeddedWebViewAuthorizationStrategy(this.mContext, this.mActivity, this.mFragment);
    }

    AndroidAuthorizationStrategyFactory(Context context, Activity activity, Fragment fragment, IBrowserSelector browserSelector) {
        this.mContext = context;
        this.mActivity = activity;
        this.mFragment = fragment;
        this.mBrowserSelector = browserSelector;
    }

    public static AndroidAuthorizationStrategyFactoryBuilder builder() {
        return new AndroidAuthorizationStrategyFactoryBuilder();
    }

    public static class AndroidAuthorizationStrategyFactoryBuilder {
        private Context context;
        private Activity activity;
        private Fragment fragment;
        private IBrowserSelector browserSelector;

        AndroidAuthorizationStrategyFactoryBuilder() {
        }

        public AndroidAuthorizationStrategyFactoryBuilder context(Context context) {
            this.context = context;
            return this;
        }

        public AndroidAuthorizationStrategyFactoryBuilder activity(Activity activity) {
            this.activity = activity;
            return this;
        }

        public AndroidAuthorizationStrategyFactoryBuilder fragment(Fragment fragment) {
            this.fragment = fragment;
            return this;
        }

        public AndroidAuthorizationStrategyFactoryBuilder browserSelector(IBrowserSelector browserSelector) {
            this.browserSelector = browserSelector;
            return this;
        }

        public AndroidAuthorizationStrategyFactory build() {
            return new AndroidAuthorizationStrategyFactory(this.context, this.activity, this.fragment, this.browserSelector);
        }

        public String toString() {
            return "AndroidAuthorizationStrategyFactory.AndroidAuthorizationStrategyFactoryBuilder(context=" + this.context + ", activity=" + this.activity + ", fragment=" + this.fragment + ", browserSelector=" + this.browserSelector + ")";
        }
    }
}

