/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.net.Uri;
import android.webkit.PermissionRequest;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.core.content.ContextCompat;
import com.microsoft.identity.common.R;
import com.microsoft.identity.common.internal.broker.SdmQrPinManager;
import com.microsoft.identity.common.internal.providers.oauth2.WebViewAuthorizationFragment;
import com.microsoft.identity.common.java.ui.PreferredAuthMethod;
import com.microsoft.identity.common.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\u0016\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\tH\u0002J\b\u0010\u0016\u001a\u00020\u000bH\u0002J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\tH\u0002J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u001b\u001a\u00020\u0010H\u0002J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/microsoft/identity/common/internal/providers/oauth2/CameraPermissionRequestHandler;", "", "fragment", "Lcom/microsoft/identity/common/internal/providers/oauth2/WebViewAuthorizationFragment;", "(Lcom/microsoft/identity/common/internal/providers/oauth2/WebViewAuthorizationFragment;)V", "activityResultLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "", "currentPermissionRequest", "Landroid/webkit/PermissionRequest;", "isGranted", "", "appHasCameraPermission", "context", "Landroid/content/Context;", "defaultHandler", "", "deny", "grant", "handle", "request", "isForCamera", "isQrPinRequest", "isRepeatedRequest", "permissionRequest", "isValid", "qrPinHandler", "requestCameraPermission", "showQrPinCameraRationale", "Companion", "common_distRelease"})
public final class CameraPermissionRequestHandler {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ActivityResultLauncher<String> activityResultLauncher;
    @Nullable
    private PermissionRequest currentPermissionRequest;
    private boolean isGranted;
    @Deprecated
    @NotNull
    private static final String TAG = "CameraPermissionRequestHandler";
    @Deprecated
    @NotNull
    private static final String MICROSOFT_CLOUD_URL = "https://login.microsoftonline.com/";
    @Deprecated
    @NotNull
    private static final String[] cameraResource;

    public CameraPermissionRequestHandler(@NotNull WebViewAuthorizationFragment fragment) {
        Intrinsics.checkNotNullParameter((Object)((Object)fragment), (String)"fragment");
        ActivityResultLauncher activityResultLauncher = fragment.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestPermission(), arg_0 -> CameraPermissionRequestHandler.activityResultLauncher$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"fragment.registerForActi\u2026)\n            }\n        }");
        this.activityResultLauncher = activityResultLauncher;
    }

    public final void handle(@NotNull PermissionRequest request, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String methodTag = "CameraPermissionRequestHandler:handle";
        if (!this.isValid(request)) {
            Logger.warn(methodTag, "Permission request is not valid, returning.");
            return;
        }
        this.currentPermissionRequest = request;
        this.isGranted = false;
        if (this.isQrPinRequest()) {
            this.qrPinHandler(context);
        } else {
            this.defaultHandler(context);
        }
    }

    private final void grant() {
        block0: {
            PermissionRequest permissionRequest = this.currentPermissionRequest;
            if (permissionRequest == null) break block0;
            PermissionRequest it = permissionRequest;
            boolean bl = false;
            it.grant(cameraResource);
            this.isGranted = true;
        }
    }

    private final void deny() {
        block0: {
            PermissionRequest permissionRequest = this.currentPermissionRequest;
            if (permissionRequest == null) break block0;
            PermissionRequest it = permissionRequest;
            boolean bl = false;
            it.deny();
            this.isGranted = false;
        }
    }

    private final boolean isValid(PermissionRequest request) {
        String methodTag = "CameraPermissionRequestHandler:isValid";
        if (!this.isForCamera(request)) {
            Logger.warn(methodTag, "Permission request is not for camera.");
            request.deny();
            return false;
        }
        if (this.isRepeatedRequest(request)) {
            Logger.info(methodTag, "Repeated request, permission is granted: " + this.isGranted);
            if (this.isGranted) {
                request.grant(cameraResource);
            } else {
                request.deny();
            }
            return false;
        }
        Logger.info(methodTag, "Valid new request.");
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isQrPinRequest() {
        PermissionRequest permissionRequest = this.currentPermissionRequest;
        if (permissionRequest == null) return false;
        Uri uri = permissionRequest.getOrigin();
        if (uri == null) return false;
        PermissionRequest permissionRequest2 = this.currentPermissionRequest;
        if (!StringsKt.equals((String)MICROSOFT_CLOUD_URL, (String)String.valueOf(permissionRequest2 != null ? permissionRequest2.getOrigin() : null), (boolean)true)) return false;
        if (!StringsKt.equals$default((String)PreferredAuthMethod.QR.value, (String)SdmQrPinManager.INSTANCE.getPreferredAuthConfig(), (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final void defaultHandler(Context context) {
        String methodTag = "CameraPermissionRequestHandler:defaultHandler";
        if (this.appHasCameraPermission(context)) {
            Logger.info(methodTag, "App level camera permission already granted, silent grant.");
            this.grant();
        } else {
            this.requestCameraPermission();
        }
    }

    private final void qrPinHandler(Context context) {
        String methodTag = "CameraPermissionRequestHandler:handleQrPin";
        if (this.appHasCameraPermission(context)) {
            Logger.info(methodTag, "App level camera permission already granted.");
            if (SdmQrPinManager.INSTANCE.isCameraConsentSuppressed()) {
                Logger.info(methodTag, "Camera consent suppress is enabled.");
                this.grant();
            } else {
                Logger.info(methodTag, "Camera consent suppress is not enabled.");
                this.showQrPinCameraRationale(context);
            }
        } else {
            this.requestCameraPermission();
        }
    }

    private final boolean appHasCameraPermission(Context context) {
        return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.CAMERA") == 0;
    }

    private final void showQrPinCameraRationale(Context context) {
        String methodTag = "CameraPermissionRequestHandler:showQrPinCameraRationale";
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setMessage(R.string.qr_code_rationale_message).setTitle(R.string.qr_code_rationale_header).setCancelable(false).setPositiveButton(R.string.qr_code_rationale_allow, (arg_0, arg_1) -> CameraPermissionRequestHandler.showQrPinCameraRationale$lambda$3(methodTag, this, arg_0, arg_1)).setNegativeButton(R.string.qr_code_rationale_block, (arg_0, arg_1) -> CameraPermissionRequestHandler.showQrPinCameraRationale$lambda$4(methodTag, this, arg_0, arg_1));
        builder.show();
    }

    private final boolean isRepeatedRequest(PermissionRequest permissionRequest) {
        PermissionRequest it = this.currentPermissionRequest;
        boolean bl = false;
        if (it == null) {
            return false;
        }
        if (it.getResources().length != permissionRequest.getResources().length) {
            return false;
        }
        return Intrinsics.areEqual((Object)it.getOrigin(), (Object)permissionRequest.getOrigin());
    }

    private final boolean isForCamera(PermissionRequest request) {
        return request.getResources().length == 1 && Intrinsics.areEqual((Object)"android.webkit.resource.VIDEO_CAPTURE", (Object)request.getResources()[0]);
    }

    private final void requestCameraPermission() {
        this.activityResultLauncher.launch((Object)"android.permission.CAMERA");
    }

    private static final void activityResultLauncher$lambda$0(CameraPermissionRequestHandler this$0, boolean permissionGranted) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Logger.info(TAG, "Camera permission granted: " + permissionGranted);
        if (permissionGranted) {
            this$0.grant();
        } else {
            this$0.deny();
        }
    }

    private static final void showQrPinCameraRationale$lambda$3(String $methodTag, CameraPermissionRequestHandler this$0, DialogInterface dialogInterface, int n) {
        Intrinsics.checkNotNullParameter((Object)$methodTag, (String)"$methodTag");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Logger.info($methodTag, "User accepted camera permission rationale.");
        this$0.requestCameraPermission();
    }

    private static final void showQrPinCameraRationale$lambda$4(String $methodTag, CameraPermissionRequestHandler this$0, DialogInterface dialogInterface, int n) {
        Intrinsics.checkNotNullParameter((Object)$methodTag, (String)"$methodTag");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Logger.info($methodTag, "User denied camera permission rationale.");
        this$0.deny();
    }

    static {
        String[] stringArray = new String[]{"android.webkit.resource.VIDEO_CAPTURE"};
        cameraResource = stringArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/microsoft/identity/common/internal/providers/oauth2/CameraPermissionRequestHandler$Companion;", "", "()V", "MICROSOFT_CLOUD_URL", "", "TAG", "cameraResource", "", "[Ljava/lang/String;", "common_distRelease"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

