/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationActivityFactory;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.java.providers.oauth2.IAuthorizationStrategy;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2Strategy;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.ref.WeakReference;
import lombok.NonNull;

public abstract class AndroidAuthorizationStrategy<GenericOAuth2Strategy extends OAuth2Strategy, GenericAuthorizationRequest extends AuthorizationRequest>
implements IAuthorizationStrategy<GenericOAuth2Strategy, GenericAuthorizationRequest> {
    private final WeakReference<Context> mReferencedApplicationContext;
    private final WeakReference<Activity> mReferencedActivity;
    private final WeakReference<Fragment> mReferencedFragment;

    public AndroidAuthorizationStrategy(@NonNull Context applicationContext, @NonNull Activity activity, @Nullable Fragment fragment) {
        if (applicationContext == null) {
            throw new NullPointerException("applicationContext is marked non-null but is null");
        }
        if (activity == null) {
            throw new NullPointerException("activity is marked non-null but is null");
        }
        this.mReferencedApplicationContext = new WeakReference<Context>(applicationContext);
        this.mReferencedActivity = new WeakReference<Activity>(activity);
        this.mReferencedFragment = new WeakReference<Fragment>(fragment);
    }

    protected Context getApplicationContext() {
        return (Context)this.mReferencedApplicationContext.get();
    }

    protected void launchIntent(@NonNull Intent intent) throws ClientException {
        if (intent == null) {
            throw new NullPointerException("intent is marked non-null but is null");
        }
        Fragment fragment = (Fragment)this.mReferencedFragment.get();
        if (fragment != null) {
            Fragment authFragment = AuthorizationActivityFactory.getAuthorizationFragmentFromStartIntentWithState(intent, intent.getExtras());
            FragmentManager fragmentManager = fragment.getFragmentManager();
            if (fragmentManager == null) {
                throw new ClientException("null_object", "Fragment Manager is null");
            }
            fragmentManager.beginTransaction().setTransitionStyle(4099).add(fragment.getId(), authFragment, Fragment.class.getName()).commit();
            return;
        }
        Activity activity = (Activity)this.mReferencedActivity.get();
        if (activity == null) {
            throw new ClientException("null_object", "Referenced activity is null");
        }
        activity.startActivity(intent);
    }
}

