/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import com.google.gson.Gson;
import com.microsoft.identity.common.java.cache.IListTypeToken;
import com.microsoft.identity.common.java.cache.ISimpleCache;
import com.microsoft.identity.common.logging.Logger;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;

public abstract class SharedPreferencesSimpleCacheImpl<T>
implements ISimpleCache<T>,
IListTypeToken {
    private static final String TAG = SharedPreferencesSimpleCacheImpl.class.getSimpleName();
    private static final String EMPTY_ARRAY = "[]";
    private final SharedPreferences mSharedPrefs;
    private final String mKeySingleEntry;
    private final Gson mGson = new Gson();

    public SharedPreferencesSimpleCacheImpl(@NonNull Context context, @NonNull String prefsName, @NonNull String singleKey) {
        Logger.verbose(TAG + "::constructor", "Init");
        this.mSharedPrefs = context.getSharedPreferences(prefsName, 0);
        this.mKeySingleEntry = singleKey;
    }

    public boolean insert(T t) {
        String methodTag = TAG + ":insert";
        HashSet<T> allMetadata = new HashSet<T>(this.getAll());
        Logger.verbose(methodTag, "Existing metadata contained [" + allMetadata.size() + "] elements.");
        allMetadata.add(t);
        Logger.verbose(methodTag, "New metadata set size: [" + allMetadata.size() + "]");
        String json = this.mGson.toJson(allMetadata);
        Logger.verbose(methodTag, "Writing cache entry.");
        boolean success = this.mSharedPrefs.edit().putString(this.mKeySingleEntry, json).commit();
        if (success) {
            Logger.verbose(methodTag, "Cache successfully updated.");
        } else {
            Logger.warn(methodTag, "Error writing to cache.");
        }
        return success;
    }

    public boolean remove(T t) {
        String methodTag = TAG + ":remove";
        HashSet<T> allMetadata = new HashSet<T>(this.getAll());
        Logger.verbose(methodTag, "Existing metadata contained [" + allMetadata.size() + "] elements.");
        boolean removed = allMetadata.remove(t);
        Logger.verbose(methodTag, "New metadata set size: [" + allMetadata.size() + "]");
        if (!removed) {
            Logger.warn(methodTag, "Nothing to delete -- cache entry is missing!");
            return true;
        }
        String json = this.mGson.toJson(allMetadata);
        Logger.verbose(methodTag, "Writing new cache values...");
        boolean written = this.mSharedPrefs.edit().putString(this.mKeySingleEntry, json).commit();
        Logger.verbose(methodTag, "Updated cache contents written? [" + written + "]");
        return written;
    }

    public List<T> getAll() {
        String methodTag = TAG + ":getAll";
        String jsonList = this.mSharedPrefs.getString(this.mKeySingleEntry, EMPTY_ARRAY);
        Type listType = this.getListTypeToken();
        List result = (List)this.mGson.fromJson(jsonList, listType);
        Logger.verbose(methodTag, "Found [" + result.size() + "] cache entries.");
        return result;
    }

    public boolean clear() {
        String methodTag = TAG + ":clear";
        boolean cleared = this.mSharedPrefs.edit().clear().commit();
        if (!cleared) {
            Logger.warn(methodTag, "Failed to clear cache.");
        } else {
            Logger.verbose(methodTag, "Cache successfully cleared.");
        }
        return cleared;
    }
}

