/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.crypto;

import android.content.Context;
import android.security.KeyPairGeneratorSpec;
import com.microsoft.identity.common.crypto.IKeyGenSpec;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0019\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u00c6\u0003JK\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\b\u0010$\u001a\u00020\u0010H\u0002J\t\u0010%\u001a\u00020\u0007H\u00d6\u0001J\b\u0010&\u001a\u00020\u0005H\u0016R\u0014\u0010\t\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006'"}, d2={"Lcom/microsoft/identity/common/crypto/LegacyKeyGenSpec;", "Lcom/microsoft/identity/common/crypto/IKeyGenSpec;", "context", "Landroid/content/Context;", "keyAlias", "", "keySize", "", "description", "algorithm", "encryptionPaddings", "", "(Landroid/content/Context;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getAlgorithm", "()Ljava/lang/String;", "algorithmParameterSpec", "Ljava/security/spec/AlgorithmParameterSpec;", "getAlgorithmParameterSpec", "()Ljava/security/spec/AlgorithmParameterSpec;", "getDescription", "getEncryptionPaddings", "()Ljava/util/List;", "getKeyAlias", "getKeySize", "()I", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "getLegacyKeyGenParamSpec", "hashCode", "toString", "common_distRelease"})
public final class LegacyKeyGenSpec
implements IKeyGenSpec {
    @NotNull
    private final Context context;
    @NotNull
    private final String keyAlias;
    private final int keySize;
    @NotNull
    private final String description;
    @NotNull
    private final String algorithm;
    @NotNull
    private final List<String> encryptionPaddings;
    @NotNull
    private final AlgorithmParameterSpec algorithmParameterSpec;

    public LegacyKeyGenSpec(@NotNull Context context, @NotNull String keyAlias, int keySize, @NotNull String description, @NotNull String algorithm, @NotNull List<String> encryptionPaddings) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter(encryptionPaddings, (String)"encryptionPaddings");
        this.context = context;
        this.keyAlias = keyAlias;
        this.keySize = keySize;
        this.description = description;
        this.algorithm = algorithm;
        this.encryptionPaddings = encryptionPaddings;
        this.algorithmParameterSpec = this.getLegacyKeyGenParamSpec();
    }

    @Override
    @NotNull
    public String getKeyAlias() {
        return this.keyAlias;
    }

    @Override
    public int getKeySize() {
        return this.keySize;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    @NotNull
    public List<String> getEncryptionPaddings() {
        return this.encryptionPaddings;
    }

    @Override
    @NotNull
    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return this.algorithmParameterSpec;
    }

    @NotNull
    public String toString() {
        return this.print();
    }

    private final AlgorithmParameterSpec getLegacyKeyGenParamSpec() {
        Locale locale = Locale.ROOT;
        String string = "CN=%s, OU=%s";
        Object[] objectArray = new Object[]{this.getKeyAlias(), this.context.getPackageName()};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
        String certInfo = string2;
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        int certValidYears = 100;
        end.add(1, certValidYears);
        KeyPairGeneratorSpec keyPairGeneratorSpec = new KeyPairGeneratorSpec.Builder(this.context).setAlias(this.getKeyAlias()).setSubject(new X500Principal(certInfo)).setSerialNumber(BigInteger.ONE).setStartDate(start.getTime()).setEndDate(end.getTime()).build();
        Intrinsics.checkNotNullExpressionValue((Object)keyPairGeneratorSpec, (String)"Builder(context)\n       \u2026ime)\n            .build()");
        return (AlgorithmParameterSpec)keyPairGeneratorSpec;
    }

    @Override
    @NotNull
    public String print() {
        return IKeyGenSpec.DefaultImpls.print(this);
    }

    private final Context component1() {
        return this.context;
    }

    @NotNull
    public final String component2() {
        return this.getKeyAlias();
    }

    public final int component3() {
        return this.getKeySize();
    }

    @NotNull
    public final String component4() {
        return this.getDescription();
    }

    @NotNull
    public final String component5() {
        return this.getAlgorithm();
    }

    @NotNull
    public final List<String> component6() {
        return this.getEncryptionPaddings();
    }

    @NotNull
    public final LegacyKeyGenSpec copy(@NotNull Context context, @NotNull String keyAlias, int keySize, @NotNull String description, @NotNull String algorithm, @NotNull List<String> encryptionPaddings) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter(encryptionPaddings, (String)"encryptionPaddings");
        return new LegacyKeyGenSpec(context, keyAlias, keySize, description, algorithm, encryptionPaddings);
    }

    public static /* synthetic */ LegacyKeyGenSpec copy$default(LegacyKeyGenSpec legacyKeyGenSpec, Context context, String string, int n, String string2, String string3, List list, int n2, Object object) {
        if ((n2 & 1) != 0) {
            context = legacyKeyGenSpec.context;
        }
        if ((n2 & 2) != 0) {
            string = legacyKeyGenSpec.getKeyAlias();
        }
        if ((n2 & 4) != 0) {
            n = legacyKeyGenSpec.getKeySize();
        }
        if ((n2 & 8) != 0) {
            string2 = legacyKeyGenSpec.getDescription();
        }
        if ((n2 & 0x10) != 0) {
            string3 = legacyKeyGenSpec.getAlgorithm();
        }
        if ((n2 & 0x20) != 0) {
            list = legacyKeyGenSpec.getEncryptionPaddings();
        }
        return legacyKeyGenSpec.copy(context, string, n, string2, string3, list);
    }

    public int hashCode() {
        int result = this.context.hashCode();
        result = result * 31 + this.getKeyAlias().hashCode();
        result = result * 31 + Integer.hashCode(this.getKeySize());
        result = result * 31 + this.getDescription().hashCode();
        result = result * 31 + this.getAlgorithm().hashCode();
        result = result * 31 + ((Object)this.getEncryptionPaddings()).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LegacyKeyGenSpec)) {
            return false;
        }
        LegacyKeyGenSpec legacyKeyGenSpec = (LegacyKeyGenSpec)other;
        if (!Intrinsics.areEqual((Object)this.context, (Object)legacyKeyGenSpec.context)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getKeyAlias(), (Object)legacyKeyGenSpec.getKeyAlias())) {
            return false;
        }
        if (this.getKeySize() != legacyKeyGenSpec.getKeySize()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getDescription(), (Object)legacyKeyGenSpec.getDescription())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getAlgorithm(), (Object)legacyKeyGenSpec.getAlgorithm())) {
            return false;
        }
        return Intrinsics.areEqual(this.getEncryptionPaddings(), legacyKeyGenSpec.getEncryptionPaddings());
    }
}

