/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.certbasedauth;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import androidx.appcompat.app.AlertDialog;
import com.microsoft.identity.common.R;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.ICancelCbaCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardDialog;
import lombok.NonNull;

public class SmartcardPromptDialog
extends SmartcardDialog {
    private final ICancelCbaCallback mCancelCbaCallback;

    public SmartcardPromptDialog(@NonNull ICancelCbaCallback cancelCbaCallback, @NonNull Activity activity) {
        super(activity);
        if (cancelCbaCallback == null) {
            throw new NullPointerException("cancelCbaCallback is marked non-null but is null");
        }
        if (activity == null) {
            throw new NullPointerException("activity is marked non-null but is null");
        }
        this.mCancelCbaCallback = cancelCbaCallback;
        this.createDialog();
    }

    @Override
    void createDialog() {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)SmartcardPromptDialog.this.mActivity, R.style.UserChoiceAlertDialogTheme).setTitle(R.string.smartcard_prompt_dialog_title).setMessage(R.string.smartcard_prompt_dialog_message).setNegativeButton(R.string.smartcard_prompt_dialog_negative_button, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                        SmartcardPromptDialog.this.mCancelCbaCallback.onCancel();
                    }
                });
                AlertDialog dialog = builder.create();
                dialog.setCanceledOnTouchOutside(false);
                dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        SmartcardPromptDialog.this.mCancelCbaCallback.onCancel();
                    }
                });
                SmartcardPromptDialog.this.mDialog = dialog;
            }
        });
    }

    @Override
    void onUnexpectedUnplug() {
        this.mCancelCbaCallback.onCancel();
    }
}

