/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.certbasedauth;

import android.app.Activity;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.R;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.ICancelCbaCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.ICertDetails;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.IDialogHolder;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.IDismissCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardCertPickerDialog;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardDialog;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardErrorDialog;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardNfcLoadingDialog;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardNfcPromptDialog;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardNfcReminderDialog;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardPinDialog;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardPromptDialog;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardRemovalPromptDialog;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.UserChoiceDialog;
import com.microsoft.identity.common.logging.Logger;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class DialogHolder
implements IDialogHolder {
    private final String TAG = DialogHolder.class.getSimpleName();
    private final Activity mActivity;
    private SmartcardDialog mCurrentDialog;

    public DialogHolder(@NonNull Activity activity) {
        this.mActivity = activity;
        this.mCurrentDialog = null;
    }

    @Override
    public synchronized void showCertPickerDialog(@NonNull List<ICertDetails> certList, @NonNull SmartcardCertPickerDialog.PositiveButtonListener positiveButtonListener, @NonNull ICancelCbaCallback cancelCbaCallback) {
        try {
            SmartcardCertPickerDialog certPickerDialog = new SmartcardCertPickerDialog(certList, positiveButtonListener, cancelCbaCallback, this.mActivity);
            this.showDialog(certPickerDialog);
        }
        catch (WindowManager.BadTokenException e) {
            Logger.error(this.TAG + ":showCertPickerDialog", "Failed to show CertPickerDialog due to BadTokenException. Activity may be finishing or destroyed.", e);
            cancelCbaCallback.onCancel();
        }
    }

    @Override
    public synchronized void showPinDialog(@NonNull SmartcardPinDialog.PositiveButtonListener positiveButtonListener, @NonNull ICancelCbaCallback cancelCbaCallback) {
        try {
            SmartcardPinDialog pinDialog = new SmartcardPinDialog(positiveButtonListener, cancelCbaCallback, this.mActivity);
            this.showDialog(pinDialog);
        }
        catch (WindowManager.BadTokenException e) {
            Logger.error(this.TAG + ":showPinDialog", "Failed to show PinDialog due to BadTokenException. Activity may be finishing or destroyed.", e);
            cancelCbaCallback.onCancel();
        }
    }

    @Override
    public synchronized void showErrorDialog(int titleStringResourceId, int messageStringResourceId) {
        try {
            this.showDialog(new SmartcardErrorDialog(titleStringResourceId, messageStringResourceId, R.string.smartcard_error_dialog_positive_button, new IDismissCallback(){

                @Override
                public void onDismiss() {
                    DialogHolder.this.dismissDialog();
                }
            }, this.mActivity));
        }
        catch (WindowManager.BadTokenException e) {
            Logger.error(this.TAG + ":showErrorDialog", "Failed to show ErrorDialog due to BadTokenException. Activity may be finishing or destroyed.", e);
        }
    }

    @Override
    public synchronized void showErrorDialog(int titleStringResourceId, int messageStringResourceId, int dismissButtonStringResourceId) {
        try {
            this.showDialog(new SmartcardErrorDialog(titleStringResourceId, messageStringResourceId, dismissButtonStringResourceId, new IDismissCallback(){

                @Override
                public void onDismiss() {
                    DialogHolder.this.dismissDialog();
                }
            }, this.mActivity));
        }
        catch (WindowManager.BadTokenException e) {
            Logger.error(this.TAG + ":showErrorDialog", "Failed to show ErrorDialog due to BadTokenException. Activity may be finishing or destroyed.", e);
        }
    }

    @Override
    public synchronized void showUserChoiceDialog(@NonNull UserChoiceDialog.PositiveButtonListener positiveButtonListener, @NonNull ICancelCbaCallback cancelCbaCallback) {
        try {
            this.showDialog(new UserChoiceDialog(positiveButtonListener, cancelCbaCallback, this.mActivity));
        }
        catch (WindowManager.BadTokenException e) {
            Logger.error(this.TAG + ":showUserChoiceDialog", "Failed to show UserChoiceDialog due to BadTokenException. Activity may be finishing or destroyed.", e);
            cancelCbaCallback.onCancel();
        }
    }

    @Override
    public synchronized void showSmartcardPromptDialog(@NonNull ICancelCbaCallback cancelCbaCallback) {
        try {
            this.showDialog(new SmartcardPromptDialog(cancelCbaCallback, this.mActivity));
        }
        catch (WindowManager.BadTokenException e) {
            Logger.error(this.TAG + ":showSmartcardPromptDialog", "Failed to show SmartcardPromptDialog due to BadTokenException. Activity may be finishing or destroyed.", e);
            cancelCbaCallback.onCancel();
        }
    }

    @Override
    public synchronized void showSmartcardNfcLoadingDialog() {
        try {
            this.showDialog(new SmartcardNfcLoadingDialog(this.mActivity));
        }
        catch (WindowManager.BadTokenException e) {
            Logger.error(this.TAG + ":showSmartcardNfcLoadingDialog", "Failed to show SmartcardNfcLoadingDialog due to BadTokenException. Activity may be finishing or destroyed.", e);
        }
    }

    @Override
    public synchronized void showSmartcardNfcPromptDialog(@NonNull ICancelCbaCallback cancelCbaCallback) {
        try {
            this.showDialog(new SmartcardNfcPromptDialog(cancelCbaCallback, this.mActivity));
        }
        catch (WindowManager.BadTokenException e) {
            Logger.error(this.TAG + ":showSmartcardNfcPromptDialog", "Failed to show SmartcardNfcPromptDialog due to BadTokenException. Activity may be finishing or destroyed.", e);
            cancelCbaCallback.onCancel();
        }
    }

    @Override
    public synchronized void showSmartcardNfcReminderDialog(@NonNull IDismissCallback dismissCallback) {
        try {
            this.showDialog(new SmartcardNfcReminderDialog(dismissCallback, this.mActivity));
        }
        catch (WindowManager.BadTokenException e) {
            Logger.error(this.TAG + ":showSmartcardNfcReminderDialog", "Failed to show SmartcardNfcReminderDialog due to BadTokenException. Activity may be finishing or destroyed.", e);
            dismissCallback.onDismiss();
        }
    }

    @Override
    public synchronized void showSmartcardRemovalPromptDialog(final @Nullable IDismissCallback dismissCallback) {
        block2: {
            try {
                this.showDialog(new SmartcardRemovalPromptDialog(new IDismissCallback(){

                    @Override
                    public void onDismiss() {
                        DialogHolder.this.dismissDialog();
                        if (dismissCallback != null) {
                            dismissCallback.onDismiss();
                        }
                    }
                }, this.mActivity));
            }
            catch (WindowManager.BadTokenException e) {
                Logger.error(this.TAG + ":showSmartcardRemovalPromptDialog", "Failed to show SmartcardRemovalPromptDialog due to BadTokenException. Activity may be finishing or destroyed.", e);
                if (dismissCallback == null) break block2;
                dismissCallback.onDismiss();
            }
        }
    }

    @Override
    public synchronized void dismissDialog() {
        this.showDialog(null);
    }

    @Override
    public synchronized void showDialog(@Nullable SmartcardDialog dialog) {
        if (this.mCurrentDialog != null) {
            this.mCurrentDialog.dismiss();
        }
        this.mCurrentDialog = dialog;
        if (this.mCurrentDialog != null) {
            this.mCurrentDialog.show();
        }
    }

    @Override
    public synchronized boolean isDialogShowing() {
        return this.mCurrentDialog != null;
    }

    @Override
    public synchronized boolean isSmartcardRemovalPromptDialogShowing() {
        return this.mCurrentDialog instanceof SmartcardRemovalPromptDialog;
    }

    @Override
    public synchronized void onUnexpectedUnplug() {
        if (this.mCurrentDialog != null) {
            this.mCurrentDialog.onUnexpectedUnplug();
        }
    }

    @Override
    public synchronized void setPinDialogErrorMode() {
        if (this.mCurrentDialog instanceof SmartcardPinDialog) {
            ((SmartcardPinDialog)this.mCurrentDialog).setErrorMode();
        }
    }
}

