/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview;

import android.app.Activity;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.webkit.HttpAuthHandler;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.microsoft.identity.common.internal.broker.AuthUxJavaScriptInterface;
import com.microsoft.identity.common.internal.ui.webview.ExpectedPage;
import com.microsoft.identity.common.internal.ui.webview.OnPageLoadedCallback;
import com.microsoft.identity.common.internal.ui.webview.ProcessUtil;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.ChallengeFactory;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.NtlmChallenge;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.NtlmChallengeHandler;
import com.microsoft.identity.common.internal.util.StringUtil;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.flighting.CommonFlight;
import com.microsoft.identity.common.java.flighting.CommonFlightsManager;
import com.microsoft.identity.common.java.flighting.IFlightConfig;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.OTelUtility;
import com.microsoft.identity.common.java.providers.RawAuthorizationResult;
import com.microsoft.identity.common.java.ui.webview.authorization.IAuthorizationCompletionCallback;
import com.microsoft.identity.common.logging.Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongCounter;

public abstract class OAuth2WebViewClient
extends WebViewClient {
    private static final String TAG = OAuth2WebViewClient.class.getSimpleName();
    private static final LongCounter sWebViewSslErrorCount = OTelUtility.createLongCounter((String)"web_view_ssl_error_count", (String)"Number of SSL errors received in onReceivedSslError");
    private final IAuthorizationCompletionCallback mCompletionCallback;
    private final OnPageLoadedCallback mPageLoadedCallback;
    private final Activity mActivity;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="This is only exposed in testing")
    @VisibleForTesting
    public static ExpectedPage mExpectedPage = null;
    protected boolean mAuthUxJavaScriptInterfaceAdded = false;

    public Activity getActivity() {
        return this.mActivity;
    }

    IAuthorizationCompletionCallback getCompletionCallback() {
        return this.mCompletionCallback;
    }

    OAuth2WebViewClient(@NonNull Activity activity, @NonNull IAuthorizationCompletionCallback completionCallback, @NonNull OnPageLoadedCallback pageLoadedCallback) {
        this.mActivity = activity;
        this.mCompletionCallback = completionCallback;
        this.mPageLoadedCallback = pageLoadedCallback;
    }

    public void onReceivedHttpAuthRequest(WebView view, HttpAuthHandler handler, String host, String realm) {
        String methodTag = TAG + ":onReceivedHttpAuthRequest";
        Logger.info(methodTag, "Receive the http auth request. Start the dialog to ask for creds. ");
        Logger.infoPII(methodTag, "Host:" + host);
        NtlmChallenge ntlmChallenge = ChallengeFactory.getNtlmChallenge(view, handler, host, realm);
        NtlmChallengeHandler challengeHandler = new NtlmChallengeHandler(this.mActivity, this.mCompletionCallback);
        challengeHandler.processChallenge(ntlmChallenge);
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        this.sendErrorToCallback(view, errorCode, description);
    }

    @RequiresApi(api=23)
    public void onReceivedError(@NonNull WebView view, @NonNull WebResourceRequest request, @NonNull WebResourceError error) {
        String methodTag = TAG + ":onReceivedError";
        boolean isForMainFrame = request.isForMainFrame();
        Logger.warn(methodTag, "WebResourceError - isForMainFrame? " + isForMainFrame);
        Logger.warnPII(methodTag, "Failing url: " + request.getUrl());
        if (request.isForMainFrame()) {
            this.sendErrorToCallback(view, error.getErrorCode(), error.getDescription().toString());
        }
    }

    private void sendErrorToCallback(@NonNull WebView view, int errorCode, @NonNull String description) {
        view.stopLoading();
        this.mCompletionCallback.onChallengeResponseReceived(RawAuthorizationResult.fromException((BaseException)((Object)new ClientException("Code:" + errorCode, description))));
    }

    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        String methodTag = TAG + ":onReceivedSslError";
        super.onReceivedSslError(view, handler, error);
        String errMsg = "Received SSL Error during request. For more info see: https://go.microsoft.com/fwlink/?linkid=2138180. Error: " + error.toString();
        Logger.warn(methodTag, errMsg);
        Attributes attributes = Attributes.builder().put(AttributeName.web_view_ssl_primary_error_code.name(), (long)error.getPrimaryError()).build();
        sWebViewSslErrorCount.add(1L, attributes);
        if (!CommonFlightsManager.INSTANCE.getFlightsProvider().isFlightEnabled((IFlightConfig)CommonFlight.SHOULD_PRESERVE_WEBVIEW_FLOW_ON_SSL_ERROR)) {
            this.mCompletionCallback.onChallengeResponseReceived(RawAuthorizationResult.fromException((BaseException)((Object)new ClientException("Code:-11", error.toString()))));
        }
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        this.mPageLoadedCallback.onPageLoaded(url);
        if (mExpectedPage != null && url.startsWith(OAuth2WebViewClient.mExpectedPage.mExpectedPageUrlStartsWith)) {
            OAuth2WebViewClient.mExpectedPage.mCallback.onPageLoaded(url);
        }
        view.setVisibility(0);
    }

    @RequiresApi(api=26)
    public boolean onRenderProcessGone(WebView view, RenderProcessGoneDetail detail) {
        this.sendErrorToCallback(view, -1, "WebView render process gone, crashed? : " + detail.didCrash());
        return true;
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        String methodTag = TAG + ":onPageStarted";
        this.checkStartUrl(url);
        if (this.shouldExposeJavaScriptInterface(url)) {
            Logger.info(methodTag, "Adding AuthUx JavaScript Interface");
            view.addJavascriptInterface((Object)new AuthUxJavaScriptInterface(), AuthUxJavaScriptInterface.Companion.getInterfaceName());
            this.mAuthUxJavaScriptInterfaceAdded = true;
        } else if (this.mAuthUxJavaScriptInterfaceAdded) {
            Logger.info(methodTag, "Removing AuthUx JavaScript Interface");
            view.removeJavascriptInterface(AuthUxJavaScriptInterface.Companion.getInterfaceName());
            this.mAuthUxJavaScriptInterfaceAdded = false;
        }
        Logger.info(methodTag, "WebView starts loading.");
        super.onPageStarted(view, url, favicon);
    }

    private void checkStartUrl(String url) {
        String methodTag = TAG + ":checkStartUrl";
        if (StringUtil.isEmpty(url)) {
            Logger.info(methodTag, "onPageStarted: Null url for page to load.");
            return;
        }
        Uri uri = Uri.parse((String)url);
        if (uri.isOpaque()) {
            Logger.info(methodTag, "onPageStarted: Non-hierarchical loading uri.");
            Logger.infoPII(methodTag, "start url: " + url);
        } else if (StringUtil.isEmpty(uri.getQueryParameter("code"))) {
            Logger.info(methodTag, "onPageStarted: URI has no auth code ('code') query parameter.");
            Logger.infoPII(methodTag, "Scheme:" + uri.getScheme() + " Host: " + uri.getHost() + " Path: " + uri.getPath());
        } else {
            Logger.info(methodTag, "Auth code is returned for the loading url.");
            Logger.infoPII(methodTag, "Scheme:" + uri.getScheme() + " Host: " + uri.getHost() + " Path: " + uri.getPath());
        }
    }

    protected boolean shouldExposeJavaScriptInterface(String url) {
        return ProcessUtil.isRunningOnAuthService(this.getActivity().getApplicationContext()) && AuthUxJavaScriptInterface.Companion.isValidUriForInterface(url) && CommonFlightsManager.INSTANCE.getFlightsProvider().isFlightEnabled((IFlightConfig)CommonFlight.ENABLE_JS_API_FOR_AUTHUX);
    }
}

