/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview;

import android.net.Uri;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/microsoft/identity/common/internal/ui/webview/JsScriptRecord;", "", "id", "", "script", "allowedUrls", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;)V", "getId", "()Ljava/lang/String;", "getScript", "isAllowedForUrl", "", "url", "Companion", "common_distRelease"})
@SourceDebugExtension(value={"SMAP\nJsScriptRecord.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsScriptRecord.kt\ncom/microsoft/identity/common/internal/ui/webview/JsScriptRecord\n+ 2 Uri.kt\nandroidx/core/net/UriKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n29#2:90\n29#2:93\n1747#3,2:91\n1749#3:94\n*S KotlinDebug\n*F\n+ 1 JsScriptRecord.kt\ncom/microsoft/identity/common/internal/ui/webview/JsScriptRecord\n*L\n66#1:90\n70#1:93\n69#1:91,2\n69#1:94\n*E\n"})
public final class JsScriptRecord {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final String script;
    @Nullable
    private final Set<String> allowedUrls;
    @NotNull
    private static final Set<String> SOVEREIGN_CLOUD_URL_WITH_EXTRA_VALIDATION;

    public JsScriptRecord(@NotNull String id2, @NotNull String script, @Nullable Set<String> allowedUrls) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        this.id = id2;
        this.script = script;
        this.allowedUrls = allowedUrls;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getScript() {
        return this.script;
    }

    public final boolean isAllowedForUrl(@NotNull String url) {
        boolean bl;
        block10: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            if (this.allowedUrls == null) {
                return true;
            }
            String $this$toUri$iv = url;
            boolean $i$f$toUri = false;
            Uri uri = Uri.parse((String)$this$toUri$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.parse(this)");
            Uri uri2 = uri;
            Iterable $this$any$iv = this.allowedUrls;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    Uri allowedUri;
                    String allowedUrl = (String)element$iv;
                    boolean bl3 = false;
                    String $this$toUri$iv2 = allowedUrl;
                    boolean $i$f$toUri2 = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)Uri.parse((String)$this$toUri$iv2), (String)"Uri.parse(this)");
                    boolean schemeMatches = Intrinsics.areEqual((Object)uri2.getScheme(), (Object)allowedUri.getScheme());
                    boolean hostMatches = Intrinsics.areEqual((Object)uri2.getHost(), (Object)allowedUri.getHost());
                    if (schemeMatches && hostMatches) {
                        if (SOVEREIGN_CLOUD_URL_WITH_EXTRA_VALIDATION.contains(allowedUrl)) {
                            String string2;
                            String string3 = string2 = uri2.getPath();
                            if (string3 != null) {
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"path");
                                bl2 = StringsKt.contains((CharSequence)string2, (CharSequence)"fido", (boolean)true);
                            } else {
                                bl2 = false;
                            }
                        } else {
                            bl2 = true;
                        }
                    } else {
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        return bl;
    }

    static {
        Object[] objectArray = new String[]{"https://login.microsoftonline.us", "https://login.microsoftonline.microsoft.scloud", "https://login.microsoftonline.eaglex.ic.gov"};
        SOVEREIGN_CLOUD_URL_WITH_EXTRA_VALIDATION = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/microsoft/identity/common/internal/ui/webview/JsScriptRecord$Companion;", "", "()V", "SOVEREIGN_CLOUD_URL_WITH_EXTRA_VALIDATION", "", "", "getSOVEREIGN_CLOUD_URL_WITH_EXTRA_VALIDATION", "()Ljava/util/Set;", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getSOVEREIGN_CLOUD_URL_WITH_EXTRA_VALIDATION() {
            return SOVEREIGN_CLOUD_URL_WITH_EXTRA_VALIDATION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

