/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.microsoft.identity.common.internal.providers.oauth2.AndroidAuthorizationStrategy;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationActivityFactory;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationActivityParameters;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.providers.RawAuthorizationResult;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftAuthorizationRequest;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.java.ui.AuthorizationAgent;
import com.microsoft.identity.common.java.util.ResultFuture;
import com.microsoft.identity.common.logging.Logger;
import java.net.URI;
import java.util.concurrent.Future;

public class EmbeddedWebViewAuthorizationStrategy<GenericOAuth2Strategy extends OAuth2Strategy, GenericAuthorizationRequest extends AuthorizationRequest>
extends AndroidAuthorizationStrategy<GenericOAuth2Strategy, GenericAuthorizationRequest> {
    private static final String TAG = EmbeddedWebViewAuthorizationStrategy.class.getSimpleName();
    private ResultFuture<AuthorizationResult> mAuthorizationResultFuture;
    private GenericOAuth2Strategy mOAuth2Strategy;
    private GenericAuthorizationRequest mAuthorizationRequest;

    public EmbeddedWebViewAuthorizationStrategy(@NonNull Context applicationContext, @NonNull Activity activity, @Nullable Fragment fragment) {
        super(applicationContext, activity, fragment);
    }

    public Future<AuthorizationResult> requestAuthorization(GenericAuthorizationRequest authorizationRequest, GenericOAuth2Strategy oAuth2Strategy) throws ClientException {
        String methodTag = TAG + ":requestAuthorization";
        this.mAuthorizationResultFuture = new ResultFuture();
        this.mOAuth2Strategy = oAuth2Strategy;
        this.mAuthorizationRequest = authorizationRequest;
        Logger.info(methodTag, "Perform the authorization request with embedded webView.");
        URI requestUrl = authorizationRequest.getAuthorizationRequestAsHttpRequest();
        String sourceLibraryName = null;
        String sourceLibraryVersion = null;
        String utid = null;
        if (this.mAuthorizationRequest instanceof MicrosoftAuthorizationRequest) {
            sourceLibraryName = ((MicrosoftAuthorizationRequest)this.mAuthorizationRequest).getLibraryName();
            sourceLibraryVersion = ((MicrosoftAuthorizationRequest)this.mAuthorizationRequest).getLibraryVersion();
        }
        if (this.mAuthorizationRequest instanceof MicrosoftStsAuthorizationRequest) {
            utid = ((MicrosoftStsAuthorizationRequest)this.mAuthorizationRequest).getUtid();
        }
        Intent authIntent = this.buildAuthorizationActivityStartIntent(requestUrl, sourceLibraryName, sourceLibraryVersion, utid);
        this.launchIntent(authIntent);
        return this.mAuthorizationResultFuture;
    }

    private Intent buildAuthorizationActivityStartIntent(URI requestUrl, @Nullable String sourceLibraryName, @Nullable String sourceLibraryVersion, @Nullable String utid) {
        String redirectUri = this.mAuthorizationRequest.getBrkRedirectUri() != null ? this.mAuthorizationRequest.getBrkRedirectUri() : this.mAuthorizationRequest.getRedirectUri();
        AuthorizationActivityParameters authorizationActivityParameters = new AuthorizationActivityParameters(this.getApplicationContext(), null, requestUrl.toString(), redirectUri, this.mAuthorizationRequest.getRequestHeaders(), AuthorizationAgent.WEBVIEW, this.mAuthorizationRequest.isWebViewZoomEnabled(), this.mAuthorizationRequest.isWebViewZoomControlsEnabled(), sourceLibraryName, sourceLibraryVersion, utid);
        return AuthorizationActivityFactory.getAuthorizationActivityIntent(authorizationActivityParameters);
    }

    public void completeAuthorization(int requestCode, @NonNull RawAuthorizationResult data) {
        String methodTag = TAG + ":completeAuthorization";
        if (requestCode == 1001) {
            if (this.mOAuth2Strategy != null && this.mAuthorizationResultFuture != null) {
                AuthorizationResult result = this.mOAuth2Strategy.getAuthorizationResultFactory().createAuthorizationResult(data, this.mAuthorizationRequest);
                this.mAuthorizationResultFuture.setResult((Object)result);
            } else {
                Logger.warn(methodTag, "SDK Cancel triggering before request is sent out. Potentially due to an stale activity state, oAuth2Strategy null ? [" + (this.mOAuth2Strategy == null) + "]mAuthorizationResultFuture ? [" + (this.mAuthorizationResultFuture == null) + "]");
            }
        } else {
            Logger.warnPII(methodTag, "Unknown request code " + requestCode);
        }
    }
}

