/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.browser;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.browser.customtabs.CustomTabsCallback;
import androidx.browser.customtabs.CustomTabsClient;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.browser.customtabs.CustomTabsServiceConnection;
import androidx.browser.customtabs.CustomTabsSession;
import com.microsoft.identity.common.logging.Logger;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class CustomTabsManager {
    private static final String TAG = CustomTabsManager.class.getSimpleName();
    private static final long CUSTOM_TABS_MAX_CONNECTION_TIMEOUT = 1L;
    private final CountDownLatch mClientLatch;
    private final WeakReference<Context> mContextRef;
    private final AtomicReference<CustomTabsClient> mCustomTabsClient;
    private boolean mCustomTabsServiceIsBound;
    private CustomTabsIntent mCustomTabsIntent;
    private CustomTabsServiceConnection mCustomTabsServiceConnection = new CustomTabsServiceConnection(){

        public void onCustomTabsServiceConnected(ComponentName name, CustomTabsClient client) {
            String methodTag = TAG + ":onCustomTabsServiceConnection";
            Logger.info(methodTag, "CustomTabsService is connected");
            client.warmup(0L);
            CustomTabsManager.this.mCustomTabsServiceIsBound = true;
            CustomTabsManager.this.mCustomTabsClient.set(client);
            CustomTabsManager.this.mClientLatch.countDown();
        }

        public void onServiceDisconnected(ComponentName name) {
            String methodTag = TAG + ":onServiceDisconnected";
            Logger.info(methodTag, "CustomTabsService is disconnected");
            CustomTabsManager.this.mCustomTabsServiceIsBound = false;
            CustomTabsManager.this.mCustomTabsClient.set(null);
            CustomTabsManager.this.mClientLatch.countDown();
        }

        public void onBindingDied(ComponentName name) {
            String methodTag = TAG + ":onBindingDied";
            Logger.warn(methodTag, "Binding died callback on custom tabs service, there will likely be failures.  Component class that failed: " + (name == null ? "null" : name.getClassName()));
            super.onBindingDied(name);
        }

        public void onNullBinding(ComponentName name) {
            String methodTag = TAG + ":onNullBinding";
            Logger.warn(methodTag, "Null binding callback on custom tabs service, there will likely be failures. Component class that failed: " + (name == null ? "null" : name.getClassName()));
            super.onNullBinding(name);
        }
    };

    public CustomTabsIntent getCustomTabsIntent() {
        return this.mCustomTabsIntent;
    }

    public CustomTabsManager(@NonNull Context context) {
        this.mContextRef = new WeakReference<Context>(context);
        this.mCustomTabsClient = new AtomicReference();
        this.mClientLatch = new CountDownLatch(1);
    }

    public synchronized boolean bind(@Nullable Context context, @NonNull String browserPackage) {
        String methodTag = TAG + ":bind";
        if (context == null || !CustomTabsClient.bindCustomTabsService((Context)context, (String)browserPackage, (CustomTabsServiceConnection)this.mCustomTabsServiceConnection)) {
            Logger.info(methodTag, "Unable to bind custom tabs service " + (context == null ? "because the context was null" : "because the bind call failed"));
            this.mClientLatch.countDown();
            return false;
        }
        CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder(this.createSession(null));
        builder.setSendToExternalDefaultHandlerEnabled(true);
        this.mCustomTabsIntent = builder.setShowTitle(true).build();
        return true;
    }

    private CustomTabsSession createSession(@Nullable CustomTabsCallback callback) {
        String methodTag = TAG + ":createSession";
        CustomTabsClient client = this.getClient();
        if (client == null) {
            Logger.warn(methodTag, "Failed to create custom tabs session with null CustomTabClient.");
            return null;
        }
        CustomTabsSession session = client.newSession(callback);
        if (session == null) {
            Logger.warn(methodTag, "Failed to create custom tabs session through custom tabs client.");
        }
        return session;
    }

    private CustomTabsClient getClient() {
        String methodTag = TAG + ":getClient";
        try {
            this.mClientLatch.await(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Logger.info(methodTag, "Interrupted while waiting for browser connection");
            this.mClientLatch.countDown();
        }
        return this.mCustomTabsClient.get();
    }

    public synchronized void unbind() {
        String methodTag;
        block3: {
            methodTag = TAG + ":unbind";
            Context context = (Context)this.mContextRef.get();
            if (context != null && this.mCustomTabsServiceIsBound) {
                try {
                    context.unbindService((ServiceConnection)this.mCustomTabsServiceConnection);
                }
                catch (Exception e) {
                    Logger.warn(methodTag, "Error unbinding custom tabs service, likely failed to bind or previously died: " + e.getMessage());
                    if (!(e instanceof InterruptedException)) break block3;
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.mCustomTabsServiceIsBound = false;
        this.mCustomTabsClient.set(null);
        Logger.info(methodTag, "CustomTabsService is unbound.");
    }
}

