/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.result;

import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.gson.Gson;
import com.microsoft.identity.common.adal.internal.AuthenticationConstants;
import com.microsoft.identity.common.adal.internal.util.HashMapExtensions;
import com.microsoft.identity.common.adal.internal.util.JsonExtensions;
import com.microsoft.identity.common.internal.broker.BrokerResult;
import com.microsoft.identity.common.internal.request.AuthenticationSchemeTypeAdapter;
import com.microsoft.identity.common.internal.result.IBrokerResultAdapter;
import com.microsoft.identity.common.internal.util.GzipUtil;
import com.microsoft.identity.common.java.cache.CacheRecord;
import com.microsoft.identity.common.java.cache.ICacheRecord;
import com.microsoft.identity.common.java.commands.AcquirePrtSsoTokenBatchResult;
import com.microsoft.identity.common.java.commands.AcquirePrtSsoTokenResult;
import com.microsoft.identity.common.java.dto.AadDeviceIdRecord;
import com.microsoft.identity.common.java.dto.AccessTokenRecord;
import com.microsoft.identity.common.java.dto.IAccountRecord;
import com.microsoft.identity.common.java.exception.ArgumentException;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.exception.IntuneAppProtectionPolicyRequiredException;
import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.exception.UiRequiredException;
import com.microsoft.identity.common.java.exception.UnsupportedBrokerException;
import com.microsoft.identity.common.java.exception.UserCancelException;
import com.microsoft.identity.common.java.flighting.CommonFlight;
import com.microsoft.identity.common.java.flighting.CommonFlightsManager;
import com.microsoft.identity.common.java.flighting.IFlightConfig;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.OTelUtility;
import com.microsoft.identity.common.java.opentelemetry.SpanExtension;
import com.microsoft.identity.common.java.opentelemetry.SpanName;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationResult;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.java.request.SdkType;
import com.microsoft.identity.common.java.result.AcquireTokenResult;
import com.microsoft.identity.common.java.result.GenerateShrResult;
import com.microsoft.identity.common.java.result.ILocalAuthenticationResult;
import com.microsoft.identity.common.java.result.LocalAuthenticationResult;
import com.microsoft.identity.common.java.ui.PreferredAuthMethod;
import com.microsoft.identity.common.java.util.BrokerProtocolVersionUtil;
import com.microsoft.identity.common.java.util.HeaderSerializationUtil;
import com.microsoft.identity.common.java.util.ObjectMapper;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.ThrowableUtil;
import com.microsoft.identity.common.logging.Logger;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.json.JSONException;

public class MsalBrokerResultAdapter
implements IBrokerResultAdapter {
    private static final String TAG = MsalBrokerResultAdapter.class.getSimpleName();
    public static final Gson GSON = new Gson();
    private static final String DCF_NOT_SUPPORTED_ERROR = "deviceCodeFlowAuthRequest() not supported in BrokerMsalController";
    private static final String WEBAPPS_ENTRY_IS_NULL_ERROR = "WebApps entry in the bundle is null";
    private final IBooleanCallback mShouldStopReturningRtWithAadResponseCallback;
    public static final String REMOVE_RT_FROM_AAD_RESULT_MSAL_PROTOCOL_VERSION = "16.0";

    public MsalBrokerResultAdapter() {
        this.mShouldStopReturningRtWithAadResponseCallback = () -> CommonFlightsManager.INSTANCE.getFlightsProvider().isFlightEnabled((IFlightConfig)CommonFlight.STOP_RETURNING_AAD_RT_BACK_TO_CALLING_APP);
    }

    @VisibleForTesting(otherwise=2)
    public MsalBrokerResultAdapter(boolean shouldStopReturningRtWithAadResponse) {
        this.mShouldStopReturningRtWithAadResponseCallback = () -> shouldStopReturningRtWithAadResponse;
    }

    @Override
    @NonNull
    public Bundle bundleFromAuthenticationResult(@NonNull ILocalAuthenticationResult authenticationResult, @Nullable String negotiatedBrokerProtocolVersion) {
        String methodTag = TAG + ":bundleFromAuthenticationResult";
        Logger.info(methodTag, "Constructing result bundle from ILocalAuthenticationResult");
        Bundle resultBundle = this.bundleFromBrokerResult(this.buildBrokerResultFromAuthenticationResult(authenticationResult, negotiatedBrokerProtocolVersion), negotiatedBrokerProtocolVersion);
        resultBundle.putBoolean("broker_request_v2_success", true);
        return resultBundle;
    }

    @VisibleForTesting(otherwise=2)
    @NonNull
    public BrokerResult buildBrokerResultFromAuthenticationResult(@NonNull ILocalAuthenticationResult authenticationResult, @Nullable String negotiatedBrokerProtocolVersion) {
        IAccountRecord accountRecord = authenticationResult.getAccountRecord();
        AccessTokenRecord accessTokenRecord = authenticationResult.getAccessTokenRecord();
        long expiresOn = Long.parseLong(accessTokenRecord.getExpiresOn());
        long extendedExpiresOn = accessTokenRecord.getExtendedExpiresOn() == null ? expiresOn : Long.parseLong(accessTokenRecord.getExtendedExpiresOn());
        BrokerResult.Builder brokerResultBuilder = new BrokerResult.Builder().tenantProfileRecords(authenticationResult.getCacheRecordWithTenantProfileData()).accessToken(authenticationResult.getAccessToken()).idToken(authenticationResult.getIdToken()).homeAccountId(accountRecord.getHomeAccountId()).localAccountId(accountRecord.getLocalAccountId()).userName(accountRecord.getUsername()).tokenType(accessTokenRecord.getAccessTokenType()).clientId(accessTokenRecord.getClientId()).familyId(authenticationResult.getFamilyId()).scope(accessTokenRecord.getTarget()).clientInfo(accountRecord.getClientInfo()).authority(accessTokenRecord.getAuthority()).environment(accessTokenRecord.getEnvironment()).tenantId(authenticationResult.getTenantId()).expiresOn(expiresOn).extendedExpiresOn(extendedExpiresOn).cachedAt(Long.parseLong(accessTokenRecord.getCachedAt())).speRing(authenticationResult.getSpeRing()).success(true).servicedFromCache(authenticationResult.isServicedFromCache());
        if (this.shouldRemoveRefreshTokenFromResult(authenticationResult, negotiatedBrokerProtocolVersion)) {
            brokerResultBuilder.tenantProfileRecords(this.removeRefreshTokenFromCacheRecords(authenticationResult.getCacheRecordWithTenantProfileData()));
        } else {
            brokerResultBuilder.tenantProfileRecords(authenticationResult.getCacheRecordWithTenantProfileData()).refreshToken(authenticationResult.getRefreshToken()).refreshTokenAge(authenticationResult.getRefreshTokenAge());
        }
        return brokerResultBuilder.build();
    }

    @Nullable
    private List<ICacheRecord> removeRefreshTokenFromCacheRecords(@Nullable List<ICacheRecord> originalList) {
        if (originalList == null) {
            return null;
        }
        ArrayList<ICacheRecord> cacheRecordsWithoutRT = new ArrayList<ICacheRecord>();
        for (ICacheRecord record : originalList) {
            cacheRecordsWithoutRT.add((ICacheRecord)CacheRecord.builder().account(record.getAccount()).idToken(record.getIdToken()).v1IdToken(record.getV1IdToken()).accessToken(record.getAccessToken()).build());
        }
        return cacheRecordsWithoutRT;
    }

    private boolean shouldRemoveRefreshTokenFromResult(@NonNull ILocalAuthenticationResult result, @Nullable String negotiatedBrokerProtocolVersion) {
        String methodTag = TAG + ":shouldRemoveRefreshTokenFromResult";
        if (this.mShouldStopReturningRtWithAadResponseCallback.getResult()) {
            if (!BrokerProtocolVersionUtil.isFirstVersionOlderOrEqual((String)REMOVE_RT_FROM_AAD_RESULT_MSAL_PROTOCOL_VERSION, (String)negotiatedBrokerProtocolVersion)) {
                SpanExtension.current().setAttribute(AttributeName.stop_returning_rt_result.name(), "protocol_version_too_low");
                return false;
            }
            try {
                if (!StringUtil.isNullOrEmpty((String)result.getTenantId())) {
                    boolean resultToReturn = !"9188040d-6c67-4c5b-b112-36a304b66dad".equalsIgnoreCase(result.getTenantId());
                    SpanExtension.current().setAttribute(AttributeName.stop_returning_rt_result.name(), Boolean.toString(resultToReturn));
                    return resultToReturn;
                }
                if (!StringUtil.isNullOrEmpty((String)result.getAccessTokenRecord().getAuthority())) {
                    boolean resultToReturn = !result.getAccessTokenRecord().getAuthority().contains("9188040d-6c67-4c5b-b112-36a304b66dad") && !result.getAccessTokenRecord().getAuthority().contains("consumers");
                    SpanExtension.current().setAttribute(AttributeName.stop_returning_rt_result.name(), Boolean.toString(resultToReturn));
                    return resultToReturn;
                }
                SpanExtension.current().setAttribute(AttributeName.stop_returning_rt_result.name(), "cannot_determine_account_type");
                return false;
            }
            catch (Throwable t) {
                Logger.error(methodTag, "Failed to determine if RT should be removed", t);
                SpanExtension.current().setAttribute(AttributeName.stop_returning_rt_result.name(), ThrowableUtil.getStackTraceAsString((Throwable)t));
                return false;
            }
        }
        SpanExtension.current().setAttribute(AttributeName.stop_returning_rt_result.name(), "feature_disabled");
        return false;
    }

    @Override
    @NonNull
    public Bundle bundleFromBaseException(@NonNull BaseException exception, @Nullable String negotiatedBrokerProtocolVersion) {
        String methodTag = TAG + ":bundleFromBaseException";
        Logger.info(methodTag, "Constructing result bundle from ClientException");
        BrokerResult.Builder builder = new BrokerResult.Builder().success(false).errorCode(exception.getErrorCode()).subErrorCode(exception.getSubErrorCode()).errorMessage(exception.getMessage()).exceptionType(exception.getExceptionName()).correlationId(exception.getCorrelationId()).cliTelemErrorCode(exception.getCliTelemErrorCode()).cliTelemSubErrorCode(exception.getCliTelemSubErrorCode()).speRing(exception.getSpeRing()).refreshTokenAge(exception.getRefreshTokenAge());
        if (exception instanceof ServiceException) {
            ServiceException serviceException = (ServiceException)((Object)exception);
            builder.subErrorCode(serviceException.getSubErrorCode()).httpStatusCode(serviceException.getHttpStatusCode()).httpResponseBody(AuthenticationSchemeTypeAdapter.getGsonInstance().toJson((Object)serviceException.getHttpResponseBody()));
            if (serviceException.getHttpResponseHeaders() != null) {
                builder.httpResponseHeaders(HeaderSerializationUtil.toJson((Map)((ServiceException)((Object)exception)).getHttpResponseHeaders()));
            }
            if (serviceException.getHttpResponseBody() != null) {
                builder.httpResponseBody(AuthenticationSchemeTypeAdapter.getGsonInstance().toJson((Object)serviceException.getHttpResponseBody()));
            }
        }
        if (CommonFlightsManager.INSTANCE.getFlightsProvider().isFlightEnabled((IFlightConfig)CommonFlight.ADD_USERNAME_IN_UI_REQUIRED_EXCEPTION_BROKER_RESULT) && exception instanceof UiRequiredException) {
            builder.userName(exception.getUsername());
        }
        if (exception instanceof IntuneAppProtectionPolicyRequiredException) {
            SpanExtension.current().setAttribute(AttributeName.is_mam_flow.name(), true);
            builder.userName(((IntuneAppProtectionPolicyRequiredException)exception).getAccountUpn()).localAccountId(((IntuneAppProtectionPolicyRequiredException)exception).getAccountUserId()).authority(((IntuneAppProtectionPolicyRequiredException)exception).getAuthorityUrl()).tenantId(((IntuneAppProtectionPolicyRequiredException)exception).getTenantId());
        }
        Bundle resultBundle = this.bundleFromBrokerResult(builder.build(), negotiatedBrokerProtocolVersion);
        resultBundle.putBoolean("broker_request_v2_success", false);
        return resultBundle;
    }

    @Override
    @NonNull
    public ILocalAuthenticationResult authenticationResultFromBundle(@NonNull Bundle resultBundle) throws ClientException {
        String methodTag = TAG + ":authenticationResultFromBundle";
        BrokerResult brokerResult = this.brokerResultFromBundle(resultBundle);
        Logger.info(methodTag, "Broker Result returned from Bundle, constructing authentication result");
        List<ICacheRecord> tenantProfileCacheRecords = brokerResult.getTenantProfileData();
        if (tenantProfileCacheRecords == null) {
            Logger.error(methodTag, "getTenantProfileData is null", null);
            throw new ClientException("invalid_broker_bundle", "getTenantProfileData is null.");
        }
        return new LocalAuthenticationResult(tenantProfileCacheRecords.get(0), tenantProfileCacheRecords, SdkType.MSAL, brokerResult.isServicedFromCache());
    }

    @Override
    @NonNull
    public BaseException getBaseExceptionFromBundle(@NonNull Bundle resultBundle) {
        BrokerResult brokerResult;
        String methodTag = TAG + ":getBaseExceptionFromBundle";
        Logger.info(methodTag, "Constructing exception from result bundle");
        try {
            brokerResult = this.brokerResultFromBundle(resultBundle);
        }
        catch (ClientException e) {
            return e;
        }
        String exceptionType = brokerResult.getExceptionType();
        if (!StringUtil.isNullOrEmpty((String)exceptionType)) {
            return this.getBaseExceptionFromExceptionType(exceptionType, brokerResult);
        }
        Logger.info(methodTag, "Exception type is not returned from the broker, using error codes to transform to the right exception");
        return this.getBaseExceptionFromErrorCodes(brokerResult);
    }

    @Override
    @NonNull
    public AcquirePrtSsoTokenResult getAcquirePrtSsoTokenResultFromBundle(Bundle resultBundle) {
        return (AcquirePrtSsoTokenResult)GSON.fromJson(resultBundle.getString("broker_generate_sso_token"), AcquirePrtSsoTokenResult.class);
    }

    @Override
    @NonNull
    public AcquirePrtSsoTokenBatchResult getAcquirePrtSsoTokenBatchResultFromBundle(Bundle resultBundle) {
        return (AcquirePrtSsoTokenBatchResult)GSON.fromJson(resultBundle.getString("broker_generate_all_sso_tokens"), AcquirePrtSsoTokenBatchResult.class);
    }

    @NonNull
    public Bundle bundleFromBrokerResult(@NonNull BrokerResult brokerResult, @Nullable String negotiatedBrokerProtocolVersion) {
        String methodTag = TAG + ":bundleFromBrokerResult";
        Bundle resultBundle = new Bundle();
        String brokerResultString = AuthenticationSchemeTypeAdapter.getGsonInstance().toJson((Object)brokerResult, BrokerResult.class);
        if (BrokerProtocolVersionUtil.canCompressBrokerPayloads((String)negotiatedBrokerProtocolVersion)) {
            try {
                byte[] compressedBytes = GzipUtil.compressString(brokerResultString);
                Logger.info(methodTag, "Broker Result, raw payload size:" + brokerResultString.getBytes(AuthenticationConstants.CHARSET_UTF8).length + " ,compressed bytes " + compressedBytes.length);
                resultBundle.putByteArray("broker_result_v2_compressed", compressedBytes);
            }
            catch (IOException e) {
                Logger.error(methodTag, "Failed to compress Broker Result, sending as jsonString ", e);
                resultBundle.putString("broker_result_v2", brokerResultString);
            }
        } else {
            Logger.info(methodTag, "Broker protocol version: " + negotiatedBrokerProtocolVersion + " lower than compression changes, sending as string");
            resultBundle.putString("broker_result_v2", brokerResultString);
        }
        return resultBundle;
    }

    @NonNull
    public BrokerResult brokerResultFromBundle(@NonNull Bundle resultBundle) throws ClientException {
        String brokerResultString;
        String methodTag = TAG + ":brokerResultFromBundle";
        byte[] compressedBytes = resultBundle.getByteArray("broker_result_v2_compressed");
        if (compressedBytes != null) {
            try {
                brokerResultString = GzipUtil.decompressBytesToString(compressedBytes);
            }
            catch (IOException e) {
                Logger.error(methodTag, "Failed to decompress broker result :", e);
                throw new ClientException("invalid_broker_bundle", "Failed to decompress broker result", (Throwable)e);
            }
        } else {
            brokerResultString = resultBundle.getString("broker_result_v2");
        }
        if (StringUtil.isNullOrEmpty((String)brokerResultString)) {
            Logger.error(methodTag, "Broker Result not returned from Broker", null);
            throw new ClientException("invalid_broker_bundle", "Broker Result not returned from Broker", null);
        }
        return JsonExtensions.getBrokerResultFromJsonString(brokerResultString);
    }

    @NonNull
    private BaseException getBaseExceptionFromExceptionType(@NonNull String exceptionType, @NonNull BrokerResult brokerResult) {
        Object baseException;
        String methodTag = TAG + ":getBaseExceptionFromExceptionType";
        Logger.warn(methodTag, "Received a " + exceptionType + " from Broker : " + brokerResult.getErrorCode());
        if (exceptionType.equalsIgnoreCase("com.microsoft.identity.common.exception.UiRequiredException")) {
            baseException = this.getUiRequiredException(brokerResult);
        } else if (exceptionType.equalsIgnoreCase("com.microsoft.identity.common.exception.ServiceException")) {
            baseException = this.getServiceException(brokerResult);
        } else if (exceptionType.equalsIgnoreCase("com.microsoft.identity.common.exception.IntuneAppProtectionPolicyRequiredException")) {
            baseException = this.getIntuneProtectionRequiredException(brokerResult);
        } else if (exceptionType.equalsIgnoreCase("com.microsoft.identity.common.exception.UserCancelException")) {
            baseException = new UserCancelException();
        } else if (exceptionType.equalsIgnoreCase("com.microsoft.identity.common.exception.ClientException")) {
            baseException = new ClientException(brokerResult.getErrorCode(), brokerResult.getErrorMessage());
        } else if (exceptionType.equalsIgnoreCase("com.microsoft.identity.common.exception.ArgumentException")) {
            baseException = new ArgumentException("brokerTokenRequest", brokerResult.getErrorCode(), brokerResult.getErrorMessage());
        } else {
            Logger.warn(methodTag, " Exception type is unknown : " + exceptionType + brokerResult.getErrorCode() + ", defaulting to Client Exception ");
            baseException = new ClientException(brokerResult.getErrorCode(), brokerResult.getErrorMessage());
        }
        baseException.setSubErrorCode(brokerResult.getSubErrorCode());
        baseException.setCliTelemErrorCode(brokerResult.getCliTelemErrorCode());
        baseException.setCliTelemSubErrorCode(brokerResult.getCliTelemSubErrorCode());
        baseException.setCorrelationId(brokerResult.getCorrelationId());
        baseException.setSpeRing(brokerResult.getSpeRing());
        baseException.setRefreshTokenAge(brokerResult.getRefreshTokenAge());
        return baseException;
    }

    @NonNull
    private BaseException getBaseExceptionFromErrorCodes(@NonNull BrokerResult brokerResult) {
        Object baseException;
        String methodTag = TAG + ":getBaseExceptionFromErrorCodes";
        String errorCode = brokerResult.getErrorCode();
        if ("interaction_required".equalsIgnoreCase(errorCode) || "invalid_grant".equalsIgnoreCase(errorCode) || "Broker refresh token is invalid".equalsIgnoreCase(errorCode) || "no_account_found".equalsIgnoreCase(errorCode) || "no_tokens_found".equalsIgnoreCase(errorCode)) {
            Logger.warn(methodTag, "Received a UIRequired exception from Broker : " + errorCode);
            baseException = this.getUiRequiredException(brokerResult);
        } else if ("unauthorized_client".equalsIgnoreCase(errorCode) && "protection_policy_required".equalsIgnoreCase(brokerResult.getSubErrorCode())) {
            Logger.warn(methodTag, "Received a IntuneAppProtectionPolicyRequiredException exception from Broker : " + errorCode);
            baseException = this.getIntuneProtectionRequiredException(brokerResult);
        } else if ("User cancelled".equalsIgnoreCase(errorCode)) {
            Logger.warn(methodTag, "Received a User cancelled exception from Broker : " + errorCode);
            baseException = new UserCancelException();
        } else if ("illegal_argument_exception".equalsIgnoreCase(errorCode)) {
            Logger.warn(methodTag, "Received a Argument exception from Broker : " + errorCode);
            baseException = new ArgumentException("brokerTokenRequest", errorCode, brokerResult.getErrorMessage());
        } else if (!StringUtil.isNullOrEmpty((String)brokerResult.getHttpResponseHeaders()) || !StringUtil.isNullOrEmpty((String)brokerResult.getHttpResponseBody())) {
            Logger.warn(methodTag, "Received a Service exception from Broker : " + errorCode);
            baseException = this.getServiceException(brokerResult);
        } else {
            Logger.warn(methodTag, "Received a Client exception from Broker : " + errorCode);
            baseException = new ClientException(brokerResult.getErrorCode(), brokerResult.getErrorMessage());
        }
        baseException.setSubErrorCode(brokerResult.getSubErrorCode());
        baseException.setCliTelemErrorCode(brokerResult.getCliTelemErrorCode());
        baseException.setCliTelemSubErrorCode(brokerResult.getCliTelemSubErrorCode());
        baseException.setCorrelationId(brokerResult.getCorrelationId());
        baseException.setSpeRing(brokerResult.getSpeRing());
        baseException.setRefreshTokenAge(brokerResult.getRefreshTokenAge());
        return baseException;
    }

    @NonNull
    private IntuneAppProtectionPolicyRequiredException getIntuneProtectionRequiredException(@NonNull BrokerResult brokerResult) {
        String methodTag = TAG + ":getIntuneProtectionRequiredException";
        IntuneAppProtectionPolicyRequiredException exception = new IntuneAppProtectionPolicyRequiredException(brokerResult.getErrorCode(), brokerResult.getErrorMessage());
        exception.setTenantId(brokerResult.getTenantId());
        exception.setAuthorityUrl(brokerResult.getAuthority());
        exception.setAccountUserId(brokerResult.getLocalAccountId());
        exception.setAccountUpn(brokerResult.getUserName());
        exception.setSubErrorCode(brokerResult.getSubErrorCode());
        try {
            exception.setHttpResponseBody(HashMapExtensions.jsonStringAsMap(brokerResult.getHttpResponseBody()));
            if (brokerResult.getHttpResponseHeaders() != null) {
                exception.setHttpResponseHeaders(HeaderSerializationUtil.fromJson((String)brokerResult.getHttpResponseHeaders()));
            }
        }
        catch (JSONException e) {
            Logger.warn(methodTag, "Unable to parse json");
        }
        return exception;
    }

    @NonNull
    private ServiceException getServiceException(@NonNull BrokerResult brokerResult) {
        String methodTag = TAG + ":getServiceException";
        ServiceException serviceException = new ServiceException(brokerResult.getErrorCode(), brokerResult.getErrorMessage(), null);
        try {
            serviceException.setHttpResponseBody(brokerResult.getHttpResponseBody() != null ? HashMapExtensions.jsonStringAsMap(brokerResult.getHttpResponseBody()) : null);
            serviceException.setHttpResponseHeaders(brokerResult.getHttpResponseHeaders() != null ? HeaderSerializationUtil.fromJson((String)brokerResult.getHttpResponseHeaders()) : null);
        }
        catch (JSONException e) {
            Logger.warn(methodTag, "Unable to parse json");
        }
        return serviceException;
    }

    @NonNull
    private UiRequiredException getUiRequiredException(@NonNull BrokerResult brokerResult) {
        String errorCode = brokerResult.getErrorCode();
        UiRequiredException exception = new UiRequiredException(errorCode, brokerResult.getErrorMessage());
        if ("interaction_required".equalsIgnoreCase(errorCode) || "invalid_grant".equalsIgnoreCase(errorCode)) {
            exception.setSubErrorCode(brokerResult.getSubErrorCode());
        }
        if (!StringUtil.isNullOrEmpty((String)brokerResult.getUserName())) {
            exception.setUsername(brokerResult.getUserName());
        }
        return exception;
    }

    @NonNull
    public String verifyHelloFromResultBundle(@NonNull String activeBrokerPackageName, @Nullable Bundle bundle) throws BaseException {
        String methodTag = TAG + ":verifyHelloFromResultBundle";
        if (bundle == null) {
            Logger.warn(methodTag, "The hello result bundle is null.");
            throw new UnsupportedBrokerException(activeBrokerPackageName);
        }
        String negotiatedBrokerProtocolVersion = bundle.getString("common.broker.protocol.version.name");
        if (!StringUtil.isNullOrEmpty((String)negotiatedBrokerProtocolVersion)) {
            Logger.info(methodTag, "Able to establish the connect, the broker protocol version in common is [" + negotiatedBrokerProtocolVersion + "]");
            return negotiatedBrokerProtocolVersion;
        }
        if (!StringUtil.isNullOrEmpty((String)bundle.getString("error"))) {
            String errorCode = bundle.getString("error");
            String errorMessage = bundle.getString("error_description");
            throw new UnsupportedBrokerException(activeBrokerPackageName, errorCode, errorMessage);
        }
        Object resultObject = bundle.get("broker_result_v2");
        if (resultObject instanceof BrokerResult) {
            BrokerResult brokerResult = (BrokerResult)resultObject;
            throw new ClientException(brokerResult.getErrorCode(), brokerResult.getErrorMessage());
        }
        Logger.warn(methodTag, "The result bundle is not in a recognizable format.");
        throw new UnsupportedBrokerException(activeBrokerPackageName);
    }

    @NonNull
    public Intent getIntentForInteractiveRequestFromResultBundle(@NonNull Bundle resultBundle, @NonNull String negotiatedBrokerProtocolVersion) throws ClientException {
        Bundle interactiveRequestBundle = this.extractInteractiveRequestBundleFromResultBundle(resultBundle);
        String packageName = interactiveRequestBundle.getString("broker.package.name");
        String className = interactiveRequestBundle.getString("broker.activity.name");
        if (StringUtil.isNullOrEmpty((String)packageName) || StringUtil.isNullOrEmpty((String)className)) {
            throw new ClientException("invalid_broker_bundle", "Content of Authorization Intent's package and class name should not be null.");
        }
        Intent intent = new Intent();
        intent.setPackage(packageName);
        intent.setClassName(packageName, className);
        intent.putExtras(interactiveRequestBundle);
        intent.putExtra("common.broker.protocol.version.name", negotiatedBrokerProtocolVersion);
        return intent;
    }

    public Bundle extractInteractiveRequestBundleFromResultBundle(@NonNull Bundle resultBundle) {
        Intent interactiveRequestIntent = (Intent)resultBundle.getParcelable("intent");
        if (interactiveRequestIntent != null) {
            return interactiveRequestIntent.getExtras();
        }
        return resultBundle;
    }

    @NonNull
    public AuthorizationResult getDeviceCodeFlowAuthResultFromResultBundle(@NonNull Bundle resultBundle) throws BaseException, ClientException {
        String serializedDCFAuthResult = resultBundle.getString("broker_dcf_auth_result");
        if (serializedDCFAuthResult != null) {
            AuthorizationResult authorizationResult = (AuthorizationResult)ObjectMapper.deserializeJsonStringToObject((String)serializedDCFAuthResult, MicrosoftStsAuthorizationResult.class);
            return authorizationResult;
        }
        BrokerResult brokerResult = this.brokerResultFromBundle(resultBundle);
        if (brokerResult.getErrorCode() != null && brokerResult.getErrorCode().equals("dcf_not_supported")) {
            Logger.error(TAG, DCF_NOT_SUPPORTED_ERROR, new ClientException("dcf_not_supported", DCF_NOT_SUPPORTED_ERROR));
            throw new ClientException("dcf_not_supported", DCF_NOT_SUPPORTED_ERROR);
        }
        throw this.getBaseExceptionFromBundle(resultBundle);
    }

    /*
     * Loose catch block
     */
    public AcquireTokenResult getDeviceCodeFlowTokenResultFromResultBundle(@NonNull Bundle resultBundle) throws BaseException, ClientException {
        BrokerResult brokerResult = this.brokerResultFromBundle(resultBundle);
        Span span2 = OTelUtility.createSpan((String)SpanName.AcquireTokenDcfFetchToken.name());
        span2.setAttribute(AttributeName.correlation_id.name(), brokerResult.getCorrelationId());
        span2.setAttribute(AttributeName.public_api_id.name(), brokerResult.getClientId());
        try {
            block17: {
                AcquireTokenResult acquireTokenResult;
                block18: {
                    Scope scope;
                    block15: {
                        AcquireTokenResult acquireTokenResult2;
                        block16: {
                            scope = SpanExtension.makeCurrentSpan((Span)span2);
                            if (brokerResult.getErrorCode() != null && brokerResult.getErrorCode().equals("dcf_not_supported")) {
                                span2.setStatus(StatusCode.ERROR, "acquireDeviceCodeFlowToken() not supported in BrokerMsalController");
                                Logger.error(TAG, "acquireDeviceCodeFlowToken() not supported in BrokerMsalController", new ClientException("dcf_not_supported", DCF_NOT_SUPPORTED_ERROR));
                                throw new ClientException("dcf_not_supported", "acquireDeviceCodeFlowToken() not supported in BrokerMsalController");
                            }
                            if (!resultBundle.getBoolean("broker_request_v2_success")) break block15;
                            AcquireTokenResult acquireTokenResult3 = new AcquireTokenResult();
                            acquireTokenResult3.setLocalAuthenticationResult(this.authenticationResultFromBundle(resultBundle));
                            span2.setStatus(StatusCode.OK);
                            acquireTokenResult2 = acquireTokenResult3;
                            if (scope == null) break block16;
                            {
                                catch (Throwable throwable) {
                                    if (scope != null) {
                                        try {
                                            scope.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                            }
                            scope.close();
                        }
                        return acquireTokenResult2;
                    }
                    if (!brokerResult.getErrorCode().equals("authorization_pending")) break block17;
                    span2.setStatus(StatusCode.OK, "authorization_pending response");
                    acquireTokenResult = null;
                    if (scope == null) break block18;
                    scope.close();
                }
                return acquireTokenResult;
            }
            try {
                throw this.getBaseExceptionFromBundle(resultBundle);
            }
            catch (Throwable throwable) {
                span2.setStatus(StatusCode.ERROR);
                span2.recordException(throwable);
                throw throwable;
            }
        }
        finally {
            span2.end();
        }
    }

    @NonNull
    public AcquireTokenResult getAcquireTokenResultFromResultBundle(@NonNull Bundle resultBundle) throws BaseException {
        MsalBrokerResultAdapter resultAdapter = new MsalBrokerResultAdapter();
        if (resultBundle.getBoolean("broker_request_v2_success")) {
            AcquireTokenResult acquireTokenResult = new AcquireTokenResult();
            acquireTokenResult.setLocalAuthenticationResult(resultAdapter.authenticationResultFromBundle(resultBundle));
            return acquireTokenResult;
        }
        throw this.getBaseExceptionFromBundle(resultBundle);
    }

    @NonNull
    public Bundle bundleFromAccounts(@NonNull List<ICacheRecord> cacheRecords, @Nullable String negotiatedProtocolVersion) {
        String methodTag = TAG + ":bundleFromAccounts";
        Bundle resultBundle = new Bundle();
        String jsonString = JsonExtensions.getJsonStringFromICacheRecordList(cacheRecords);
        if (BrokerProtocolVersionUtil.canCompressBrokerPayloads((String)negotiatedProtocolVersion)) {
            try {
                byte[] bytes = GzipUtil.compressString(jsonString);
                Logger.info(methodTag, "Get accounts, raw payload size :" + jsonString.getBytes(AuthenticationConstants.CHARSET_UTF8).length + " compressed size " + bytes.length);
                resultBundle.putByteArray("broker_accounts_compressed", bytes);
            }
            catch (IOException e) {
                Logger.error(methodTag, " Failed to compress account list to bytes, sending as jsonString", e);
                resultBundle.putString("broker_accounts", jsonString);
            }
        } else {
            Logger.info(methodTag, "Broker protocol version: " + negotiatedProtocolVersion + " lower than compression changes, sending as string");
            resultBundle.putString("broker_accounts", jsonString);
        }
        return resultBundle;
    }

    @NonNull
    public List<ICacheRecord> getAccountsFromResultBundle(@NonNull Bundle bundle) throws BaseException {
        String accountJson;
        String methodTag = TAG + ":getAccountsFromResultBundle";
        byte[] compressedData = bundle.getByteArray("broker_accounts_compressed");
        if (compressedData != null) {
            try {
                accountJson = GzipUtil.decompressBytesToString(compressedData);
            }
            catch (IOException e) {
                Logger.error(methodTag, " Failed to decompress account list to bytes", e);
                throw new ClientException("invalid_broker_bundle", " Failed to decompress account list to bytes.");
            }
        } else {
            accountJson = bundle.getString("broker_accounts");
        }
        if (StringUtil.isNullOrEmpty((String)accountJson)) {
            throw new MsalBrokerResultAdapter().getBaseExceptionFromBundle(bundle);
        }
        return JsonExtensions.getICacheRecordListFromJsonString(accountJson);
    }

    public ICacheRecord resourceAccountRecordFromBundle(@NonNull Bundle bundle) throws BaseException {
        String methodTag = TAG + ":resourceAccountRecordFromBundle";
        List<ICacheRecord> cacheRecords = this.getAccountsFromResultBundle(bundle);
        if (cacheRecords.isEmpty()) {
            Logger.error(methodTag, "No accounts found in the result bundle", null);
            throw new ClientException("invalid_broker_bundle", "No accounts found in the result bundle");
        }
        if (cacheRecords.size() > 1) {
            Logger.error(methodTag, "Multiple accounts found in the result bundle", null);
            throw new ClientException("invalid_broker_bundle", "Multiple accounts found in the result bundle");
        }
        return cacheRecords.get(0);
    }

    public void verifyRemoveAccountResultFromBundle(@Nullable Bundle bundle) throws BaseException {
        String methodTag = TAG + ":verifyRemoveAccountResultFromBundle";
        if (bundle == null) {
            return;
        }
        String brokerResultString = bundle.getString("broker_result_v2");
        if (StringUtil.isNullOrEmpty((String)brokerResultString)) {
            throw this.getBaseExceptionFromBundle(bundle);
        }
        BrokerResult brokerResult = JsonExtensions.getBrokerResultFromJsonString(brokerResultString);
        if (brokerResult != null && brokerResult.isSuccess()) {
            return;
        }
        Logger.warn(methodTag, "Failed to remove account.");
        throw this.getBaseExceptionFromBundle(bundle);
    }

    @NonNull
    public Bundle bundleFromDeviceMode(boolean isSharedDevice) {
        Bundle resultBundle = new Bundle();
        resultBundle.putBoolean("broker_device_mode", isSharedDevice);
        return resultBundle;
    }

    public boolean getDeviceModeFromResultBundle(@NonNull Bundle bundle) throws BaseException {
        if (!bundle.containsKey("broker_device_mode")) {
            throw new MsalBrokerResultAdapter().getBaseExceptionFromBundle(bundle);
        }
        return bundle.getBoolean("broker_device_mode");
    }

    @NonNull
    public ClientException getExceptionForEmptyResultBundle() {
        return new ClientException("invalid_broker_bundle", "Broker Result not returned from Broker.");
    }

    public GenerateShrResult getGenerateShrResultFromResultBundle(@NonNull Bundle resultBundle) {
        String resultJson = resultBundle.getString("broker_generate_shr_result");
        GenerateShrResult shrResult = (GenerateShrResult)AuthenticationSchemeTypeAdapter.getGsonInstance().fromJson(resultJson, GenerateShrResult.class);
        return shrResult;
    }

    public PreferredAuthMethod getPreferredAuthMethodFromResultBundle(@Nullable Bundle bundle) throws BaseException {
        String methodTag = TAG + ":getPreferredAuthMethodFromResultBundle";
        if (bundle == null) {
            throw this.getExceptionForEmptyResultBundle();
        }
        if (!bundle.containsKey("preferred_auth_method_CODE")) {
            throw new MsalBrokerResultAdapter().getBaseExceptionFromBundle(bundle);
        }
        int preferredAuthMethodCode = bundle.getInt("preferred_auth_method_CODE");
        try {
            return PreferredAuthMethod.fromCode((int)preferredAuthMethodCode);
        }
        catch (NoSuchElementException e) {
            ClientException exception = new ClientException("client_update_required", "Preferred auth method code " + preferredAuthMethodCode + " not recognized.", (Throwable)e);
            Logger.error(methodTag, exception.getMessage(), exception);
            throw exception;
        }
    }

    public AadDeviceIdRecord aadDeviceIdRecordFromBundle(@NonNull Bundle resultBundle) throws BaseException {
        BrokerResult brokerResult = this.brokerResultFromBundle(resultBundle);
        AadDeviceIdRecord aadDeviceIdRecord = brokerResult.getAadDeviceIdRecord();
        if (aadDeviceIdRecord == null) {
            throw this.getBaseExceptionFromBundle(resultBundle);
        }
        return aadDeviceIdRecord;
    }

    @NonNull
    public String getSupportedWebAppsContractFromBundle(@NonNull Bundle resultBundle) throws ClientException {
        String result = resultBundle.getString("contracts");
        if (result == null) {
            throw new ClientException("invalid_broker_bundle", "WebApps entry in the bundle is null for contracts");
        }
        return result;
    }

    @NonNull
    public String getExecuteWebAppRequestResultFromBundle(@NonNull Bundle resultBundle) throws ClientException {
        if (resultBundle.containsKey("error")) {
            String result = resultBundle.getString("error");
            if (result == null) {
                throw new ClientException("invalid_broker_bundle", "WebApps entry in the bundle is null for error");
            }
            return result;
        }
        String result = resultBundle.getString("response");
        if (result == null) {
            throw new ClientException("invalid_broker_bundle", "WebApps entry in the bundle is null for response");
        }
        return result;
    }

    static interface IBooleanCallback {
        public boolean getResult();
    }
}

