/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import androidx.fragment.app.FragmentActivity;
import com.microsoft.identity.common.internal.providers.oauth2.WebViewAuthorizationFragment;
import com.microsoft.identity.common.internal.ui.browser.CustomTabsManager;
import com.microsoft.identity.common.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\b\u0010\f\u001a\u00020\bH\u0014J\u0012\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J\b\u0010\u0010\u001a\u00020\bH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/microsoft/identity/common/internal/providers/oauth2/SwitchBrowserActivity;", "Landroidx/fragment/app/FragmentActivity;", "()V", "cctLaunched", "", "customTabsManager", "Lcom/microsoft/identity/common/internal/ui/browser/CustomTabsManager;", "launchBrowser", "", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onNewIntent", "intent", "Landroid/content/Intent;", "onResume", "Companion", "common_distRelease"})
@SourceDebugExtension(value={"SMAP\nSwitchBrowserActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwitchBrowserActivity.kt\ncom/microsoft/identity/common/internal/providers/oauth2/SwitchBrowserActivity\n+ 2 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,247:1\n29#2:248\n*S KotlinDebug\n*F\n+ 1 SwitchBrowserActivity.kt\ncom/microsoft/identity/common/internal/providers/oauth2/SwitchBrowserActivity\n*L\n151#1:248\n*E\n"})
public final class SwitchBrowserActivity
extends FragmentActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean cctLaunched;
    @NotNull
    private CustomTabsManager customTabsManager = new CustomTabsManager((Context)this);
    @NotNull
    private static final String TAG;
    @NotNull
    public static final String BROWSER_PACKAGE_NAME = "browser_package_name";
    @NotNull
    public static final String BROWSER_SUPPORTS_CUSTOM_TABS = "browser_supports_custom_tabs";
    @NotNull
    public static final String PROCESS_URI = "process_uri";
    @NotNull
    public static final String RESUME_REQUEST = "resume_request";

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        String methodTag = TAG + ":onCreate";
        super.onCreate(savedInstanceState);
        Logger.info(methodTag, "SwitchBrowserActivity created - Launching browser");
        this.launchBrowser();
    }

    private final void launchBrowser() {
        String methodTag = TAG + ":launchBrowser";
        this.cctLaunched = false;
        Bundle bundle = this.getIntent().getExtras();
        if (bundle == null) {
            bundle = new Bundle();
        }
        Bundle extras = bundle;
        String browserPackageName = extras.getString(BROWSER_PACKAGE_NAME);
        boolean browserSupportsCustomTabs = extras.getBoolean(BROWSER_SUPPORTS_CUSTOM_TABS, false);
        String processUri = extras.getString(PROCESS_URI);
        CharSequence charSequence = browserPackageName;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            Logger.error(methodTag, "No browser package name found in extras - Cannot proceed with browser switch", null);
            this.finish();
            return;
        }
        charSequence = processUri;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            Logger.error(methodTag, "No process URI found in extras - Cannot proceed with browser switch", null);
            this.finish();
            return;
        }
        Logger.info(methodTag, "Launching switch browser request on browser: " + browserPackageName + ", Custom Tabs supported: " + browserSupportsCustomTabs);
        Intent browserIntent = null;
        if (browserSupportsCustomTabs) {
            Logger.info(methodTag, "CustomTabsService is supported.");
            if (!this.customTabsManager.bind((Context)this, browserPackageName)) {
                Logger.warn(methodTag, "Failed to bind CustomTabsService.");
                browserIntent = new Intent("android.intent.action.VIEW");
            } else {
                Intent intent = this.customTabsManager.getCustomTabsIntent().intent;
                Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"customTabsManager.customTabsIntent.intent");
                browserIntent = intent;
            }
        } else {
            Logger.warn(methodTag, "CustomTabsService is NOT supported");
            browserIntent = new Intent("android.intent.action.VIEW");
            browserIntent.setPackage(browserPackageName);
        }
        String $this$toUri$iv = processUri;
        boolean $i$f$toUri = false;
        Uri uri = Uri.parse((String)$this$toUri$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.parse(this)");
        browserIntent.setData(uri);
        this.startActivity(browserIntent);
    }

    protected void onNewIntent(@Nullable Intent intent) {
        String methodTag = TAG + ":onNewIntent";
        super.onNewIntent(intent);
        Logger.info(methodTag, "On new intent received.");
        this.setIntent(intent);
        if (intent != null) {
            if (intent.hasExtra(PROCESS_URI)) {
                Logger.warn(methodTag, "Received new switch browser request while one is already in progress - Restarting browser switch flow");
                this.launchBrowser();
                return;
            }
            if (intent.hasExtra(RESUME_REQUEST)) {
                WebViewAuthorizationFragment.setSwitchBrowserBundle(intent.getExtras());
                Logger.info(methodTag, "Finishing activity and removing from task stack");
                this.finishAndRemoveTask();
                return;
            }
        }
        Logger.info(methodTag, "Unexpected intent - Finishing activity and removing from task stack");
        this.finishAndRemoveTask();
    }

    protected void onResume() {
        super.onResume();
        String methodTag = TAG + ":onResume";
        Logger.info(methodTag, "onResume called - Managing CCT launch state");
        if (this.cctLaunched) {
            Logger.info(methodTag, "CCT was launched previously and user returned - Assuming cancellation, finishing activity");
            this.finishAndRemoveTask();
        } else {
            Logger.info(methodTag, "First resume after onCreate - Marking CCT as launched");
        }
        this.cctLaunched = true;
    }

    protected void onDestroy() {
        super.onDestroy();
        this.customTabsManager.unbind();
    }

    static {
        String string2 = SwitchBrowserActivity.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SwitchBrowserActivity::class.java.simpleName");
        TAG = string2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/microsoft/identity/common/internal/providers/oauth2/SwitchBrowserActivity$Companion;", "", "()V", "BROWSER_PACKAGE_NAME", "", "BROWSER_SUPPORTS_CUSTOM_TABS", "PROCESS_URI", "RESUME_REQUEST", "TAG", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

