/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.webkit.WebView;
import androidx.annotation.UiThread;
import androidx.credentials.CreatePublicKeyCredentialResponse;
import androidx.credentials.GetCredentialResponse;
import androidx.credentials.PublicKeyCredential;
import androidx.webkit.JavaScriptReplyProxy;
import androidx.webkit.WebMessageCompat;
import androidx.webkit.WebViewCompat;
import androidx.webkit.WebViewFeature;
import com.microsoft.identity.common.internal.providers.oauth2.CredentialManagerHandler;
import com.microsoft.identity.common.internal.providers.oauth2.PasskeyReplyChannel;
import com.microsoft.identity.common.internal.providers.oauth2.PasskeyWebListener;
import com.microsoft.identity.common.internal.ui.webview.AzureActiveDirectoryWebViewClient;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.logging.Logger;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J)\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ)\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ0\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J(\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001aH\u0002J\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\b\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010\u001e\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006#"}, d2={"Lcom/microsoft/identity/common/internal/providers/oauth2/PasskeyWebListener;", "Landroidx/webkit/WebViewCompat$WebMessageListener;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "credentialManagerHandler", "Lcom/microsoft/identity/common/internal/providers/oauth2/CredentialManagerHandler;", "(Lkotlinx/coroutines/CoroutineScope;Lcom/microsoft/identity/common/internal/providers/oauth2/CredentialManagerHandler;)V", "havePendingRequest", "Ljava/util/concurrent/atomic/AtomicBoolean;", "handleCreateFlow", "", "message", "", "reply", "Lcom/microsoft/identity/common/internal/providers/oauth2/PasskeyReplyChannel;", "(Lcom/microsoft/identity/common/internal/providers/oauth2/CredentialManagerHandler;Ljava/lang/String;Lcom/microsoft/identity/common/internal/providers/oauth2/PasskeyReplyChannel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleGetFlow", "onPostMessage", "view", "Landroid/webkit/WebView;", "Landroidx/webkit/WebMessageCompat;", "sourceOrigin", "Landroid/net/Uri;", "isMainFrame", "", "replyProxy", "Landroidx/webkit/JavaScriptReplyProxy;", "onRequest", "webAuthNMessage", "Lcom/microsoft/identity/common/internal/providers/oauth2/PasskeyWebListener$WebAuthNMessage;", "javaScriptReplyProxy", "parseMessage", "messageData", "Companion", "WebAuthNMessage", "common_distRelease"})
@SourceDebugExtension(value={"SMAP\nPasskeyWebListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PasskeyWebListener.kt\ncom/microsoft/identity/common/internal/providers/oauth2/PasskeyWebListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,403:1\n1#2:404\n*E\n"})
public final class PasskeyWebListener
implements WebViewCompat.WebMessageListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final CredentialManagerHandler credentialManagerHandler;
    @NotNull
    private final AtomicBoolean havePendingRequest;
    @NotNull
    public static final String TAG = "PasskeyWebListener";
    @NotNull
    public static final String CREATE_UNIQUE_KEY = "create";
    @NotNull
    public static final String GET_UNIQUE_KEY = "get";
    @NotNull
    public static final String TYPE_KEY = "type";
    @NotNull
    public static final String REQUEST_KEY = "request";
    @NotNull
    private static final String INTERFACE_NAME = "__webauthn_interface__";
    @NotNull
    private static final String WEB_AUTHN_INTERFACE_JS_MINIFIED = "\n            var __webauthn_interface__,__webauthn_hooks__;!function(e){__webauthn_interface__.addEventListener(\"message\",(function(e){console.log(e.data);var n=JSON.parse(e.data);\"get\"===n.type?o(n):\"create\"===n.type?l(n):console.log(\"Incorrect response format for reply: \"+n.type)}));var n=null,t=null,r=null,a=null;function o(e){if(null!==n&&null!==r){if(\"success\"!=e.status){var o=r;return n=null,r=null,void o(new DOMException(e.data.domExceptionMessage,e.data.domExceptionName))}var s=u(e.data),i=n;n=null,r=null,i(s)}else console.log(\"Reply failure: Resolve: \"+t+\" and reject: \"+a)}function s(e){var n=e.length%4;return Uint8Array.from(atob(e.replace(/-/g,\"+\").replace(/_/g,\"/\").padEnd(e.length+(0===n?0:4-n),\"=\")),(function(e){return e.charCodeAt(0)})).buffer}function i(e){return btoa(Array.from(new Uint8Array(e),(function(e){return String.fromCharCode(e)})).join(\"\")).replace(/\\+/g,\"-\").replace(/\\//g,\"_\").replace(/=+$/,\"\")}function l(e){if(null!==t&&null!==a){if(\"success\"!=e.status){var n=a;return t=null,a=null,void n(new DOMException(e.data.domExceptionMessage,e.data.domExceptionName))}var r=u(e.data),o=t;t=null,a=null,o(r)}else console.log(\"Reply failure: Resolve: \"+t+\" and reject: \"+a)}function u(e){return e.rawId=s(e.rawId),e.response.clientDataJSON=s(e.response.clientDataJSON),e.response.hasOwnProperty(\"attestationObject\")&&(e.response.attestationObject=s(e.response.attestationObject)),e.response.hasOwnProperty(\"authenticatorData\")&&(e.response.authenticatorData=s(e.response.authenticatorData)),e.response.hasOwnProperty(\"signature\")&&(e.response.signature=s(e.response.signature)),e.response.hasOwnProperty(\"userHandle\")&&(e.response.userHandle=s(e.response.userHandle)),e.getClientExtensionResults=function(){return{}},e.response.getTransports=function(){return e.response.hasOwnProperty(\"transports\")?e.response.transports:[]},e}e.create=function(n){if(!(\"publicKey\"in n))return e.originalCreateFunction(n);var r=new Promise((function(e,n){t=e,a=n})),o=n.publicKey;if(o.hasOwnProperty(\"challenge\")){var s=i(o.challenge);o.challenge=s}if(o.hasOwnProperty(\"user\")&&o.user.hasOwnProperty(\"id\")){var l=i(o.user.id);o.user.id=l}if(o.hasOwnProperty(\"excludeCredentials\")&&Array.isArray(o.excludeCredentials)&&o.excludeCredentials.length>0)for(var u=0;u<o.excludeCredentials.length;u++){var c=o.excludeCredentials[u];c&&c.hasOwnProperty(\"id\")&&(c.id=i(c.id))}var p={type:\"create\",request:o},_=JSON.stringify(p);return __webauthn_interface__.postMessage(_),r},e.get=function(t){if(!(\"publicKey\"in t))return e.originalGetFunction(t);var a=new Promise((function(e,t){n=e,r=t})),o=t.publicKey;if(o.hasOwnProperty(\"challenge\")){var s=i(o.challenge);o.challenge=s}var l={type:\"get\",request:o},u=JSON.stringify(l);return __webauthn_interface__.postMessage(u),a},e.onReplyGet=o,e.CM_base64url_decode=s,e.CM_base64url_encode=i,e.onReplyCreate=l}(__webauthn_hooks__||(__webauthn_hooks__={})),__webauthn_hooks__.originalGetFunction=navigator.credentials.get,__webauthn_hooks__.originalCreateFunction=navigator.credentials.create,navigator.credentials.get=__webauthn_hooks__.get,navigator.credentials.create=__webauthn_hooks__.create,window.PublicKeyCredential=function(){},window.PublicKeyCredential.isUserVerifyingPlatformAuthenticatorAvailable=function(){return Promise.resolve(!0)};\n         ";
    @NotNull
    private static final Set<String> ALLOWED_ORIGIN_RULES_PRODUCTION;
    @NotNull
    private static final Set<String> ALLOWED_ORIGIN_PRE_PRODUCTION;

    public PasskeyWebListener(@NotNull CoroutineScope coroutineScope, @NotNull CredentialManagerHandler credentialManagerHandler) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)credentialManagerHandler, (String)"credentialManagerHandler");
        this.coroutineScope = coroutineScope;
        this.credentialManagerHandler = credentialManagerHandler;
        this.havePendingRequest = new AtomicBoolean(false);
    }

    @UiThread
    public void onPostMessage(@NotNull WebView view, @NotNull WebMessageCompat message, @NotNull Uri sourceOrigin, boolean isMainFrame, @NotNull JavaScriptReplyProxy replyProxy) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)sourceOrigin, (String)"sourceOrigin");
            Intrinsics.checkNotNullParameter((Object)replyProxy, (String)"replyProxy");
            WebAuthNMessage webAuthNMessage = this.parseMessage(message.getData(), replyProxy);
            if (webAuthNMessage == null) break block0;
            WebAuthNMessage webAuthNMessage2 = webAuthNMessage;
            boolean bl = false;
            this.onRequest(webAuthNMessage2, sourceOrigin, isMainFrame, replyProxy);
        }
    }

    private final void onRequest(WebAuthNMessage webAuthNMessage, Uri sourceOrigin, boolean isMainFrame, JavaScriptReplyProxy javaScriptReplyProxy) {
        String methodTag = "PasskeyWebListener:onRequest";
        Logger.info(methodTag, "Received WebAuthN request of type: " + webAuthNMessage.getType() + " from origin: " + sourceOrigin);
        PasskeyReplyChannel passkeyReplyChannel = new PasskeyReplyChannel(javaScriptReplyProxy, webAuthNMessage.getType(), null, 4, null);
        if (this.havePendingRequest.get()) {
            passkeyReplyChannel.postError(new ClientException("request_in_progress", "A WebAuthN request is already in progress."));
            return;
        }
        this.havePendingRequest.set(true);
        if (!isMainFrame) {
            passkeyReplyChannel.postError(new ClientException("unsupported_operation", "WebAuthN requests from iframes are not supported."));
            this.havePendingRequest.set(false);
            return;
        }
        String string2 = webAuthNMessage.getType();
        if (Intrinsics.areEqual((Object)string2, (Object)CREATE_UNIQUE_KEY)) {
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, webAuthNMessage, passkeyReplyChannel, null){
                int label;
                final /* synthetic */ PasskeyWebListener this$0;
                final /* synthetic */ WebAuthNMessage $webAuthNMessage;
                final /* synthetic */ PasskeyReplyChannel $passkeyReplyChannel;
                {
                    this.this$0 = $receiver;
                    this.$webAuthNMessage = $webAuthNMessage;
                    this.$passkeyReplyChannel = $passkeyReplyChannel;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = PasskeyWebListener.access$handleCreateFlow(this.this$0, PasskeyWebListener.access$getCredentialManagerHandler$p(this.this$0), this.$webAuthNMessage.getRequest(), this.$passkeyReplyChannel, (Continuation)this);
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            PasskeyWebListener.access$getHavePendingRequest$p(this.this$0).set(false);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else if (Intrinsics.areEqual((Object)string2, (Object)GET_UNIQUE_KEY)) {
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, webAuthNMessage, passkeyReplyChannel, null){
                int label;
                final /* synthetic */ PasskeyWebListener this$0;
                final /* synthetic */ WebAuthNMessage $webAuthNMessage;
                final /* synthetic */ PasskeyReplyChannel $passkeyReplyChannel;
                {
                    this.this$0 = $receiver;
                    this.$webAuthNMessage = $webAuthNMessage;
                    this.$passkeyReplyChannel = $passkeyReplyChannel;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = PasskeyWebListener.access$handleGetFlow(this.this$0, PasskeyWebListener.access$getCredentialManagerHandler$p(this.this$0), this.$webAuthNMessage.getRequest(), this.$passkeyReplyChannel, (Continuation)this);
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            PasskeyWebListener.access$getHavePendingRequest$p(this.this$0).set(false);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else {
            passkeyReplyChannel.postError(new ClientException("unsupported_operation", "Unsupported WebAuthN request type: " + webAuthNMessage.getType()));
            this.havePendingRequest.set(false);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleGetFlow(CredentialManagerHandler var1_1, String var2_2, PasskeyReplyChannel var3_3, Continuation<? super Unit> var4_4) {
        if (!(var4_4 instanceof handleGetFlow.1)) ** GOTO lbl-1000
        var11_5 = var4_4;
        if ((var11_5.label & -2147483648) != 0) {
            var11_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ PasskeyWebListener this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PasskeyWebListener.access$handleGetFlow(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_8 = this;
                $i$a$-runCatching-PasskeyWebListener$handleGetFlow$2 = false;
                $continuation.L$0 = reply;
                $continuation.label = 1;
                v0 = credentialManagerHandler.getPasskey((String)message, (Continuation<? super GetCredentialResponse>)$continuation);
                ** if (v0 != var12_7) goto lbl23
lbl22:
                // 1 sources

                return var12_7;
lbl23:
                // 1 sources

                ** GOTO lbl31
            }
            case 1: {
                $i$a$-runCatching-PasskeyWebListener$handleGetFlow$2 = false;
                reply = (PasskeyReplyChannel)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl31:
                    // 2 sources

                    var6_12 = Result.constructor-impl((Object)((GetCredentialResponse)v0));
                }
                catch (Throwable $i$a$-runCatching-PasskeyWebListener$handleGetFlow$2) {
                    var6_12 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-PasskeyWebListener$handleGetFlow$2));
                }
                var5_8 = var6_12;
                if (Result.isSuccess-impl((Object)var5_8)) {
                    credentialResponse = (GetCredentialResponse)var5_8;
                    $i$a$-onSuccess-PasskeyWebListener$handleGetFlow$3 = false;
                    var8_13 = credentialResponse.getCredential();
                    v1 = publicKeyCredential = var8_13 instanceof PublicKeyCredential != false ? (PublicKeyCredential)var8_13 : null;
                    if (publicKeyCredential != null) {
                        reply.postSuccess(publicKeyCredential.getAuthenticationResponseJson());
                    } else {
                        reply.postError(new ClientException("unsupported_operation", "Retrieved credential is not a PublicKeyCredential."));
                    }
                }
                v2 = Result.exceptionOrNull-impl((Object)var5_8);
                if (v2 != null) {
                    throwable = var6_12 = v2;
                    $i$a$-onFailure-PasskeyWebListener$handleGetFlow$4 = false;
                    reply.postError((Throwable)throwable);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleCreateFlow(CredentialManagerHandler var1_1, String var2_2, PasskeyReplyChannel var3_3, Continuation<? super Unit> var4_4) {
        if (!(var4_4 instanceof handleCreateFlow.1)) ** GOTO lbl-1000
        var10_5 = var4_4;
        if ((var10_5.label & -2147483648) != 0) {
            var10_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ PasskeyWebListener this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PasskeyWebListener.access$handleCreateFlow(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_8 = this;
                $i$a$-runCatching-PasskeyWebListener$handleCreateFlow$2 = false;
                $continuation.L$0 = reply;
                $continuation.label = 1;
                v0 = credentialManagerHandler.createPasskey((String)message, (Continuation<? super CreatePublicKeyCredentialResponse>)$continuation);
                ** if (v0 != var11_7) goto lbl23
lbl22:
                // 1 sources

                return var11_7;
lbl23:
                // 1 sources

                ** GOTO lbl31
            }
            case 1: {
                $i$a$-runCatching-PasskeyWebListener$handleCreateFlow$2 = false;
                reply = (PasskeyReplyChannel)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl31:
                    // 2 sources

                    var6_12 = Result.constructor-impl((Object)((CreatePublicKeyCredentialResponse)v0));
                }
                catch (Throwable $i$a$-runCatching-PasskeyWebListener$handleCreateFlow$2) {
                    var6_12 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-PasskeyWebListener$handleCreateFlow$2));
                }
                var5_8 = var6_12;
                if (Result.isSuccess-impl((Object)var5_8)) {
                    createCredentialResponse = (CreatePublicKeyCredentialResponse)var5_8;
                    $i$a$-onSuccess-PasskeyWebListener$handleCreateFlow$3 = false;
                    reply.postSuccess(createCredentialResponse.getRegistrationResponseJson());
                }
                v1 = Result.exceptionOrNull-impl((Object)var5_8);
                if (v1 != null) {
                    throwable = var6_12 = v1;
                    $i$a$-onFailure-PasskeyWebListener$handleCreateFlow$4 = false;
                    reply.postError((Throwable)throwable);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final WebAuthNMessage parseMessage(String messageData, JavaScriptReplyProxy javaScriptReplyProxy) {
        Object object;
        block5: {
            Object object2;
            PasskeyReplyChannel passkeyReplyChannel = new PasskeyReplyChannel(javaScriptReplyProxy, null, null, 6, null);
            object = this;
            try {
                String request;
                String string2;
                String string3;
                PasskeyWebListener $this$parseMessage_u24lambda_u249 = object;
                boolean bl = false;
                CharSequence charSequence = messageData;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    throw new ClientException("missing_parameter", "Message data is null or blank");
                }
                JSONObject json = new JSONObject(messageData);
                String it = string3 = json.optString(TYPE_KEY);
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                String type = !StringsKt.isBlank((CharSequence)it) ? string3 : null;
                String it2 = string2 = json.optString(REQUEST_KEY);
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                String string4 = request = !StringsKt.isBlank((CharSequence)it2) ? string2 : null;
                if (type == null) {
                    throw new ClientException("missing_parameter", "Missing required key: type");
                }
                if (request == null) {
                    throw new ClientException("missing_parameter", "Missing required key: request");
                }
                object2 = Result.constructor-impl((Object)new WebAuthNMessage(type, request));
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block5;
            Object throwable2 = object2 = throwable;
            boolean bl = false;
            passkeyReplyChannel.postError((Throwable)throwable2);
        }
        return (WebAuthNMessage)(Result.isFailure-impl((Object)object) ? null : object);
    }

    @JvmStatic
    public static final boolean hook(@NotNull WebView webView, @NotNull Activity activity, @NotNull AzureActiveDirectoryWebViewClient webClient) {
        return Companion.hook(webView, activity, webClient);
    }

    public static final /* synthetic */ Object access$handleCreateFlow(PasskeyWebListener $this, CredentialManagerHandler credentialManagerHandler, String message, PasskeyReplyChannel reply, Continuation $completion) {
        return $this.handleCreateFlow(credentialManagerHandler, message, reply, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ CredentialManagerHandler access$getCredentialManagerHandler$p(PasskeyWebListener $this) {
        return $this.credentialManagerHandler;
    }

    public static final /* synthetic */ AtomicBoolean access$getHavePendingRequest$p(PasskeyWebListener $this) {
        return $this.havePendingRequest;
    }

    public static final /* synthetic */ Object access$handleGetFlow(PasskeyWebListener $this, CredentialManagerHandler credentialManagerHandler, String message, PasskeyReplyChannel reply, Continuation $completion) {
        return $this.handleGetFlow(credentialManagerHandler, message, reply, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Set access$getALLOWED_ORIGIN_PRE_PRODUCTION$cp() {
        return ALLOWED_ORIGIN_PRE_PRODUCTION;
    }

    static {
        Object[] objectArray = new String[]{"https://login.microsoft.com", "https://account.live.com", "https://mysignins.microsoft.com", "https://mysignins.azure.us", "https://mysignins.microsoft.scloud", "https://mysignins.eaglex.ic.gov", "https://login.microsoftonline.us", "https://login.microsoftonline.microsoft.scloud", "https://login.microsoftonline.eaglex.ic.gov"};
        ALLOWED_ORIGIN_RULES_PRODUCTION = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"https://account.live-int.com", "https://login.windows-ppe.net", "https://mysignins-ppe.microsoft.com"};
        ALLOWED_ORIGIN_PRE_PRODUCTION = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/microsoft/identity/common/internal/providers/oauth2/PasskeyWebListener$WebAuthNMessage;", "", "type", "", "request", "(Ljava/lang/String;Ljava/lang/String;)V", "getRequest", "()Ljava/lang/String;", "getType", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "common_distRelease"})
    private static final class WebAuthNMessage {
        @NotNull
        private final String type;
        @NotNull
        private final String request;

        public WebAuthNMessage(@NotNull String type, @NotNull String request) {
            Intrinsics.checkNotNullParameter((Object)type, (String)PasskeyWebListener.TYPE_KEY);
            Intrinsics.checkNotNullParameter((Object)request, (String)PasskeyWebListener.REQUEST_KEY);
            this.type = type;
            this.request = request;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final String getRequest() {
            return this.request;
        }

        @NotNull
        public final String component1() {
            return this.type;
        }

        @NotNull
        public final String component2() {
            return this.request;
        }

        @NotNull
        public final WebAuthNMessage copy(@NotNull String type, @NotNull String request) {
            Intrinsics.checkNotNullParameter((Object)type, (String)PasskeyWebListener.TYPE_KEY);
            Intrinsics.checkNotNullParameter((Object)request, (String)PasskeyWebListener.REQUEST_KEY);
            return new WebAuthNMessage(type, request);
        }

        public static /* synthetic */ WebAuthNMessage copy$default(WebAuthNMessage webAuthNMessage, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = webAuthNMessage.type;
            }
            if ((n & 2) != 0) {
                string3 = webAuthNMessage.request;
            }
            return webAuthNMessage.copy(string2, string3);
        }

        @NotNull
        public String toString() {
            return "WebAuthNMessage(type=" + this.type + ", request=" + this.request + ')';
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + this.request.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WebAuthNMessage)) {
                return false;
            }
            WebAuthNMessage webAuthNMessage = (WebAuthNMessage)other;
            if (!Intrinsics.areEqual((Object)this.type, (Object)webAuthNMessage.type)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.request, (Object)webAuthNMessage.request);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/microsoft/identity/common/internal/providers/oauth2/PasskeyWebListener$Companion;", "", "()V", "ALLOWED_ORIGIN_PRE_PRODUCTION", "", "", "ALLOWED_ORIGIN_RULES_PRODUCTION", "CREATE_UNIQUE_KEY", "GET_UNIQUE_KEY", "INTERFACE_NAME", "REQUEST_KEY", "TAG", "TYPE_KEY", "WEB_AUTHN_INTERFACE_JS_MINIFIED", "getAllowedOriginRules", "hook", "", "webView", "Landroid/webkit/WebView;", "activity", "Landroid/app/Activity;", "webClient", "Lcom/microsoft/identity/common/internal/ui/webview/AzureActiveDirectoryWebViewClient;", "loadJsBridgeScript", "context", "Landroid/content/Context;", "common_distRelease"})
    @SourceDebugExtension(value={"SMAP\nPasskeyWebListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PasskeyWebListener.kt\ncom/microsoft/identity/common/internal/providers/oauth2/PasskeyWebListener$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,403:1\n1#2:404\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Set<String> getAllowedOriginRules() {
            Set mutableSet = CollectionsKt.toMutableSet((Iterable)ALLOWED_ORIGIN_RULES_PRODUCTION);
            return CollectionsKt.toSet((Iterable)mutableSet);
        }

        @JvmStatic
        public final boolean hook(@NotNull WebView webView, @NotNull Activity activity, @NotNull AzureActiveDirectoryWebViewClient webClient) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Intrinsics.checkNotNullParameter((Object)((Object)webClient), (String)"webClient");
            String methodTag = "PasskeyWebListener:hook";
            if (Build.VERSION.SDK_INT < 28) {
                Logger.warn(methodTag, "Passkey functionality requires Android 9 (Pie) or higher. Current version: " + Build.VERSION.SDK_INT);
                return false;
            }
            if (WebViewFeature.isFeatureSupported((String)"WEB_MESSAGE_LISTENER")) {
                Logger.verbose(methodTag, "WEB_MESSAGE_LISTENER is supported on this WebView.");
                WebViewCompat.addWebMessageListener((WebView)webView, (String)PasskeyWebListener.INTERFACE_NAME, this.getAllowedOriginRules(), (WebViewCompat.WebMessageListener)new PasskeyWebListener(CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault())), new CredentialManagerHandler(activity)));
                Logger.info(methodTag, "PasskeyWebListener successfully hooked into WebView.");
                String scriptToInject = PasskeyWebListener.WEB_AUTHN_INTERFACE_JS_MINIFIED;
                webClient.addOnPageStartedScript(PasskeyWebListener.TAG, scriptToInject, this.getAllowedOriginRules());
                bl = true;
            } else {
                Logger.warn(methodTag, "WEB_MESSAGE_LISTENER not supported on this device/WebView.");
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String loadJsBridgeScript(Context context) {
            Object object;
            try {
                InputStream inputStream = context.getAssets().open("js-bridge.js");
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"context.assets.open(\"js-bridge.js\")");
                object = inputStream;
                Object object2 = Charsets.UTF_8;
                Object object3 = new InputStreamReader((InputStream)object, (Charset)object2);
                int n = 8192;
                object = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
                object2 = null;
                try {
                    BufferedReader it = (BufferedReader)object;
                    boolean bl = false;
                    object3 = TextStreamsKt.readText((Reader)it);
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                }
                object = object3;
            }
            catch (Exception e) {
                Logger.warn(PasskeyWebListener.TAG, "Failed to load js-bridge.js from assets, falling back to minified version: " + e.getMessage());
                object = PasskeyWebListener.WEB_AUTHN_INTERFACE_JS_MINIFIED;
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

