/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.platform.AbstractDeviceMetadata;
import lombok.NonNull;

public class AndroidDeviceMetadata
extends AbstractDeviceMetadata {
    private static final String ANDROID_DEVICE_TYPE = "Android";
    private static final String DEVICE_TYPE = "DeviceType";
    private static final String TAG = AndroidDeviceMetadata.class.getSimpleName();
    private static final String MOBILE_DEVICE = "mobileDevice";
    private static final String UNKNOWN_DEVICE = "unknown";

    @NonNull
    public String getDeviceType() {
        return ANDROID_DEVICE_TYPE;
    }

    @NonNull
    public String getCpu() {
        if (Build.VERSION.SDK_INT < 21) {
            return Build.CPU_ABI;
        }
        String[] supportedABIs = Build.SUPPORTED_ABIS;
        if (supportedABIs != null && supportedABIs.length > 0) {
            return supportedABIs[0];
        }
        return "UNKNOWN";
    }

    @NonNull
    public String getOsForEsts() {
        return String.valueOf(Build.VERSION.SDK_INT);
    }

    @NonNull
    public String getOsForMats() {
        return this.getAndroidReleaseOs();
    }

    @NonNull
    public String getOsForDrs() {
        return this.getAndroidReleaseOs();
    }

    @NonNull
    public String getAndroidReleaseOs() {
        return Build.VERSION.RELEASE;
    }

    @NonNull
    public String getDeviceModel() {
        return Build.MODEL;
    }

    @NonNull
    public String getManufacturer() {
        return Build.MANUFACTURER;
    }

    public static String getAndroidDeviceTypeFromMetadata(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        String methodTag = TAG + " :getDeviceType";
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            Bundle metaDataBundle = appInfo.metaData;
            String deviceType = metaDataBundle.getString(DEVICE_TYPE, MOBILE_DEVICE);
            Logger.verbose((String)methodTag, (String)("Setting the deviceType as " + deviceType));
            return deviceType;
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.warn((String)methodTag, (String)"Unable to find the app's package name from PackageManager.");
            return UNKNOWN_DEVICE;
        }
    }
}

