/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.util.Base64;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.logging.Logger;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Set;

public class PackageHelper {
    private static final String TAG = "CallerInfo";
    private static final String DIGEST_SHA_512 = "SHA-512";
    private final PackageManager mPackageManager;

    public PackageHelper(PackageManager packageManager) {
        this.mPackageManager = packageManager;
    }

    public PackageHelper(Context context) {
        this.mPackageManager = context.getPackageManager();
    }

    public String getSha1SignatureForPackage(String packageName) {
        String methodTag = "CallerInfo:getSha1SignatureForPackage";
        try {
            return PackageHelper.getSigningCertificateThumbprintForPackage(PackageHelper.getPackageInfo(this.mPackageManager, packageName), false);
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.error("CallerInfo:getSha1SignatureForPackage", "Calling App's package does not exist in PackageManager. ", "", e);
            return null;
        }
    }

    public String getSha512SignatureForPackage(String packageName) {
        String methodTag = "CallerInfo:getSha512SignatureForPackage";
        try {
            return PackageHelper.getSigningCertificateThumbprintForPackage(PackageHelper.getPackageInfo(this.mPackageManager, packageName), true);
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.error("CallerInfo:getSha512SignatureForPackage", "Calling App's package does not exist in PackageManager. ", "", e);
            return null;
        }
    }

    private static String getSigningCertificateThumbprintForPackage(PackageInfo packageInfo, boolean useSha512) {
        String methodTag = "CallerInfo:getSigningCertificateThumbprintForPackage";
        try {
            Signature[] signatures = PackageHelper.getSignatures(packageInfo);
            if (signatures != null && signatures.length > 0) {
                Signature signature = signatures[0];
                MessageDigest md = MessageDigest.getInstance(useSha512 ? DIGEST_SHA_512 : "SHA");
                md.update(signature.toByteArray());
                return Base64.encodeToString((byte[])md.digest(), (int)2);
            }
        }
        catch (NoSuchAlgorithmException e) {
            Logger.error("CallerInfo:getSigningCertificateThumbprintForPackage", "Digest SHA algorithm does not exists. ", "", e);
        }
        return null;
    }

    public int getUIDForPackage(String packageName) {
        String methodTag = "CallerInfo:getUIDForPackage";
        int callingUID = 0;
        try {
            ApplicationInfo info = this.mPackageManager.getApplicationInfo(packageName, 0);
            if (info != null) {
                callingUID = info.uid;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.error("CallerInfo:getUIDForPackage", "Package is not found. ", "Package name: " + packageName, e);
        }
        return callingUID;
    }

    public boolean isPackageInstalledAndEnabled(String packageName) {
        String methodTag = "CallerInfo:isPackageInstalledAndEnabled";
        boolean enabled = false;
        try {
            ApplicationInfo applicationInfo = this.mPackageManager.getApplicationInfo(packageName, 0);
            if (applicationInfo != null) {
                enabled = applicationInfo.enabled;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.verbose("CallerInfo:isPackageInstalledAndEnabled", packageName + " is not found");
        }
        Logger.verbose("CallerInfo:isPackageInstalledAndEnabled", packageName + " is installed. enabled? [" + enabled + "]");
        return enabled;
    }

    public static String getBrokerRedirectUri(Context context, String packageName) {
        PackageHelper info = new PackageHelper(context.getPackageManager());
        String signatureDigest = info.getSha1SignatureForPackage(packageName);
        return PackageHelper.getBrokerRedirectUrl(packageName, signatureDigest);
    }

    public static String getBrokerRedirectUrl(String packageName, String signatureDigest) {
        String methodTag = "CallerInfo:getBrokerRedirectUrl";
        if (!StringExtensions.isNullOrBlank(packageName) && !StringExtensions.isNullOrBlank(signatureDigest)) {
            try {
                return String.format("%s://%s/%s", "msauth", URLEncoder.encode(packageName, "UTF-8"), URLEncoder.encode(signatureDigest, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                Logger.error("CallerInfo:getBrokerRedirectUrl", "", "Encoding is not supported", e);
            }
        }
        return "";
    }

    public static Signature[] getSignatures(PackageInfo packageInfo) {
        if (packageInfo == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 28) {
            if (packageInfo.signingInfo == null) {
                return null;
            }
            if (packageInfo.signingInfo.hasMultipleSigners()) {
                return packageInfo.signingInfo.getApkContentsSigners();
            }
            return packageInfo.signingInfo.getSigningCertificateHistory();
        }
        return packageInfo.signatures;
    }

    @NonNull
    public static Set<String> generateSignatureHashes(PackageInfo packageInfo) {
        HashSet<String> signatureHashes = new HashSet<String>();
        for (Signature signature : PackageHelper.getSignatures(packageInfo)) {
            try {
                MessageDigest digest = MessageDigest.getInstance(DIGEST_SHA_512);
                byte[] hashBytes = digest.digest(signature.toByteArray());
                signatureHashes.add(Base64.encodeToString((byte[])hashBytes, (int)10));
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("Platform does not supportSHA-512 hashing");
            }
        }
        return signatureHashes;
    }

    public static int getPackageManagerSignaturesFlag() {
        if (Build.VERSION.SDK_INT >= 28) {
            return 0x8000000;
        }
        return 64;
    }

    public static PackageInfo getPackageInfo(@NonNull PackageManager packageManager, @NonNull String packageName) throws PackageManager.NameNotFoundException {
        return packageManager.getPackageInfo(packageName, PackageHelper.getPackageManagerSignaturesFlag());
    }

    public static Signature[] getSignatures(@NonNull Context context) throws PackageManager.NameNotFoundException {
        return PackageHelper.getSignatures(PackageHelper.getPackageInfo(context.getPackageManager(), context.getPackageName()));
    }

    public boolean verifyIfValidTeamsPackage(String packageName) {
        String currentSignatureForTeamsApp;
        return packageName.equals("com.microsoft.skype.teams.ipphone") && this.isPackageInstalledAndEnabled("com.microsoft.skype.teams.ipphone") && ("iPULpH0pq8ms1Qy7cOzGsVRQN7/zW4IbW+UKcajvtrTrzM5o5VcaghNEA1Ho4Wq7ay0efqqJcalxa8eHxVnHKA==".equals(currentSignatureForTeamsApp = this.getSha512SignatureForPackage("com.microsoft.skype.teams.ipphone")) || "FOoI98kyj+dXPZYW191TjF6017ljKj47G+RCQPYjIcXD7uhhTpw7pqznTABB0ZjB1/DZetRgr284pyLumvXN6A==".equals(currentSignatureForTeamsApp));
    }
}

