/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.crypto.wrappedsecretkey;

import com.microsoft.identity.common.crypto.wrappedsecretkey.WrappedSecretKeySerializerManager;
import com.microsoft.identity.common.java.flighting.CommonFlight;
import com.microsoft.identity.common.java.flighting.CommonFlightsManager;
import com.microsoft.identity.common.java.flighting.IFlightConfig;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/microsoft/identity/common/crypto/wrappedsecretkey/WrappedSecretKey;", "", "wrappedKeyData", "", "algorithm", "", "cipherTransformation", "([BLjava/lang/String;Ljava/lang/String;)V", "getAlgorithm", "()Ljava/lang/String;", "getCipherTransformation", "getWrappedKeyData", "()[B", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "serialize", "toString", "Companion", "common_distRelease"})
public final class WrappedSecretKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] wrappedKeyData;
    @NotNull
    private final String algorithm;
    @NotNull
    private final String cipherTransformation;

    public WrappedSecretKey(@NotNull byte[] wrappedKeyData, @NotNull String algorithm, @NotNull String cipherTransformation) {
        Intrinsics.checkNotNullParameter((Object)wrappedKeyData, (String)"wrappedKeyData");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)cipherTransformation, (String)"cipherTransformation");
        this.wrappedKeyData = wrappedKeyData;
        this.algorithm = algorithm;
        this.cipherTransformation = cipherTransformation;
    }

    @NotNull
    public final byte[] getWrappedKeyData() {
        return this.wrappedKeyData;
    }

    @NotNull
    public final String getAlgorithm() {
        return this.algorithm;
    }

    @NotNull
    public final String getCipherTransformation() {
        return this.cipherTransformation;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.microsoft.identity.common.crypto.wrappedsecretkey.WrappedSecretKey");
        WrappedSecretKey cfr_ignored_0 = (WrappedSecretKey)other;
        if (!Arrays.equals(this.wrappedKeyData, ((WrappedSecretKey)other).wrappedKeyData)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.algorithm, (Object)((WrappedSecretKey)other).algorithm)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.cipherTransformation, (Object)((WrappedSecretKey)other).cipherTransformation);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.wrappedKeyData);
        result = 31 * result + this.algorithm.hashCode();
        result = 31 * result + this.cipherTransformation.hashCode();
        return result;
    }

    @NotNull
    public final byte[] serialize() {
        int serializerId = CommonFlightsManager.INSTANCE.getFlightsProvider().getIntValue((IFlightConfig)CommonFlight.WRAPPED_SECRET_KEY_SERIALIZER_VERSION);
        return WrappedSecretKeySerializerManager.INSTANCE.getSerializer(serializerId).serialize(this);
    }

    @NotNull
    public final byte[] component1() {
        return this.wrappedKeyData;
    }

    @NotNull
    public final String component2() {
        return this.algorithm;
    }

    @NotNull
    public final String component3() {
        return this.cipherTransformation;
    }

    @NotNull
    public final WrappedSecretKey copy(@NotNull byte[] wrappedKeyData, @NotNull String algorithm, @NotNull String cipherTransformation) {
        Intrinsics.checkNotNullParameter((Object)wrappedKeyData, (String)"wrappedKeyData");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)cipherTransformation, (String)"cipherTransformation");
        return new WrappedSecretKey(wrappedKeyData, algorithm, cipherTransformation);
    }

    public static /* synthetic */ WrappedSecretKey copy$default(WrappedSecretKey wrappedSecretKey, byte[] byArray, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            byArray = wrappedSecretKey.wrappedKeyData;
        }
        if ((n & 2) != 0) {
            string = wrappedSecretKey.algorithm;
        }
        if ((n & 4) != 0) {
            string2 = wrappedSecretKey.cipherTransformation;
        }
        return wrappedSecretKey.copy(byArray, string, string2);
    }

    @NotNull
    public String toString() {
        return "WrappedSecretKey(wrappedKeyData=" + Arrays.toString(this.wrappedKeyData) + ", algorithm=" + this.algorithm + ", cipherTransformation=" + this.cipherTransformation + ')';
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/microsoft/identity/common/crypto/wrappedsecretkey/WrappedSecretKey$Companion;", "", "()V", "deserialize", "Lcom/microsoft/identity/common/crypto/wrappedsecretkey/WrappedSecretKey;", "data", "", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WrappedSecretKey deserialize(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            int serializerId = WrappedSecretKeySerializerManager.INSTANCE.identifySerializer(data);
            return WrappedSecretKeySerializerManager.INSTANCE.getSerializer(serializerId).deserialize(data);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

