/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.components;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.microsoft.identity.common.components.AndroidClockSkewManager;
import com.microsoft.identity.common.components.AndroidPopManagerSupplier;
import com.microsoft.identity.common.components.AndroidStorageSupplier;
import com.microsoft.identity.common.crypto.AndroidAuthSdkStorageEncryptionManager;
import com.microsoft.identity.common.internal.net.cache.HttpCache;
import com.microsoft.identity.common.internal.platform.AndroidBroadcaster;
import com.microsoft.identity.common.internal.platform.AndroidDeviceMetadata;
import com.microsoft.identity.common.internal.platform.AndroidPlatformUtil;
import com.microsoft.identity.common.internal.providers.oauth2.AndroidTaskStateGenerator;
import com.microsoft.identity.common.internal.ui.AndroidAuthorizationStrategyFactory;
import com.microsoft.identity.common.internal.ui.browser.AndroidBrowserSelector;
import com.microsoft.identity.common.internal.util.WorkProfileUtil;
import com.microsoft.identity.common.java.browser.IBrowserSelector;
import com.microsoft.identity.common.java.flighting.CommonFlight;
import com.microsoft.identity.common.java.flighting.CommonFlightsManager;
import com.microsoft.identity.common.java.flighting.IFlightConfig;
import com.microsoft.identity.common.java.interfaces.IHttpClientWrapper;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.interfaces.IPopManagerSupplier;
import com.microsoft.identity.common.java.interfaces.IStorageSupplier;
import com.microsoft.identity.common.java.interfaces.PlatformComponents;
import com.microsoft.identity.common.java.net.DefaultHttpClientWrapper;
import com.microsoft.identity.common.java.platform.Device;
import com.microsoft.identity.common.java.platform.IDeviceMetadata;
import com.microsoft.identity.common.java.providers.oauth2.IStateGenerator;
import com.microsoft.identity.common.java.strategies.IAuthorizationStrategyFactory;
import com.microsoft.identity.common.java.util.IBroadcaster;
import com.microsoft.identity.common.java.util.IClockSkewManager;
import com.microsoft.identity.common.java.util.IPlatformUtil;
import com.microsoft.identity.common.logging.Logger;
import java.io.File;
import lombok.NonNull;

public class AndroidPlatformComponentsFactory {
    private static final String TAG = AndroidPlatformComponentsFactory.class.getSimpleName();
    private static boolean sGlobalStateInitalized = false;

    public static synchronized void initializeGlobalStates(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        String methodTag = TAG + ":initializeGlobalStates";
        if (!sGlobalStateInitalized) {
            HttpCache.initialize(context);
            Device.setDeviceMetadata((IDeviceMetadata)new AndroidDeviceMetadata());
            if (CommonFlightsManager.INSTANCE.getFlightsProvider().isFlightEnabled((IFlightConfig)CommonFlight.ENABLE_AM_API_WORKPROFILE_EXTRA_QUERY_PARAMETERS)) {
                Device.setIsInPersonalProfileButClouddpcWorkProfileAvailable((Boolean)WorkProfileUtil.checkIfIsInPersonalProfileButClouddpcWorkProfileAvailable(context));
            }
            Logger.setAndroidLogger();
            File cacheDir = context.getCacheDir();
            if (cacheDir != null) {
                HttpCache.initialize(cacheDir);
            } else {
                Logger.warn(methodTag, "Http caching is not enabled because the cache dir is null");
            }
            sGlobalStateInitalized = true;
        }
    }

    public static IPlatformComponents createFromContext(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        return AndroidPlatformComponentsFactory.create(context, null, null);
    }

    public static IPlatformComponents createFromActivity(@NonNull Activity activity, @Nullable Fragment fragment) {
        if (activity == null) {
            throw new NullPointerException("activity is marked non-null but is null");
        }
        return AndroidPlatformComponentsFactory.create(activity.getApplicationContext(), activity, fragment);
    }

    private static IPlatformComponents create(@NonNull Context context, @Nullable Activity activity, @Nullable Fragment fragment) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        AndroidPlatformComponentsFactory.initializeGlobalStates(context);
        PlatformComponents.PlatformComponentsBuilder builder = PlatformComponents.builder();
        AndroidPlatformComponentsFactory.fillBuilderWithBasicImplementations(builder, context, activity, fragment);
        return builder.build();
    }

    public static void fillBuilderWithBasicImplementations(@NonNull PlatformComponents.PlatformComponentsBuilder builder, @NonNull Context context, @Nullable Activity activity, @Nullable Fragment fragment) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        builder.clockSkewManager((IClockSkewManager)new AndroidClockSkewManager(context)).broadcaster((IBroadcaster)new AndroidBroadcaster(context)).popManagerLoader((IPopManagerSupplier)new AndroidPopManagerSupplier(context)).storageSupplier((IStorageSupplier)new AndroidStorageSupplier(context, new AndroidAuthSdkStorageEncryptionManager(context))).platformUtil((IPlatformUtil)new AndroidPlatformUtil(context, activity)).httpClientWrapper((IHttpClientWrapper)new DefaultHttpClientWrapper()).browserSelector((IBrowserSelector)new AndroidBrowserSelector(context));
        if (activity != null) {
            builder.authorizationStrategyFactory((IAuthorizationStrategyFactory)AndroidAuthorizationStrategyFactory.builder().context(activity.getApplicationContext()).activity(activity).fragment(fragment).browserSelector(new AndroidBrowserSelector(context)).build()).stateGenerator((IStateGenerator)new AndroidTaskStateGenerator(activity.getTaskId()));
        }
    }
}

