/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.util;

import android.app.admin.DevicePolicyManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.UserManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.logging.Logger;
import java.util.Set;

public final class AccountManagerUtil {
    private static final String TAG = AccountManagerUtil.class.getSimpleName();
    private static final String MANIFEST_PERMISSION_MANAGE_ACCOUNTS = "android.permission.MANAGE_ACCOUNTS";

    private AccountManagerUtil() {
    }

    public static boolean canUseAccountManagerOperation(Context context, Set<String> accountTypes) {
        String[] accountTypesWithManagementDisabled;
        String methodTag = TAG + ":canUseAccountManagerOperation:";
        UserManager userManager = (UserManager)context.getSystemService("user");
        if (userManager.hasUserRestriction("no_modify_accounts")) {
            Logger.verbose(methodTag, "UserManager.DISALLOW_MODIFY_ACCOUNTS is enabled for this user.");
            return false;
        }
        DevicePolicyManager devicePolicyManager = AccountManagerUtil.getDevicePolicyManager(context);
        if (devicePolicyManager != null && (accountTypesWithManagementDisabled = devicePolicyManager.getAccountTypesWithManagementDisabled()) != null) {
            for (String disabledAccountType : accountTypesWithManagementDisabled) {
                if (!accountTypes.contains(disabledAccountType)) continue;
                Logger.info(methodTag, "Account type " + disabledAccountType + " is disabled by MDM.");
                return false;
            }
        }
        if (Build.VERSION.SDK_INT >= 23) {
            return true;
        }
        return AccountManagerUtil.isPermissionGranted(context, MANIFEST_PERMISSION_MANAGE_ACCOUNTS);
    }

    @Nullable
    private static DevicePolicyManager getDevicePolicyManager(@NonNull Context context) {
        String methodTag = TAG + ":getDevicePolicyManager";
        try {
            return (DevicePolicyManager)context.getSystemService("device_policy");
        }
        catch (Throwable t) {
            Logger.verbose(methodTag, "Cannot get DevicePolicyManager.");
            return null;
        }
    }

    public static boolean isPermissionGranted(@NonNull Context context, @NonNull String permissionName) {
        String methodTag = TAG + ":isPermissionGranted";
        PackageManager pm = context.getPackageManager();
        boolean isGranted = pm.checkPermission(permissionName, context.getPackageName()) == 0;
        Logger.verbose(methodTag, "is " + permissionName + " granted? [" + isGranted + "]");
        return isGranted;
    }
}

