/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.switchbrowser;

import android.net.Uri;
import com.microsoft.identity.common.internal.ui.webview.switchbrowser.SwitchBrowserUriHelper;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.opentelemetry.SpanExtension;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.logging.Logger;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u000b\u001a\u00020\f2\"\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000ej\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n`\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\nJ6\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\n2$\b\u0002\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000ej\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n`\u000fH\u0002J \u0010\u0018\u001a\u00020\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\nJ\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\nH\u0002R\u001b\u0010\u0003\u001a\u00020\u00048@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/microsoft/identity/common/internal/ui/webview/switchbrowser/SwitchBrowserUriHelper;", "", "()V", "STATE_VALIDATION_REQUIRED", "", "getSTATE_VALIDATION_REQUIRED$common_distRelease", "()Z", "STATE_VALIDATION_REQUIRED$delegate", "Lkotlin/Lazy;", "TAG", "", "addStateToQueryParams", "", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "state", "methodTag", "buildProcessUri", "Landroid/net/Uri;", "uri", "buildResumeUri", "actionUri", "buildSwitchBrowserUri", "isSwitchBrowserRedirectUrl", "url", "redirectUrl", "switchBrowserPath", "statesMatch", "authorizationUrl", "validateActionUri", "actionUriString", "common_distRelease"})
public final class SwitchBrowserUriHelper {
    @NotNull
    public static final SwitchBrowserUriHelper INSTANCE = new SwitchBrowserUriHelper();
    @NotNull
    private static final String TAG = "SwitchBrowserUriHelper";
    @NotNull
    private static final Lazy STATE_VALIDATION_REQUIRED$delegate = LazyKt.lazy((Function0)STATE_VALIDATION_REQUIRED.2.INSTANCE);

    private SwitchBrowserUriHelper() {
    }

    public final boolean getSTATE_VALIDATION_REQUIRED$common_distRelease() {
        Lazy lazy = STATE_VALIDATION_REQUIRED$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final Uri buildProcessUri(@NotNull Uri uri) throws ClientException, IllegalArgumentException, NullPointerException, UnsupportedOperationException {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String methodTag = "SwitchBrowserUriHelper:buildProcessUri";
        String code = uri.getQueryParameter("code");
        CharSequence charSequence = code;
        if (charSequence == null || charSequence.length() == 0) {
            String errorMessage = "switch browser code is null or empty";
            ClientException exception = new ClientException("malformed_url", errorMessage);
            Logger.error(methodTag, errorMessage, exception);
            throw exception;
        }
        String actionUri = uri.getQueryParameter("action_uri");
        CharSequence exception = actionUri;
        if (exception == null || exception.length() == 0) {
            String errorMessage = "switch browser action uri is null or empty";
            ClientException exception2 = new ClientException("malformed_url", errorMessage);
            Logger.error(methodTag, errorMessage, exception2);
            throw exception2;
        }
        this.validateActionUri(actionUri);
        String state = uri.getQueryParameter("state");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        ((Map)queryParams).put("code", code);
        this.addStateToQueryParams(queryParams, state, methodTag);
        return this.buildSwitchBrowserUri(actionUri, queryParams);
    }

    @NotNull
    public final Uri buildResumeUri(@NotNull String actionUri, @Nullable String state) {
        Intrinsics.checkNotNullParameter((Object)actionUri, (String)"actionUri");
        String methodTag = "SwitchBrowserUriHelper:buildResumeUri";
        this.validateActionUri(actionUri);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        this.addStateToQueryParams(queryParams, state, methodTag);
        return this.buildSwitchBrowserUri(actionUri, queryParams);
    }

    public final boolean isSwitchBrowserRedirectUrl(@Nullable String url, @NotNull String redirectUrl, @NotNull String switchBrowserPath) {
        Intrinsics.checkNotNullParameter((Object)redirectUrl, (String)"redirectUrl");
        Intrinsics.checkNotNullParameter((Object)switchBrowserPath, (String)"switchBrowserPath");
        if (url == null) {
            return false;
        }
        String expectedUrl = redirectUrl + '/' + switchBrowserPath;
        return StringsKt.startsWith((String)url, (String)expectedUrl, (boolean)true);
    }

    public final void statesMatch(@NotNull String authorizationUrl, @Nullable String state) {
        ClientException clientException;
        Intrinsics.checkNotNullParameter((Object)authorizationUrl, (String)"authorizationUrl");
        String methodTag = "SwitchBrowserUriHelper:statesMatch";
        if (!this.getSTATE_VALIDATION_REQUIRED$common_distRelease()) {
            Logger.info(methodTag, "State validation is not required.");
            return;
        }
        Span span2 = SpanExtension.current();
        CharSequence charSequence = state;
        if (charSequence == null || charSequence.length() == 0) {
            ClientException clientException2 = new ClientException("state_mismatch", "State is null.");
            span2.setStatus(StatusCode.ERROR);
            span2.recordException((Throwable)clientException2);
            span2.end();
            throw clientException2;
        }
        String authRequestState = Uri.parse((String)authorizationUrl).getQueryParameter("state");
        CharSequence charSequence2 = authRequestState;
        if (charSequence2 == null || charSequence2.length() == 0) {
            clientException = new ClientException("state_mismatch", "Authorization request state is null.");
            span2.setStatus(StatusCode.ERROR);
            span2.recordException((Throwable)clientException);
            span2.end();
            throw clientException;
        }
        if (!Intrinsics.areEqual((Object)state, (Object)authRequestState)) {
            clientException = new ClientException("state_mismatch", "State does not match with the auth request state.");
            span2.setStatus(StatusCode.ERROR);
            span2.recordException((Throwable)clientException);
            span2.end();
            throw clientException;
        }
        Logger.info(methodTag, "States match.");
    }

    private final void addStateToQueryParams(HashMap<String, String> queryParams, String state, String methodTag) {
        if (this.getSTATE_VALIDATION_REQUIRED$common_distRelease()) {
            CharSequence charSequence = state;
            if (charSequence == null || charSequence.length() == 0) {
                String errorMessage = "State is null or empty";
                ClientException exception = new ClientException("missing_parameter", errorMessage);
                Logger.error(methodTag, errorMessage, exception);
                throw exception;
            }
            ((Map)queryParams).put("state", state);
        }
    }

    private final Uri buildSwitchBrowserUri(String actionUri, HashMap<String, String> queryParams) throws IllegalArgumentException, NullPointerException, UnsupportedOperationException {
        Uri uri = Uri.parse((String)actionUri);
        Uri.Builder uriBuilder = uri.buildUpon();
        for (Map.Entry<String, String> entry : queryParams.entrySet()) {
            Intrinsics.checkNotNullExpressionValue(entry, (String)"queryParams.entries");
            String key = entry.getKey();
            String value = entry.getValue();
            uriBuilder.appendQueryParameter(key, value);
        }
        Uri uri2 = uriBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"uriBuilder.build()");
        return uri2;
    }

    static /* synthetic */ Uri buildSwitchBrowserUri$default(SwitchBrowserUriHelper switchBrowserUriHelper, String string2, HashMap hashMap, int n, Object object) throws IllegalArgumentException, NullPointerException, UnsupportedOperationException {
        if ((n & 2) != 0) {
            hashMap = new HashMap<String, String>();
        }
        return switchBrowserUriHelper.buildSwitchBrowserUri(string2, hashMap);
    }

    private final void validateActionUri(String actionUriString) {
        String methodTag = "SwitchBrowserUriHelper:validateActionUri";
        if (!AzureActiveDirectory.isInitialized()) {
            Logger.warn(methodTag, "AzureActiveDirectory is not initialized. Performing cloud discovery.");
            try {
                AzureActiveDirectory.performCloudDiscovery();
            }
            catch (Exception e) {
                String errorMessage = "Failed to perform cloud discovery for AAD authorities.";
                Logger.error(methodTag, errorMessage, e);
                throw new ClientException("io_error", errorMessage, (Throwable)e);
            }
        }
        URL actionUrl = null;
        try {
            actionUrl = new URL(actionUriString);
        }
        catch (MalformedURLException e) {
            String errorMessage = "Malformed action URI: '" + actionUriString + '\'';
            Logger.error(methodTag, errorMessage, e);
            throw new ClientException("malformed_url", errorMessage, (Throwable)e);
        }
        if (!AzureActiveDirectory.isValidCloudHost((URL)actionUrl)) {
            String errorMessage = "Authority '" + actionUrl.getHost() + "' is not a valid AAD authority";
            ClientException exception = new ClientException("unknown_authority", errorMessage);
            Logger.error(methodTag, errorMessage, exception);
            throw exception;
        }
    }
}

