/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.challengehandlers;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.microsoft.identity.common.internal.providers.oauth2.SwitchBrowserActivity;
import com.microsoft.identity.common.internal.ui.browser.AndroidBrowserSelector;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.IChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.SwitchBrowserChallenge;
import com.microsoft.identity.common.internal.ui.webview.switchbrowser.SwitchBrowserUriHelper;
import com.microsoft.identity.common.java.browser.Browser;
import com.microsoft.identity.common.java.browser.IBrowserSelector;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.OTelUtility;
import com.microsoft.identity.common.java.opentelemetry.SpanExtension;
import com.microsoft.identity.common.java.opentelemetry.SpanName;
import com.microsoft.identity.common.java.ui.BrowserDescriptor;
import com.microsoft.identity.common.logging.Logger;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \u001e2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u001eB\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0017\u001a\u00020\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0019J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\u0006\u0010\u001d\u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/microsoft/identity/common/internal/ui/webview/challengehandlers/SwitchBrowserRequestHandler;", "Lcom/microsoft/identity/common/internal/ui/webview/challengehandlers/IChallengeHandler;", "Lcom/microsoft/identity/common/internal/ui/webview/challengehandlers/SwitchBrowserChallenge;", "", "activity", "Landroid/app/Activity;", "spanContext", "Lio/opentelemetry/api/trace/SpanContext;", "(Landroid/app/Activity;Lio/opentelemetry/api/trace/SpanContext;)V", "browserSelector", "Lcom/microsoft/identity/common/java/browser/IBrowserSelector;", "(Landroid/app/Activity;Lcom/microsoft/identity/common/java/browser/IBrowserSelector;Lio/opentelemetry/api/trace/SpanContext;)V", "isSwitchBrowserChallengeActive", "", "()Z", "setSwitchBrowserChallengeActive", "(Z)V", "span", "Lio/opentelemetry/api/trace/Span;", "getSpan", "()Lio/opentelemetry/api/trace/Span;", "span$delegate", "Lkotlin/Lazy;", "isSwitchBrowserRequest", "url", "", "redirectUrl", "processChallenge", "switchBrowserChallenge", "resetChallengeState", "Companion", "common_distRelease"})
public final class SwitchBrowserRequestHandler
implements IChallengeHandler<SwitchBrowserChallenge, Unit> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Activity activity;
    @NotNull
    private final IBrowserSelector browserSelector;
    @Nullable
    private final SpanContext spanContext;
    @NotNull
    private final Lazy span$delegate;
    private boolean isSwitchBrowserChallengeActive;
    @Nullable
    private static final String TAG = Reflection.getOrCreateKotlinClass(SwitchBrowserRequestHandler.class).getSimpleName();

    public SwitchBrowserRequestHandler(@NotNull Activity activity, @NotNull IBrowserSelector browserSelector, @Nullable SpanContext spanContext) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)browserSelector, (String)"browserSelector");
        this.activity = activity;
        this.browserSelector = browserSelector;
        this.spanContext = spanContext;
        this.span$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Span>(this){
            final /* synthetic */ SwitchBrowserRequestHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Span invoke() {
                Span span2 = OTelUtility.createSpanFromParent((String)SpanName.SwitchBrowserProcess.name(), (SpanContext)SwitchBrowserRequestHandler.access$getSpanContext$p(this.this$0));
                Intrinsics.checkNotNullExpressionValue((Object)span2, (String)"createSpanFromParent(Spa\u2026rocess.name, spanContext)");
                return span2;
            }
        }));
    }

    @NotNull
    public final Span getSpan() {
        Lazy lazy = this.span$delegate;
        return (Span)lazy.getValue();
    }

    public final boolean isSwitchBrowserChallengeActive() {
        return this.isSwitchBrowserChallengeActive;
    }

    public final void setSwitchBrowserChallengeActive(boolean bl) {
        this.isSwitchBrowserChallengeActive = bl;
    }

    public SwitchBrowserRequestHandler(@NotNull Activity activity, @Nullable SpanContext spanContext) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this(activity, new AndroidBrowserSelector(activity.getApplicationContext()), spanContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processChallenge(@NotNull SwitchBrowserChallenge switchBrowserChallenge) throws ClientException {
        Intrinsics.checkNotNullParameter((Object)switchBrowserChallenge, (String)"switchBrowserChallenge");
        AutoCloseable autoCloseable = (AutoCloseable)SpanExtension.makeCurrentSpan((Span)this.getSpan());
        Throwable throwable = null;
        try {
            Intent intent;
            Scope it = (Scope)autoCloseable;
            boolean bl = false;
            String methodTag = TAG + ":processChallenge";
            String state = switchBrowserChallenge.getProcessUri().getQueryParameter("state");
            SwitchBrowserUriHelper.INSTANCE.statesMatch(switchBrowserChallenge.getAuthorizationUrl(), state);
            Browser browser = this.browserSelector.selectBrowser(BrowserDescriptor.getBrowserSafeListForSwitchBrowser(), null);
            if (browser == null) {
                ClientException exception = new ClientException("no_browsers_available", "No browser found for SwitchBrowserChallenge.");
                Logger.error(methodTag, "No browser found for SwitchBrowserChallenge.", exception);
                this.getSpan().setStatus(StatusCode.ERROR);
                this.getSpan().recordException((Throwable)exception);
                this.getSpan().end();
                throw exception;
            }
            this.getSpan().setAttribute(AttributeName.browser_package_name.name(), browser.getPackageName());
            this.getSpan().setAttribute(AttributeName.is_custom_tabs_supported.name(), browser.isCustomTabsServiceSupported());
            Intent $this$processChallenge_u24lambda_u241_u24lambda_u240 = intent = new Intent((Context)this.activity, SwitchBrowserActivity.class);
            boolean bl2 = false;
            $this$processChallenge_u24lambda_u241_u24lambda_u240.putExtra("browser_package_name", browser.getPackageName());
            $this$processChallenge_u24lambda_u241_u24lambda_u240.putExtra("browser_supports_custom_tabs", browser.isCustomTabsServiceSupported());
            $this$processChallenge_u24lambda_u241_u24lambda_u240.putExtra("process_uri", switchBrowserChallenge.getProcessUri().toString());
            $this$processChallenge_u24lambda_u241_u24lambda_u240.setFlags(0x10000000);
            Intent switchBrowserIntent = intent;
            this.activity.startActivity(switchBrowserIntent);
            this.getSpan().setStatus(StatusCode.OK);
            this.isSwitchBrowserChallengeActive = true;
            this.getSpan().end();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public final boolean isSwitchBrowserRequest(@Nullable String url, @NotNull String redirectUrl) {
        Intrinsics.checkNotNullParameter((Object)redirectUrl, (String)"redirectUrl");
        return SwitchBrowserUriHelper.INSTANCE.isSwitchBrowserRedirectUrl(url, redirectUrl, "switch_browser");
    }

    public final void resetChallengeState() {
        this.isSwitchBrowserChallengeActive = false;
    }

    public static final /* synthetic */ SpanContext access$getSpanContext$p(SwitchBrowserRequestHandler $this) {
        return $this.spanContext;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/microsoft/identity/common/internal/ui/webview/challengehandlers/SwitchBrowserRequestHandler$Companion;", "", "()V", "TAG", "", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

