/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.crypto.wrappedsecretkey;

import com.microsoft.identity.common.crypto.wrappedsecretkey.AbstractWrappedSecretKeySerializer;
import com.microsoft.identity.common.crypto.wrappedsecretkey.WrappedSecretKey;
import com.microsoft.identity.common.crypto.wrappedsecretkey.WrappedSecretKeyMetadata;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/microsoft/identity/common/crypto/wrappedsecretkey/WrappedSecretKeyBinaryStreamSerializer;", "Lcom/microsoft/identity/common/crypto/wrappedsecretkey/AbstractWrappedSecretKeySerializer;", "()V", "id", "", "getId", "()I", "deserializeMetadata", "Lcom/microsoft/identity/common/crypto/wrappedsecretkey/WrappedSecretKeyMetadata;", "metadataByteArray", "", "serializeMetadata", "wrappedSecretKey", "Lcom/microsoft/identity/common/crypto/wrappedsecretkey/WrappedSecretKey;", "Companion", "common_distRelease"})
public final class WrappedSecretKeyBinaryStreamSerializer
extends AbstractWrappedSecretKeySerializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int id;
    public static final int ID = 1;

    public WrappedSecretKeyBinaryStreamSerializer() {
        this.id = 1;
    }

    @Override
    public int getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public byte[] serializeMetadata(@NotNull WrappedSecretKey wrappedSecretKey) throws IOException {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)wrappedSecretKey, (String)"wrappedSecretKey");
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream bytesOutputStream = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new DataOutputStream(bytesOutputStream);
            Throwable throwable2 = null;
            try {
                DataOutputStream dos = (DataOutputStream)closeable2;
                boolean bl2 = false;
                dos.writeUTF(wrappedSecretKey.getAlgorithm());
                dos.writeUTF(wrappedSecretKey.getCipherTransformation());
                dos.writeInt(wrappedSecretKey.getWrappedKeyData().length);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            byArray = bytesOutputStream.toByteArray();
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"ByteArrayOutputStream().\u2026m.toByteArray()\n        }");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected WrappedSecretKeyMetadata deserializeMetadata(@NotNull byte[] metadataByteArray) throws IOException {
        WrappedSecretKeyMetadata wrappedSecretKeyMetadata;
        Intrinsics.checkNotNullParameter((Object)metadataByteArray, (String)"metadataByteArray");
        Closeable closeable = new ByteArrayInputStream(metadataByteArray);
        Throwable throwable = null;
        try {
            WrappedSecretKeyMetadata wrappedSecretKeyMetadata2;
            ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new DataInputStream(byteArrayInputStream);
            Throwable throwable2 = null;
            try {
                DataInputStream dis = (DataInputStream)closeable2;
                boolean bl2 = false;
                String algorithm = dis.readUTF();
                String cipherTransformation = dis.readUTF();
                int keyLength = dis.readInt();
                Intrinsics.checkNotNullExpressionValue((Object)algorithm, (String)"algorithm");
                Intrinsics.checkNotNullExpressionValue((Object)cipherTransformation, (String)"cipherTransformation");
                wrappedSecretKeyMetadata2 = new WrappedSecretKeyMetadata(algorithm, cipherTransformation, keyLength);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            wrappedSecretKeyMetadata = wrappedSecretKeyMetadata2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return wrappedSecretKeyMetadata;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/microsoft/identity/common/crypto/wrappedsecretkey/WrappedSecretKeyBinaryStreamSerializer$Companion;", "", "()V", "ID", "", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

