/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.crypto.wrappedsecretkey;

import com.microsoft.identity.common.crypto.wrappedsecretkey.IWrappedSecretKeySerializer;
import com.microsoft.identity.common.crypto.wrappedsecretkey.WrappedSecretKey;
import com.microsoft.identity.common.crypto.wrappedsecretkey.WrappedSecretKeyMetadata;
import com.microsoft.identity.common.logging.Logger;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H$J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0004H&\u00a8\u0006\u000e"}, d2={"Lcom/microsoft/identity/common/crypto/wrappedsecretkey/AbstractWrappedSecretKeySerializer;", "Lcom/microsoft/identity/common/crypto/wrappedsecretkey/IWrappedSecretKeySerializer;", "()V", "deserialize", "Lcom/microsoft/identity/common/crypto/wrappedsecretkey/WrappedSecretKey;", "wrappedSecretKeyByteArray", "", "deserializeMetadata", "Lcom/microsoft/identity/common/crypto/wrappedsecretkey/WrappedSecretKeyMetadata;", "metadataByteArray", "serialize", "wrappedSecretKey", "serializeMetadata", "Companion", "common_distRelease"})
public abstract class AbstractWrappedSecretKeySerializer
implements IWrappedSecretKeySerializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TAG = "AbstractWrappedSecretKeySerializer";
    public static final int MAGIC_BYTES_SIZE_BYTES = 4;
    public static final int METADATA_ID_SIZE_BYTES = 4;
    public static final int METADATA_LENGTH_FIELD_SIZE_BYTES = 4;
    public static final int METADATA_FORMAT_MAGIC_BYTES = 16727211;

    @NotNull
    public abstract byte[] serializeMetadata(@NotNull WrappedSecretKey var1);

    @NotNull
    protected abstract WrappedSecretKeyMetadata deserializeMetadata(@NotNull byte[] var1);

    @Override
    @NotNull
    public byte[] serialize(@NotNull WrappedSecretKey wrappedSecretKey) {
        Intrinsics.checkNotNullParameter((Object)wrappedSecretKey, (String)"wrappedSecretKey");
        byte[] metadataBytes = this.serializeMetadata(wrappedSecretKey);
        int bufferSize = 12 + metadataBytes.length + wrappedSecretKey.getWrappedKeyData().length;
        byte[] byArray = ByteBuffer.allocate(bufferSize).putInt(16727211).putInt(this.getId()).putInt(metadataBytes.length).put(metadataBytes).put(wrappedSecretKey.getWrappedKeyData()).array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"allocate(bufferSize)\n   \u2026data\n            .array()");
        return byArray;
    }

    @Override
    @NotNull
    public WrappedSecretKey deserialize(@NotNull byte[] wrappedSecretKeyByteArray) {
        Intrinsics.checkNotNullParameter((Object)wrappedSecretKeyByteArray, (String)"wrappedSecretKeyByteArray");
        String methodTag = "AbstractWrappedSecretKeySerializer:loadFromNewFormat";
        Logger.info(methodTag, "Loading key using metadata format");
        ByteBuffer buffer = ByteBuffer.wrap(wrappedSecretKeyByteArray);
        buffer.getInt();
        buffer.getInt();
        int metadataLength = buffer.getInt();
        byte[] metadataBytes = new byte[metadataLength];
        buffer.get(metadataBytes);
        WrappedSecretKeyMetadata metadata = this.deserializeMetadata(metadataBytes);
        if (metadata.getKeyLength() != buffer.remaining()) {
            Logger.warn(methodTag, "Key data length mismatch. Expected: " + metadata.getKeyLength() + ", Actual: " + buffer.remaining());
        }
        byte[] keyBytes = new byte[buffer.remaining()];
        buffer.get(keyBytes);
        Logger.verbose(methodTag, "Successfully loaded key with algorithm: " + metadata.getAlgorithm() + ", transformation: " + metadata.getCipherTransformation());
        return new WrappedSecretKey(keyBytes, metadata.getAlgorithm(), metadata.getCipherTransformation());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/microsoft/identity/common/crypto/wrappedsecretkey/AbstractWrappedSecretKeySerializer$Companion;", "", "()V", "MAGIC_BYTES_SIZE_BYTES", "", "METADATA_FORMAT_MAGIC_BYTES", "METADATA_ID_SIZE_BYTES", "METADATA_LENGTH_FIELD_SIZE_BYTES", "TAG", "", "getSerializerIdFromByteArray", "wrappedSecretKeyByteArray", "", "([B)Ljava/lang/Integer;", "isSerializedWithMetadata", "", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isSerializedWithMetadata(byte[] wrappedSecretKeyByteArray) {
            String methodTag = "AbstractWrappedSecretKeySerializer:isNewFormat";
            if (wrappedSecretKeyByteArray.length < 12) {
                Logger.warn(methodTag, "Data too small to contain header, assuming legacy format");
                return false;
            }
            int magicBytes = ByteBuffer.wrap(wrappedSecretKeyByteArray, 0, 4).getInt();
            return magicBytes == 16727211;
        }

        @Nullable
        public final Integer getSerializerIdFromByteArray(@NotNull byte[] wrappedSecretKeyByteArray) {
            Intrinsics.checkNotNullParameter((Object)wrappedSecretKeyByteArray, (String)"wrappedSecretKeyByteArray");
            if (!this.isSerializedWithMetadata(wrappedSecretKeyByteArray)) {
                return null;
            }
            return ByteBuffer.wrap(wrappedSecretKeyByteArray, 4, 4).getInt();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

