/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.crypto;

import android.content.Context;
import com.microsoft.identity.common.crypto.AndroidWrappedKeyProvider;
import com.microsoft.identity.common.crypto.KeyStoreBackedSecretKeyProvider;
import com.microsoft.identity.common.java.crypto.key.ISecretKeyProvider;
import com.microsoft.identity.common.java.flighting.CommonFlight;
import com.microsoft.identity.common.java.flighting.CommonFlightsManager;
import com.microsoft.identity.common.java.flighting.IFlightConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/microsoft/identity/common/crypto/KeyStoreBackedSecretKeyProviderFactory;", "", "()V", "create", "Lcom/microsoft/identity/common/java/crypto/key/ISecretKeyProvider;", "keyIdentifier", "", "fileName", "context", "Landroid/content/Context;", "common_distRelease"})
public final class KeyStoreBackedSecretKeyProviderFactory {
    @NotNull
    public static final KeyStoreBackedSecretKeyProviderFactory INSTANCE = new KeyStoreBackedSecretKeyProviderFactory();

    private KeyStoreBackedSecretKeyProviderFactory() {
    }

    @NotNull
    public final ISecretKeyProvider create(@NotNull String keyIdentifier, @NotNull String fileName, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)keyIdentifier, (String)"keyIdentifier");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean enableKeyStoreBackedSecretKeyProvider = CommonFlightsManager.INSTANCE.getFlightsProvider().isFlightEnabled((IFlightConfig)CommonFlight.ENABLE_KEYSTORE_BACKED_SECRET_KEY_PROVIDER);
        return enableKeyStoreBackedSecretKeyProvider ? (ISecretKeyProvider)new KeyStoreBackedSecretKeyProvider(context, keyIdentifier, fileName) : (ISecretKeyProvider)new AndroidWrappedKeyProvider(keyIdentifier, fileName, context);
    }
}

