/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.crypto;

import android.security.keystore.KeyGenParameterSpec;
import com.microsoft.identity.common.crypto.IKeyGenSpec;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0019\u001a\u00020\u0003H\u00c2\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c2\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J[\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u00062\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\u0013\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00060&H\u0002\u00a2\u0006\u0002\u0010'J\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060&H\u0002\u00a2\u0006\u0002\u0010'J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001J\b\u0010)\u001a\u00020\u0006H\u0016R\u0014\u0010\n\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0007\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u0014\u0010\b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/microsoft/identity/common/crypto/KeyGenSpec;", "Lcom/microsoft/identity/common/crypto/IKeyGenSpec;", "purposes", "", "digestAlgorithms", "", "", "keyAlias", "keySize", "description", "algorithm", "encryptionPaddings", "(ILjava/util/List;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getAlgorithm", "()Ljava/lang/String;", "algorithmParameterSpec", "Ljava/security/spec/AlgorithmParameterSpec;", "getAlgorithmParameterSpec", "()Ljava/security/spec/AlgorithmParameterSpec;", "getDescription", "getEncryptionPaddings", "()Ljava/util/List;", "getKeyAlias", "getKeySize", "()I", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "", "getDigestAlgorithms", "", "()[Ljava/lang/String;", "hashCode", "toString", "common_distRelease"})
@SourceDebugExtension(value={"SMAP\nKeyGenSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyGenSpec.kt\ncom/microsoft/identity/common/crypto/KeyGenSpec\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,147:1\n37#2,2:148\n37#2,2:150\n*S KotlinDebug\n*F\n+ 1 KeyGenSpec.kt\ncom/microsoft/identity/common/crypto/KeyGenSpec\n*L\n77#1:148,2\n84#1:150,2\n*E\n"})
public final class KeyGenSpec
implements IKeyGenSpec {
    private final int purposes;
    @NotNull
    private final List<String> digestAlgorithms;
    @NotNull
    private final String keyAlias;
    private final int keySize;
    @NotNull
    private final String description;
    @NotNull
    private final String algorithm;
    @NotNull
    private final List<String> encryptionPaddings;
    @NotNull
    private final AlgorithmParameterSpec algorithmParameterSpec;

    public KeyGenSpec(int purposes, @NotNull List<String> digestAlgorithms, @NotNull String keyAlias, int keySize, @NotNull String description, @NotNull String algorithm, @NotNull List<String> encryptionPaddings) {
        Intrinsics.checkNotNullParameter(digestAlgorithms, (String)"digestAlgorithms");
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter(encryptionPaddings, (String)"encryptionPaddings");
        this.purposes = purposes;
        this.digestAlgorithms = digestAlgorithms;
        this.keyAlias = keyAlias;
        this.keySize = keySize;
        this.description = description;
        this.algorithm = algorithm;
        this.encryptionPaddings = encryptionPaddings;
        String[] stringArray = this.getDigestAlgorithms();
        KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(this.getKeyAlias(), this.purposes).setKeySize(this.getKeySize()).setDigests(Arrays.copyOf(stringArray, stringArray.length));
        stringArray = this.getEncryptionPaddings();
        KeyGenParameterSpec keyGenParameterSpec = builder.setEncryptionPaddings(Arrays.copyOf(stringArray, stringArray.length)).build();
        Intrinsics.checkNotNullExpressionValue((Object)keyGenParameterSpec, (String)"Builder(keyAlias, purpos\u2026s())\n            .build()");
        this.algorithmParameterSpec = (AlgorithmParameterSpec)keyGenParameterSpec;
    }

    @Override
    @NotNull
    public String getKeyAlias() {
        return this.keyAlias;
    }

    @Override
    public int getKeySize() {
        return this.keySize;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    @NotNull
    public List<String> getEncryptionPaddings() {
        return this.encryptionPaddings;
    }

    @NotNull
    public String toString() {
        return this.print();
    }

    private final String[] getDigestAlgorithms() {
        Collection $this$toTypedArray$iv = this.digestAlgorithms;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    private final String[] getEncryptionPaddings() {
        Collection $this$toTypedArray$iv = this.getEncryptionPaddings();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    @Override
    @NotNull
    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return this.algorithmParameterSpec;
    }

    @Override
    @NotNull
    public String print() {
        return IKeyGenSpec.DefaultImpls.print(this);
    }

    private final int component1() {
        return this.purposes;
    }

    private final List<String> component2() {
        return this.digestAlgorithms;
    }

    @NotNull
    public final String component3() {
        return this.getKeyAlias();
    }

    public final int component4() {
        return this.getKeySize();
    }

    @NotNull
    public final String component5() {
        return this.getDescription();
    }

    @NotNull
    public final String component6() {
        return this.getAlgorithm();
    }

    @NotNull
    public final List<String> component7() {
        return this.getEncryptionPaddings();
    }

    @NotNull
    public final KeyGenSpec copy(int purposes, @NotNull List<String> digestAlgorithms, @NotNull String keyAlias, int keySize, @NotNull String description, @NotNull String algorithm, @NotNull List<String> encryptionPaddings) {
        Intrinsics.checkNotNullParameter(digestAlgorithms, (String)"digestAlgorithms");
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter(encryptionPaddings, (String)"encryptionPaddings");
        return new KeyGenSpec(purposes, digestAlgorithms, keyAlias, keySize, description, algorithm, encryptionPaddings);
    }

    public static /* synthetic */ KeyGenSpec copy$default(KeyGenSpec keyGenSpec, int n, List list, String string, int n2, String string2, String string3, List list2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = keyGenSpec.purposes;
        }
        if ((n3 & 2) != 0) {
            list = keyGenSpec.digestAlgorithms;
        }
        if ((n3 & 4) != 0) {
            string = keyGenSpec.getKeyAlias();
        }
        if ((n3 & 8) != 0) {
            n2 = keyGenSpec.getKeySize();
        }
        if ((n3 & 0x10) != 0) {
            string2 = keyGenSpec.getDescription();
        }
        if ((n3 & 0x20) != 0) {
            string3 = keyGenSpec.getAlgorithm();
        }
        if ((n3 & 0x40) != 0) {
            list2 = keyGenSpec.getEncryptionPaddings();
        }
        return keyGenSpec.copy(n, list, string, n2, string2, string3, list2);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.purposes);
        result = result * 31 + ((Object)this.digestAlgorithms).hashCode();
        result = result * 31 + this.getKeyAlias().hashCode();
        result = result * 31 + Integer.hashCode(this.getKeySize());
        result = result * 31 + this.getDescription().hashCode();
        result = result * 31 + this.getAlgorithm().hashCode();
        result = result * 31 + ((Object)this.getEncryptionPaddings()).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KeyGenSpec)) {
            return false;
        }
        KeyGenSpec keyGenSpec = (KeyGenSpec)other;
        if (this.purposes != keyGenSpec.purposes) {
            return false;
        }
        if (!Intrinsics.areEqual(this.digestAlgorithms, keyGenSpec.digestAlgorithms)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getKeyAlias(), (Object)keyGenSpec.getKeyAlias())) {
            return false;
        }
        if (this.getKeySize() != keyGenSpec.getKeySize()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getDescription(), (Object)keyGenSpec.getDescription())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getAlgorithm(), (Object)keyGenSpec.getAlgorithm())) {
            return false;
        }
        return Intrinsics.areEqual(this.getEncryptionPaddings(), keyGenSpec.getEncryptionPaddings());
    }
}

