/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.crypto;

import android.content.Context;
import android.os.Build;
import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.crypto.CipherSpec;
import com.microsoft.identity.common.crypto.CryptoParameterSpecFactory;
import com.microsoft.identity.common.crypto.IKeyGenSpec;
import com.microsoft.identity.common.crypto.KeyGenSpec;
import com.microsoft.identity.common.crypto.LegacyKeyGenSpec;
import com.microsoft.identity.common.java.flighting.CommonFlight;
import com.microsoft.identity.common.java.flighting.CommonFlightsManager;
import com.microsoft.identity.common.java.flighting.IFlightConfig;
import com.microsoft.identity.common.java.flighting.IFlightsProvider;
import com.microsoft.identity.common.logging.Logger;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u001fH\u0002J\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001fJ\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001fR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0017\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0016\u001a\u0004\b\u0018\u0010\u0014R\u0014\u0010\u001a\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\fR\u0014\u0010\u001c\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\f\u00a8\u0006%"}, d2={"Lcom/microsoft/identity/common/crypto/CryptoParameterSpecFactory;", "", "context", "Landroid/content/Context;", "keyAlias", "", "flightsProvider", "Lcom/microsoft/identity/common/java/flighting/IFlightsProvider;", "(Landroid/content/Context;Ljava/lang/String;Lcom/microsoft/identity/common/java/flighting/IFlightsProvider;)V", "enableKeyGenEncryptionPaddingRsaOaep", "", "getEnableKeyGenEncryptionPaddingRsaOaep", "()Z", "getFlightsProvider", "()Lcom/microsoft/identity/common/java/flighting/IFlightsProvider;", "keyGenParamSpecLegacy", "Lcom/microsoft/identity/common/crypto/LegacyKeyGenSpec;", "keyGenParamSpecWithPurposeWrapKey", "Lcom/microsoft/identity/common/crypto/KeyGenSpec;", "getKeyGenParamSpecWithPurposeWrapKey", "()Lcom/microsoft/identity/common/crypto/KeyGenSpec;", "keyGenParamSpecWithPurposeWrapKey$delegate", "Lkotlin/Lazy;", "keyGenParamSpecWithoutPurposeWrapKey", "getKeyGenParamSpecWithoutPurposeWrapKey", "keyGenParamSpecWithoutPurposeWrapKey$delegate", "keySpecWithWrapPurposeKey", "getKeySpecWithWrapPurposeKey", "keySpecWithoutWrapPurposeKey", "getKeySpecWithoutWrapPurposeKey", "getEncryptionPaddingsForKeyGen", "", "getPrioritizedCipherParameterSpecs", "Lcom/microsoft/identity/common/crypto/CipherSpec;", "getPrioritizedKeyGenParameterSpecs", "Lcom/microsoft/identity/common/crypto/IKeyGenSpec;", "Companion", "common_distRelease"})
public final class CryptoParameterSpecFactory {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final IFlightsProvider flightsProvider;
    @RequiresApi(value=28)
    @NotNull
    private final Lazy keyGenParamSpecWithPurposeWrapKey$delegate;
    @NotNull
    private final Lazy keyGenParamSpecWithoutPurposeWrapKey$delegate;
    @NotNull
    private final LegacyKeyGenSpec keyGenParamSpecLegacy;
    @Deprecated
    private static final String TAG = CryptoParameterSpecFactory.class.getSimpleName();
    @Deprecated
    @NotNull
    private static final String RSA_ALGORITHM = "RSA";
    @Deprecated
    private static final int KEY_SIZE = 2048;
    @Deprecated
    @NotNull
    private static final String MODERN_SPEC_WITH_PURPOSE_WRAP_KEY = "modern_spec_with_wrap_key";
    @Deprecated
    @NotNull
    private static final String MODERN_SPEC_WITHOUT_PURPOSE_WRAP_KEY = "modern_spec_without_wrap_key";
    @Deprecated
    @NotNull
    private static final String LEGACY_SPEC = "legacy_key_gen_spec";

    public CryptoParameterSpecFactory(@NotNull Context context, @NotNull String keyAlias, @NotNull IFlightsProvider flightsProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        Intrinsics.checkNotNullParameter((Object)flightsProvider, (String)"flightsProvider");
        this.flightsProvider = flightsProvider;
        String methodTag = TAG + ":init";
        Logger.verbose(methodTag, "Initialized CryptoParameterSpecFactory - API: " + Build.VERSION.SDK_INT + ", flags: [keySpecWithWrapPurposeKey=" + this.getKeySpecWithWrapPurposeKey() + ", keySpecWithoutWrapPurposeKey=" + this.getKeySpecWithoutWrapPurposeKey() + ", oaepSupported=" + this.getEnableKeyGenEncryptionPaddingRsaOaep() + ']');
        this.keyGenParamSpecWithPurposeWrapKey$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KeyGenSpec>(this, keyAlias){
            final /* synthetic */ CryptoParameterSpecFactory this$0;
            final /* synthetic */ String $keyAlias;
            {
                this.this$0 = $receiver;
                this.$keyAlias = $keyAlias;
                super(0);
            }

            @NotNull
            public final KeyGenSpec invoke() {
                Object object = new String[]{"SHA-256", "SHA-512"};
                List list = CollectionsKt.listOf((Object[])object);
                object = CryptoParameterSpecFactory.access$getEncryptionPaddingsForKeyGen(this.this$0);
                return new KeyGenSpec(35, list, this.$keyAlias, 2048, "modern_spec_with_wrap_key", "RSA", (List<String>)object);
            }
        }));
        this.keyGenParamSpecWithoutPurposeWrapKey$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KeyGenSpec>(this, keyAlias){
            final /* synthetic */ CryptoParameterSpecFactory this$0;
            final /* synthetic */ String $keyAlias;
            {
                this.this$0 = $receiver;
                this.$keyAlias = $keyAlias;
                super(0);
            }

            @NotNull
            public final KeyGenSpec invoke() {
                Object object = new String[]{"SHA-256", "SHA-512"};
                List list = CollectionsKt.listOf((Object[])object);
                object = CryptoParameterSpecFactory.access$getEncryptionPaddingsForKeyGen(this.this$0);
                return new KeyGenSpec(3, list, this.$keyAlias, 2048, "modern_spec_without_wrap_key", "RSA", (List<String>)object);
            }
        }));
        List list = CollectionsKt.listOf((Object)"PKCS1Padding");
        this.keyGenParamSpecLegacy = new LegacyKeyGenSpec(context, keyAlias, 2048, LEGACY_SPEC, RSA_ALGORITHM, list);
    }

    public /* synthetic */ CryptoParameterSpecFactory(Context context, String string, IFlightsProvider iFlightsProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            iFlightsProvider = CommonFlightsManager.INSTANCE.getFlightsProvider();
        }
        this(context, string, iFlightsProvider);
    }

    @NotNull
    public final IFlightsProvider getFlightsProvider() {
        return this.flightsProvider;
    }

    private final boolean getKeySpecWithWrapPurposeKey() {
        return this.flightsProvider.isFlightEnabled((IFlightConfig)CommonFlight.ENABLE_NEW_KEY_GEN_SPEC_FOR_WRAP_WITH_PURPOSE_WRAP_KEY);
    }

    private final boolean getKeySpecWithoutWrapPurposeKey() {
        return this.flightsProvider.isFlightEnabled((IFlightConfig)CommonFlight.ENABLE_NEW_KEY_GEN_SPEC_FOR_WRAP_WITHOUT_PURPOSE_WRAP_KEY);
    }

    private final boolean getEnableKeyGenEncryptionPaddingRsaOaep() {
        return this.flightsProvider.isFlightEnabled((IFlightConfig)CommonFlight.ENABLE_OAEP_WITH_SHA_AND_MGF1_PADDING);
    }

    private final KeyGenSpec getKeyGenParamSpecWithPurposeWrapKey() {
        Lazy lazy = this.keyGenParamSpecWithPurposeWrapKey$delegate;
        return (KeyGenSpec)lazy.getValue();
    }

    private final KeyGenSpec getKeyGenParamSpecWithoutPurposeWrapKey() {
        Lazy lazy = this.keyGenParamSpecWithoutPurposeWrapKey$delegate;
        return (KeyGenSpec)lazy.getValue();
    }

    private final List<String> getEncryptionPaddingsForKeyGen() {
        Object[] objectArray = new String[]{"PKCS1Padding"};
        List paddings = CollectionsKt.mutableListOf((Object[])objectArray);
        if (this.getEnableKeyGenEncryptionPaddingRsaOaep()) {
            paddings.add("OAEPPadding");
        }
        return paddings;
    }

    @NotNull
    public final List<CipherSpec> getPrioritizedCipherParameterSpecs() {
        String methodTag = TAG + ":getPrioritizedCipherParameterSpecs";
        Object[] objectArray = new CipherSpec[]{CipherSpec.Companion.getOaepCipherSpec(), CipherSpec.Companion.getPkcs1CipherSpec()};
        List specs = CollectionsKt.listOf((Object[])objectArray);
        Logger.info(methodTag, "Ciphers: " + specs);
        return specs;
    }

    @NotNull
    public final List<IKeyGenSpec> getPrioritizedKeyGenParameterSpecs() {
        String methodTag = TAG + ":getPrioritizedKeyGenParameterSpecs";
        List specs = new ArrayList();
        if (Build.VERSION.SDK_INT >= 28 && this.getKeySpecWithWrapPurposeKey()) {
            specs.add(this.getKeyGenParamSpecWithPurposeWrapKey());
        }
        if (this.getKeySpecWithoutWrapPurposeKey()) {
            specs.add(this.getKeyGenParamSpecWithoutPurposeWrapKey());
        }
        specs.add(this.keyGenParamSpecLegacy);
        Logger.info(methodTag, "Key generation specs: " + CollectionsKt.joinToString$default((Iterable)specs, null, null, null, (int)0, null, (Function1)getPrioritizedKeyGenParameterSpecs.1.INSTANCE, (int)31, null));
        return specs;
    }

    public static final /* synthetic */ List access$getEncryptionPaddingsForKeyGen(CryptoParameterSpecFactory $this) {
        return $this.getEncryptionPaddingsForKeyGen();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u000b*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/microsoft/identity/common/crypto/CryptoParameterSpecFactory$Companion;", "", "()V", "KEY_SIZE", "", "LEGACY_SPEC", "", "MODERN_SPEC_WITHOUT_PURPOSE_WRAP_KEY", "MODERN_SPEC_WITH_PURPOSE_WRAP_KEY", "RSA_ALGORITHM", "TAG", "kotlin.jvm.PlatformType", "common_distRelease"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

